/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.components;

import com.plotsquared.core.configuration.serialization.ConfigurationSerializable;
import com.plotsquared.core.configuration.serialization.SerializableAs;
import com.plotsquared.core.generator.ClassicPlotManagerComponent;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

@SerializableAs(value="preset")
public record ComponentPreset(ClassicPlotManagerComponent component, String pattern, double cost, String permission, String displayName, List<String> description, ItemType icon) implements ConfigurationSerializable
{
    public static ComponentPreset deserialize(@NonNull Map<String, Object> map) {
        ClassicPlotManagerComponent classicPlotManagerComponent = ClassicPlotManagerComponent.fromString(map.getOrDefault("component", "").toString()).orElseThrow(() -> new IllegalArgumentException("The preset in components.yml needs a valid target component, got: " + String.valueOf(map.get("component"))));
        String pattern = map.getOrDefault("pattern", "").toString();
        double cost = Double.parseDouble(map.getOrDefault("cost", "0.0").toString());
        String permission = map.getOrDefault("permission", "").toString();
        String displayName = map.getOrDefault("name", "New Package").toString();
        List description = map.getOrDefault("description", new ArrayList());
        ItemType icon = ItemTypes.get((String)map.getOrDefault("icon", "dirt").toString());
        return new ComponentPreset(classicPlotManagerComponent, pattern, cost, permission, displayName, description, icon);
    }

    @Override
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("component", this.component.name().toLowerCase());
        map.put("pattern", this.pattern);
        map.put("cost", this.cost);
        map.put("permission", this.permission);
        map.put("name", this.displayName);
        map.put("description", this.description);
        map.put("icon", this.icon.getId().replace("minecraft:", ""));
        return map;
    }
}

