/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.MemorySection;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.annotations.WorldFile;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.world.PlotAreaManager;
import java.io.File;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="reload", aliases={"rl"}, permission="plots.admin.command.reload", usage="/plot reload", category=CommandCategory.ADMINISTRATION)
public class Reload
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private YamlConfiguration worldConfiguration;
    private File worldFile;

    @Inject
    public Reload(@NonNull PlotAreaManager plotAreaManager, @WorldConfig @NonNull YamlConfiguration worldConfiguration, @WorldFile @NonNull File worldFile) {
        this.plotAreaManager = plotAreaManager;
        this.worldConfiguration = worldConfiguration;
        this.worldFile = worldFile;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        try {
            PlotSquared.get().setupConfigs();
            this.worldConfiguration = PlotSquared.get().getWorldConfiguration();
            this.worldFile = PlotSquared.get().getWorldsFile();
            PlotSquared.get().loadCaptionMap();
            this.plotAreaManager.forEachPlotArea(area -> {
                ConfigurationSection worldSection = this.worldConfiguration.getConfigurationSection("worlds." + area.getWorldName());
                if (worldSection == null) {
                    return;
                }
                if (area.getType() != PlotAreaType.PARTIAL || !worldSection.contains("areas")) {
                    area.saveConfiguration(worldSection);
                    area.loadDefaultConfiguration(worldSection);
                } else {
                    ConfigurationSection areaSection = worldSection.getConfigurationSection("areas." + area.getId() + "-" + String.valueOf(area.getMin()) + "-" + String.valueOf(area.getMax()));
                    YamlConfiguration clone = new YamlConfiguration();
                    for (String key : areaSection.getKeys(true)) {
                        if (areaSection.get(key) instanceof MemorySection || clone.contains(key)) continue;
                        clone.set(key, areaSection.get(key));
                    }
                    for (String key : worldSection.getKeys(true)) {
                        if (worldSection.get(key) instanceof MemorySection || key.startsWith("areas") || clone.contains(key)) continue;
                        clone.set(key, worldSection.get(key));
                    }
                    area.saveConfiguration(clone);
                    for (String key : clone.getKeys(true)) {
                        if (clone.get(key) instanceof MemorySection) continue;
                        if (!worldSection.contains(key)) {
                            worldSection.set(key, clone.get(key));
                            continue;
                        }
                        Object value = worldSection.get(key);
                        if (!Objects.equals(value, clone.get(key))) continue;
                        areaSection.set(key, clone.get(key));
                    }
                    area.loadDefaultConfiguration(clone);
                }
            });
            this.worldConfiguration.save(this.worldFile);
            player.sendMessage((Caption)TranslatableCaption.of("reload.reloaded_configs"), new TagResolver[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            player.sendMessage((Caption)TranslatableCaption.of("reload.reload_failed"), new TagResolver[0]);
        }
        return true;
    }
}

