/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.PriceFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.StringComparison;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.query.SortingStrategy;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.core.uuid.UUIDMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="list", aliases={"l", "find", "search"}, permission="plots.list", category=CommandCategory.INFO, usage="/plot list <forsale | mine | shared | world | top | all | unowned | player | world | done | fuzzy <search...>> [#]")
public class ListCmd
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EconHandler econHandler;

    @Inject
    public ListCmd(@NonNull PlotAreaManager plotAreaManager, @NonNull EconHandler econHandler) {
        this.plotAreaManager = plotAreaManager;
        this.econHandler = econHandler;
    }

    private String[] getArgumentList(PlotPlayer<?> player) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.econHandler != null && player.hasPermission(Permission.PERMISSION_LIST_FOR_SALE)) {
            args.add("forsale");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_MINE)) {
            args.add("mine");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_SHARED)) {
            args.add("shared");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
            args.add("world");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_TOP)) {
            args.add("top");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_ALL)) {
            args.add("all");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_UNOWNED)) {
            args.add("unowned");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_PLAYER)) {
            args.add("<player>");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
            args.add("<world>");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_DONE)) {
            args.add("done");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_EXPIRED)) {
            args.add("expired");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_FUZZY)) {
            args.add("fuzzy <search...>");
        }
        return args.toArray(new String[args.size()]);
    }

    public void noArgs(PlotPlayer<?> player) {
        player.sendMessage((Caption)TranslatableCaption.of("commandconfig.subcommand_set_options_header"), new TagResolver[]{TagResolver.resolver((String)"values", (Tag)Tag.inserting((Component)Component.text((String)Arrays.toString(this.getArgumentList(player)))))});
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        int page;
        if (args.length < 1) {
            this.noArgs(player);
            return false;
        }
        if (args.length > 1) {
            int tempPage = -1;
            try {
                tempPage = Integer.parseInt(args[args.length - 1]);
                if (--tempPage < 0) {
                    tempPage = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            page = tempPage;
        } else {
            page = 0;
        }
        String world = player.getLocation().getWorldName();
        PlotArea area = player.getApplicablePlotArea();
        String arg = args[0].toLowerCase();
        boolean[] sort = new boolean[]{true};
        Consumer<PlotQuery> plotConsumer = query -> {
            List<Plot> plots;
            if (query == null) {
                player.sendMessage((Caption)TranslatableCaption.of("commandconfig.did_you_mean"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)new StringComparison<String>(args[0], new String[]{"mine", "shared", "world", "all"}).getBestMatch())))});
                return;
            }
            if (area != null) {
                query.relativeToArea(area);
            }
            if (sort[0]) {
                query.withSortingStrategy(SortingStrategy.SORT_BY_CREATION);
            }
            if ((plots = query.asList()).isEmpty()) {
                player.sendMessage((Caption)TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
                return;
            }
            this.displayPlots(player, plots, 12, page, args);
        };
        switch (arg) {
            case "mine": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_MINE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.mine")))});
                    return false;
                }
                sort[0] = false;
                plotConsumer.accept(PlotQuery.newQuery().ownersInclude(player).whereBasePlot().withSortingStrategy(SortingStrategy.SORT_BY_TEMP));
                break;
            }
            case "shared": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_SHARED)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.shared")))});
                    return false;
                }
                plotConsumer.accept(PlotQuery.newQuery().withMember(player.getUUID()).thatPasses(plot -> !plot.isOwnerAbs(player.getUUID())));
                break;
            }
            case "world": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.world")))});
                    return false;
                }
                if (!player.hasPermission("plots.list.world." + world)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)("plots.list.world." + world))))});
                    return false;
                }
                plotConsumer.accept(PlotQuery.newQuery().inWorld(world));
                break;
            }
            case "expired": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_EXPIRED)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.expired")))});
                    return false;
                }
                if (PlotSquared.platform().expireManager() == null) {
                    plotConsumer.accept(PlotQuery.newQuery().noPlots());
                    break;
                }
                plotConsumer.accept(PlotQuery.newQuery().expiredPlots());
                break;
            }
            case "area": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_AREA)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.area")))});
                    return false;
                }
                if (!player.hasPermission("plots.list.world." + world)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)("plots.list.world." + world))))});
                    return false;
                }
                if (area == null) {
                    plotConsumer.accept(PlotQuery.newQuery().noPlots());
                    break;
                }
                plotConsumer.accept(PlotQuery.newQuery().inArea(area));
                break;
            }
            case "all": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_ALL)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.all")))});
                    return false;
                }
                plotConsumer.accept(PlotQuery.newQuery().allPlots());
                break;
            }
            case "done": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_DONE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.done")))});
                    return false;
                }
                sort[0] = false;
                plotConsumer.accept(PlotQuery.newQuery().allPlots().thatPasses(DoneFlag::isDone).withSortingStrategy(SortingStrategy.SORT_BY_DONE));
                break;
            }
            case "top": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_TOP)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.top")))});
                    return false;
                }
                sort[0] = false;
                plotConsumer.accept(PlotQuery.newQuery().allPlots().withSortingStrategy(SortingStrategy.SORT_BY_RATING));
                break;
            }
            case "forsale": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_FOR_SALE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.forsale")))});
                    return false;
                }
                if (this.econHandler.isSupported()) break;
                plotConsumer.accept(PlotQuery.newQuery().allPlots().thatPasses(plot -> (Double)plot.getFlag(PriceFlag.class) > 0.0));
                break;
            }
            case "unowned": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_UNOWNED)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.unowned")))});
                    return false;
                }
                plotConsumer.accept(PlotQuery.newQuery().allPlots().thatPasses(plot -> plot.getOwner() == null));
                break;
            }
            case "fuzzy": {
                if (!player.hasPermission(Permission.PERMISSION_LIST_FUZZY)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.fuzzy")))});
                    return false;
                }
                if (args.length < (page == -1 ? 2 : 3)) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot list fuzzy <search...> [#]")))});
                    return false;
                }
                String term = MathMan.isInteger(args[args.length - 1]) ? StringMan.join(Arrays.copyOfRange(args, 1, args.length - 1), " ") : StringMan.join(Arrays.copyOfRange(args, 1, args.length), " ");
                sort[0] = false;
                plotConsumer.accept(PlotQuery.newQuery().plotsBySearch(term));
                break;
            }
            default: {
                if (this.plotAreaManager.hasPlotArea(args[0])) {
                    if (!player.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
                        player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.world")))});
                        return false;
                    }
                    if (!player.hasPermission("plots.list.world." + args[0])) {
                        player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)("plots.list.world." + args[0]))))});
                        return false;
                    }
                    plotConsumer.accept(PlotQuery.newQuery().inWorld(args[0]));
                    break;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(args[0], (uuid, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else if (throwable != null && uuid == null) {
                        try {
                            uuid = UUID.fromString(args[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (uuid == null) {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[0])))});
                    } else if (!player.hasPermission(Permission.PERMISSION_LIST_PLAYER)) {
                        player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.list.player")))});
                    } else {
                        sort[0] = false;
                        plotConsumer.accept(PlotQuery.newQuery().ownersInclude((UUID)uuid).whereBasePlot().withSortingStrategy(SortingStrategy.SORT_BY_TEMP));
                    }
                });
            }
        }
        return true;
    }

    public void displayPlots(final PlotPlayer<?> player, List<Plot> plots, int pageSize, int page, String[] args) {
        plots.removeIf(plot -> !plot.isBasePlot());
        this.paginate(player, plots, pageSize, page, new RunnableVal3<Integer, Plot, CaptionHolder>(){

            @Override
            public void run(Integer i, Plot plot, CaptionHolder caption) {
                TranslatableCaption color = plot.getOwner() == null ? TranslatableCaption.of("info.plot_list_no_owner") : (plot.isOwner(player.getUUID()) || plot.getOwner().equals(DBFunc.EVERYONE) ? TranslatableCaption.of("info.plot_list_owned_by") : (plot.isAdded(player.getUUID()) ? TranslatableCaption.of("info.plot_list_added_to") : (plot.isDenied(player.getUUID()) ? TranslatableCaption.of("info.plot_list_denied_on") : TranslatableCaption.of("info.plot_list_default"))));
                Component trusted = Command.MINI_MESSAGE.deserialize(TranslatableCaption.of("info.plot_info_trusted").getComponent(player), (TagResolver)TagResolver.resolver((String)"trusted", (Tag)Tag.inserting((Component)PlayerManager.getPlayerList(plot.getTrusted(), player))));
                Component members = Command.MINI_MESSAGE.deserialize(TranslatableCaption.of("info.plot_info_members").getComponent(player), (TagResolver)TagResolver.resolver((String)"members", (Tag)Tag.inserting((Component)PlayerManager.getPlayerList(plot.getMembers(), player))));
                TagResolver.Builder finalResolver = TagResolver.builder();
                finalResolver.tag("command_tp", (Tag)Tag.preProcessParsed((String)("/plot visit " + String.valueOf(plot.getArea()) + ";" + String.valueOf(plot.getId()))));
                finalResolver.tag("command_info", (Tag)Tag.preProcessParsed((String)("/plot info " + String.valueOf(plot.getArea()) + ";" + String.valueOf(plot.getId()))));
                finalResolver.tag("hover_info", Tag.inserting((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(trusted)).append((Component)Component.newline())).append(members)).asComponent()));
                finalResolver.tag("number", Tag.inserting((Component)Component.text((int)i)));
                finalResolver.tag("plot", Tag.inserting((Component)Command.MINI_MESSAGE.deserialize(color.getComponent(player), (TagResolver)TagResolver.resolver((String)"plot", (Tag)Tag.inserting((Component)Component.text((String)plot.toString()))))));
                String prefix = "";
                String online = TranslatableCaption.of("info.plot_list_player_online").getComponent(player);
                String offline = TranslatableCaption.of("info.plot_list_player_offline").getComponent(player);
                String unknown = TranslatableCaption.of("info.plot_list_player_unknown").getComponent(player);
                String server = TranslatableCaption.of("info.plot_list_player_server").getComponent(player);
                String everyone = TranslatableCaption.of("info.plot_list_player_everyone").getComponent(player);
                TextComponent.Builder builder = Component.text();
                if (((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue()) {
                    TagResolver.Single serverResolver = TagResolver.resolver((String)"server", (Tag)Tag.inserting((Component)TranslatableCaption.of("info.server").toComponent(player)));
                    builder.append(Command.MINI_MESSAGE.deserialize(server, (TagResolver)serverResolver));
                } else {
                    try {
                        List<UUIDMapping> names = PlotSquared.get().getImpromptuUUIDPipeline().getNames(plot.getOwners()).get(Settings.UUID.BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS);
                        for (UUIDMapping uuidMapping : names) {
                            PlotPlayer<?> pp = PlotSquared.platform().playerManager().getPlayerIfExists(uuidMapping.uuid());
                            TagResolver resolver = TagResolver.builder().tag("prefix", Tag.inserting((Component)Component.text((String)prefix))).tag("player", Tag.inserting((Component)Component.text((String)uuidMapping.username()))).build();
                            if (pp != null) {
                                builder.append(Command.MINI_MESSAGE.deserialize(online, resolver));
                            } else if (uuidMapping.username().equalsIgnoreCase("unknown")) {
                                TagResolver.Single unknownResolver = TagResolver.resolver((String)"unknown", (Tag)Tag.inserting((Component)TranslatableCaption.of("info.unknown").toComponent(player)));
                                builder.append(Command.MINI_MESSAGE.deserialize(unknown, (TagResolver)unknownResolver));
                            } else if (uuidMapping.uuid().equals(DBFunc.EVERYONE)) {
                                TagResolver.Single everyoneResolver = TagResolver.resolver((String)"everyone", (Tag)Tag.inserting((Component)TranslatableCaption.of("info.everyone").toComponent(player)));
                                builder.append(Command.MINI_MESSAGE.deserialize(everyone, (TagResolver)everyoneResolver));
                            } else {
                                builder.append(Command.MINI_MESSAGE.deserialize(offline, resolver));
                            }
                            prefix = ", ";
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        StringBuilder playerBuilder = new StringBuilder();
                        Iterator<UUID> uuidIterator = plot.getOwners().iterator();
                        while (uuidIterator.hasNext()) {
                            UUID uuid = uuidIterator.next();
                            playerBuilder.append(uuid);
                            if (!uuidIterator.hasNext()) continue;
                            playerBuilder.append(", ");
                        }
                        player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)playerBuilder.toString())))});
                    }
                    catch (TimeoutException e) {
                        player.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    }
                }
                finalResolver.tag("players", Tag.inserting((Component)builder.asComponent()));
                finalResolver.tag("size", Tag.inserting((Component)Component.text((int)plot.getConnectedPlots().size())));
                caption.set(TranslatableCaption.of("info.plot_list_item"));
                caption.setTagResolvers(finalResolver.build());
            }
        }, "/plot list " + args[0], TranslatableCaption.of("list.plot_list_header_paged"));
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        LinkedList<String> completions = new LinkedList<String>();
        if (this.econHandler.isSupported() && player.hasPermission(Permission.PERMISSION_LIST_FOR_SALE)) {
            completions.add("forsale");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_MINE)) {
            completions.add("mine");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_SHARED)) {
            completions.add("shared");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
            completions.addAll(PlotSquared.platform().worldManager().getWorlds());
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_TOP)) {
            completions.add("top");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_ALL)) {
            completions.add("all");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_UNOWNED)) {
            completions.add("unowned");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_DONE)) {
            completions.add("done");
        }
        if (player.hasPermission(Permission.PERMISSION_LIST_EXPIRED)) {
            completions.add("expired");
        }
        List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.NONE, CommandCategory.TELEPORT){}).collect(Collectors.toCollection(LinkedList::new));
        if (player.hasPermission(Permission.PERMISSION_LIST_PLAYER) && args[0].length() > 0) {
            commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
        }
        return commands;
    }
}

