/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.BasicQueueCoordinator;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RegionManager {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + RegionManager.class.getSimpleName()));
    public static RegionManager manager = null;
    protected final WorldUtil worldUtil;
    private final GlobalBlockQueue blockQueue;
    private final ProgressSubscriberFactory subscriberFactory;

    @Inject
    public RegionManager(@NonNull WorldUtil worldUtil, @NonNull GlobalBlockQueue blockQueue, @NonNull ProgressSubscriberFactory subscriberFactory) {
        this.worldUtil = worldUtil;
        this.blockQueue = blockQueue;
        this.subscriberFactory = subscriberFactory;
    }

    public static BlockVector2 getRegion(Location location) {
        int x = location.getX() >> 9;
        int z = location.getZ() >> 9;
        return BlockVector2.at((int)x, (int)z);
    }

    public abstract int[] countEntities(Plot var1);

    public void deleteRegionFiles(String world, Collection<BlockVector2> chunks, Runnable whenDone) {
        TaskManager.runTaskAsync(() -> {
            for (BlockVector2 loc : chunks) {
                String directory = world + File.separator + "region" + File.separator + "r." + loc.getX() + "." + loc.getZ() + ".mca";
                File file = new File(PlotSquared.platform().worldContainer(), directory);
                LOGGER.info("- Deleting file: {} (max 1024 chunks)", (Object)file.getName());
                if (!file.exists()) continue;
                file.delete();
            }
            TaskManager.runTask(whenDone);
        });
    }

    public boolean setCuboids(@NonNull PlotArea area, @NonNull Set<CuboidRegion> regions, @NonNull Pattern blocks, int minY, int maxY, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        boolean enqueue = false;
        if (queue == null) {
            queue = area.getQueue();
            enqueue = true;
            if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                queue.addProgressSubscriber(this.subscriberFactory.createWithActor(actor));
            }
        }
        for (CuboidRegion region : regions) {
            Location pos1 = Location.at(area.getWorldName(), region.getMinimumPoint().getX(), minY, region.getMinimumPoint().getZ());
            Location pos2 = Location.at(area.getWorldName(), region.getMaximumPoint().getX(), maxY, region.getMaximumPoint().getZ());
            queue.setCuboid(pos1, pos2, blocks);
        }
        return !enqueue || queue.enqueue();
    }

    public boolean notifyClear(PlotManager manager) {
        return false;
    }

    public abstract boolean handleClear(@NonNull Plot var1, @Nullable Runnable var2, @NonNull PlotManager var3, @Nullable PlotPlayer<?> var4);

    public boolean copyRegion(@NonNull Location pos1, @NonNull Location pos2, @NonNull Location newPos, @Nullable PlotPlayer<?> actor, @NonNull Runnable whenDone) {
        int relX = newPos.getX() - pos1.getX();
        int relZ = newPos.getZ() - pos1.getZ();
        World oldWorld = this.worldUtil.getWeWorld(pos1.getWorldName());
        World newWorld = this.worldUtil.getWeWorld(newPos.getWorldName());
        QueueCoordinator copyFrom = this.blockQueue.getNewQueue(oldWorld);
        BasicQueueCoordinator copyTo = (BasicQueueCoordinator)this.blockQueue.getNewQueue(newWorld);
        this.setCopyFromToConsumer(pos1, pos2, relX, relZ, oldWorld, copyFrom, copyTo, false);
        copyFrom.setCompleteTask(copyTo::enqueue);
        if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            copyFrom.addProgressSubscriber(this.subscriberFactory.createFull(actor, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region_copy")));
        }
        copyFrom.addReadChunks(new CuboidRegion(BlockVector3.at((int)pos1.getX(), (int)0, (int)pos1.getZ()), BlockVector3.at((int)pos2.getX(), (int)0, (int)pos2.getZ())).getChunks());
        copyTo.setCompleteTask(whenDone);
        if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            copyTo.addProgressSubscriber(this.subscriberFactory.createFull(actor, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region_paste")));
        }
        return copyFrom.enqueue();
    }

    public abstract boolean regenerateRegion(Location var1, Location var2, boolean var3, Runnable var4);

    public abstract void clearAllEntities(Location var1, Location var2);

    public void swap(Location pos1, Location pos2, Location swapPos, @Nullable PlotPlayer<?> actor, Runnable whenDone) {
        int relX = swapPos.getX() - pos1.getX();
        int relZ = swapPos.getZ() - pos1.getZ();
        World world1 = this.worldUtil.getWeWorld(pos1.getWorldName());
        World world2 = this.worldUtil.getWeWorld(swapPos.getWorldName());
        QueueCoordinator fromQueue1 = this.blockQueue.getNewQueue(world1);
        QueueCoordinator fromQueue2 = this.blockQueue.getNewQueue(world2);
        fromQueue1.setUnloadAfter(false);
        fromQueue2.setUnloadAfter(false);
        fromQueue1.addReadChunks(new CuboidRegion(pos1.getBlockVector3(), pos2.getBlockVector3()).getChunks());
        fromQueue2.addReadChunks(new CuboidRegion(swapPos.getBlockVector3(), BlockVector3.at((int)(swapPos.getX() + pos2.getX() - pos1.getX()), (int)pos1.getY(), (int)(swapPos.getZ() + pos2.getZ() - pos1.getZ()))).getChunks());
        QueueCoordinator toQueue1 = this.blockQueue.getNewQueue(world1);
        QueueCoordinator toQueue2 = this.blockQueue.getNewQueue(world2);
        this.setCopyFromToConsumer(pos1, pos2, relX, relZ, world1, fromQueue1, toQueue2, true);
        this.setCopyFromToConsumer(pos1.add(relX, 0, relZ), pos2.add(relX, 0, relZ), -relX, -relZ, world1, fromQueue2, toQueue1, true);
        toQueue2.setCompleteTask(whenDone);
        if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            toQueue2.addProgressSubscriber(this.subscriberFactory.createFull(actor, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region2_paste")));
        }
        toQueue1.setCompleteTask(toQueue2::enqueue);
        if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            toQueue1.addProgressSubscriber(this.subscriberFactory.createFull(actor, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region1_paste")));
        }
        fromQueue2.setCompleteTask(toQueue1::enqueue);
        if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            fromQueue2.addProgressSubscriber(this.subscriberFactory.createFull(actor, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region2_copy")));
        }
        fromQueue1.setCompleteTask(fromQueue2::enqueue);
        if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            fromQueue1.addProgressSubscriber(this.subscriberFactory.createFull(actor, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region1_copy")));
        }
        fromQueue1.enqueue();
    }

    private void setCopyFromToConsumer(Location pos1, Location pos2, int relX, int relZ, World world1, QueueCoordinator fromQueue, QueueCoordinator toQueue, boolean removeEntities) {
        fromQueue.setChunkConsumer(chunk -> {
            int cx = chunk.getX();
            int cz = chunk.getZ();
            int cbx = cx << 4;
            int cbz = cz << 4;
            int bx = Math.max(pos1.getX(), cbx) & 0xF;
            int bz = Math.max(pos1.getZ(), cbz) & 0xF;
            int tx = Math.min(pos2.getX(), cbx + 15) & 0xF;
            int tz = Math.min(pos2.getZ(), cbz + 15) & 0xF;
            for (int y = world1.getMinY(); y <= world1.getMaxY(); ++y) {
                for (int x = bx; x <= tx; ++x) {
                    for (int z = bz; z <= tz; ++z) {
                        int rx = cbx + x;
                        int rz = cbz + z;
                        BlockVector3 loc = BlockVector3.at((int)rx, (int)y, (int)rz);
                        toQueue.setBlock(rx + relX, y, rz + relZ, world1.getFullBlock(loc));
                        toQueue.setBiome(rx + relX, y, rz + relZ, world1.getBiome(loc));
                    }
                }
            }
            CuboidRegion region = new CuboidRegion(BlockVector3.at((int)(cbx + bx), (int)world1.getMinY(), (int)(cbz + bz)), BlockVector3.at((int)(cbx + tx), (int)world1.getMaxY(), (int)(cbz + tz)));
            toQueue.addEntities(world1.getEntities((Region)region));
            if (removeEntities) {
                for (Entity entity : world1.getEntities((Region)region)) {
                    entity.remove();
                }
            }
        });
    }

    public void setBiome(CuboidRegion region, int extendBiome, BiomeType biome, PlotArea area, Runnable whenDone) {
        QueueCoordinator queue = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(area.getWorldName()));
        queue.addReadChunks(region.getChunks());
        BlockVector3 regionMin = region.getMinimumPoint();
        BlockVector3 regionMax = region.getMaximumPoint();
        queue.setChunkConsumer(chunkPos -> {
            BlockVector3 chunkMin = BlockVector3.at((int)Math.max(chunkPos.getX() << 4, regionMin.getBlockX()), (int)regionMin.getBlockY(), (int)Math.max(chunkPos.getZ() << 4, regionMin.getBlockZ()));
            BlockVector3 chunkMax = BlockVector3.at((int)Math.min((chunkPos.getX() << 4) + 15, regionMax.getBlockX()), (int)regionMax.getBlockY(), (int)Math.min((chunkPos.getZ() << 4) + 15, regionMax.getBlockZ()));
            CuboidRegion chunkRegion = new CuboidRegion(region.getWorld(), chunkMin, chunkMax);
            WorldUtil.setBiome(area.getWorldName(), chunkRegion, biome);
            this.worldUtil.refreshChunk(chunkPos.getBlockX(), chunkPos.getBlockZ(), area.getWorldName());
        });
        queue.setCompleteTask(whenDone);
        queue.enqueue();
    }
}

