/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.util.ComponentHelper;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@CommandDeclaration(command="cluster", aliases={"clusters"}, category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.NONE, permission="plots.cluster")
public class Cluster
extends SubCommand {
    private static final Component[] AVAILABLE_ARGS = (Component[])Stream.of("list", "create", "delete", "resize", "invite", "kick", "leave", "helpers", "tp", "sethome").map(s -> (TextComponent)Component.text((String)s).style(Style.style((TextColor)NamedTextColor.DARK_AQUA))).toArray(Component[]::new);
    private static final Component SEPARATOR = Component.text((String)", ").style(Style.style((TextColor)NamedTextColor.GRAY));

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        String sub;
        if (args.length == 0) {
            player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_available_args"), new TagResolver[]{TagResolver.resolver((String)"list", (Tag)Tag.inserting((Component)ComponentHelper.join((ComponentLike[])AVAILABLE_ARGS, SEPARATOR)))});
            return false;
        }
        switch (sub = args[0].toLowerCase()) {
            case "l": 
            case "list": {
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_LIST)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_LIST))});
                    return false;
                }
                if (args.length != 1) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster list")))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                Set<PlotCluster> clusters = area.getClusters();
                player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_heading"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)clusters.size())))});
                for (PlotCluster cluster : clusters) {
                    String name = "'" + cluster.getName() + "' : " + String.valueOf(cluster);
                    if (player.getUUID().equals(cluster.owner)) {
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_element_owner"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)name)))});
                        continue;
                    }
                    if (cluster.helpers.contains(player.getUUID())) {
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_element_helpers"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)name)))});
                        continue;
                    }
                    if (cluster.invited.contains(player.getUUID())) {
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_element_invited"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)name)))});
                        continue;
                    }
                    player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_element"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)cluster.toString())))});
                }
                return true;
            }
            case "c": 
            case "create": {
                PlotCluster cluster;
                PlotId pos2;
                PlotId pos1;
                int currentClusters;
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_CREATE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_CREATE))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                if (args.length != 4) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster create <name> <id-bot> <id-top>")))});
                    return false;
                }
                int n = currentClusters = Settings.Limit.GLOBAL ? player.getClusterCount() : player.getPlotCount(player.getLocation().getWorldName());
                if (currentClusters >= player.getAllowedPlots()) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_clusters"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)player.getAllowedPlots())))});
                }
                try {
                    pos1 = PlotId.fromString(args[2]);
                    pos2 = PlotId.fromString(args[3]);
                }
                catch (IllegalArgumentException ignored) {
                    player.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_plot_id"), new TagResolver[0]);
                    return false;
                }
                String name = args[1];
                if (area.getCluster(name) != null) {
                    player.sendMessage((Caption)TranslatableCaption.of("alias.alias_is_taken"), new TagResolver[]{TagResolver.resolver((String)"alias", (Tag)Tag.inserting((Component)Component.text((String)name)))});
                    return false;
                }
                if (pos2.getX() < pos1.getX() || pos2.getY() < pos1.getY()) {
                    PlotId tmp = PlotId.of(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()));
                    pos2 = PlotId.of(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()));
                    pos1 = tmp;
                }
                if ((cluster = area.getFirstIntersectingCluster(pos1, pos2)) != null) {
                    player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_intersection"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)cluster.getName())))});
                    return false;
                }
                if (!area.contains(pos1) || !area.contains(pos2)) {
                    player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_outside"), new TagResolver[]{TagResolver.resolver((String)"area", (Tag)Tag.inserting((Component)Component.text((String)area.toString())))});
                    return false;
                }
                Set<Plot> plots = area.getPlotSelectionOwned(pos1, pos2);
                if (!plots.isEmpty() && !player.hasPermission(Permission.PERMISSION_CLUSTER_CREATE_OTHER)) {
                    UUID uuid2 = player.getUUID();
                    for (Plot plot : plots) {
                        if (plot.isOwner(uuid2)) continue;
                        player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_CREATE_OTHER))});
                        return false;
                    }
                }
                cluster = new PlotCluster(area, pos1, pos2, player.getUUID());
                int current = Settings.Limit.GLOBAL ? player.getPlayerClusterCount() : player.getPlayerClusterCount(player.getLocation().getWorldName());
                int allowed = player.hasPermissionRange(Permission.PERMISSION_CLUSTER_SIZE, Settings.Limit.MAX_PLOTS);
                if (current + cluster.getArea() > allowed) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)(String.valueOf((Object)Permission.PERMISSION_CLUSTER_SIZE) + "." + (current + cluster.getArea())))))});
                    return false;
                }
                cluster.settings.setAlias(name);
                area.addCluster(cluster);
                DBFunc.createCluster(cluster);
                for (Plot plot : plots) {
                    if (!plot.hasOwner() || cluster.isAdded(plot.getOwner())) continue;
                    cluster.invited.add(plot.getOwner());
                    DBFunc.setInvited(cluster, plot.getOwner());
                }
                player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_created"), new TagResolver[]{TagResolver.resolver((String)"name", (Tag)Tag.inserting((Component)Component.text((String)name)))});
                return true;
            }
            case "disband": 
            case "del": 
            case "delete": {
                PlotCluster cluster;
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_DELETE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_DELETE))});
                    return false;
                }
                if (args.length != 1 && args.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster delete [name]")))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                if (args.length == 2) {
                    cluster = area.getCluster(args[1]);
                    if (cluster == null) {
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.invalid_cluster_name"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                        return false;
                    }
                } else {
                    cluster = area.getCluster(player.getLocation());
                    if (cluster == null) {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                        return false;
                    }
                }
                if (!cluster.owner.equals(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_CLUSTER_DELETE_OTHER)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_DELETE_OTHER))});
                    return false;
                }
                DBFunc.delete(cluster);
                player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_deleted"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)cluster.toString())))});
                return true;
            }
            case "res": 
            case "resize": {
                PlotArea area;
                PlotId pos2;
                PlotId pos1;
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_RESIZE))});
                    return false;
                }
                if (args.length != 3) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster resize [name]")))});
                    return false;
                }
                try {
                    pos1 = PlotId.fromString(args[2]);
                    pos2 = PlotId.fromString(args[3]);
                }
                catch (IllegalArgumentException ignored) {
                    player.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_plot_id"), new TagResolver[0]);
                    return false;
                }
                if (pos2.getX() < pos1.getX() || pos2.getY() < pos1.getY()) {
                    pos1 = PlotId.of(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()));
                    pos2 = PlotId.of(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()));
                }
                if ((area = player.getApplicablePlotArea()) == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                PlotCluster cluster = area.getCluster(player.getLocation());
                if (cluster == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                if (!cluster.hasHelperRights(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE_OTHER)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_RESIZE_OTHER))});
                    return false;
                }
                PlotCluster intersect = area.getFirstIntersectingCluster(pos1, pos2);
                if (intersect != null) {
                    player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_intersection"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)intersect.getName())))});
                    return false;
                }
                Set<Plot> existing = area.getPlotSelectionOwned(cluster.getP1(), cluster.getP2());
                Set<Plot> newPlots = area.getPlotSelectionOwned(pos1, pos2);
                HashSet<Plot> removed = new HashSet<Plot>(existing);
                removed.removeAll(newPlots);
                if (!removed.isEmpty() && !player.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE_SHRINK)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_RESIZE_SHRINK))});
                    return false;
                }
                newPlots.removeAll(existing);
                if (!newPlots.isEmpty() && !player.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE_EXPAND)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_RESIZE_EXPAND))});
                    return false;
                }
                int current = Settings.Limit.GLOBAL ? player.getPlayerClusterCount() : player.getPlayerClusterCount(player.getLocation().getWorldName());
                int n = player.hasPermissionRange(Permission.PERMISSION_CLUSTER, Settings.Limit.MAX_PLOTS);
                if ((current -= cluster.getArea() + (1 + pos2.getX() - pos1.getX()) * (1 + pos2.getY() - pos1.getY())) + cluster.getArea() > n) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)(String.valueOf((Object)Permission.PERMISSION_CLUSTER) + "." + (current + cluster.getArea())))))});
                    return false;
                }
                DBFunc.resizeCluster(cluster, pos1, pos2);
                player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_resized"), new TagResolver[0]);
                return true;
            }
            case "add": 
            case "inv": 
            case "invite": {
                PlotCluster cluster;
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_INVITE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_INVITE))});
                    return false;
                }
                if (args.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster invite <player>")))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if ((cluster = area.getCluster(player.getLocation())) == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                if (!cluster.hasHelperRights(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_CLUSTER_INVITE_OTHER)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_INVITE_OTHER))});
                    return false;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(args[1], (uuid, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else if (throwable != null) {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                    } else {
                        if (!cluster.isAdded((UUID)uuid)) {
                            cluster.invited.add((UUID)uuid);
                            DBFunc.setInvited(cluster, uuid);
                            PlotPlayer<?> otherPlayer = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)uuid);
                            if (otherPlayer != null) {
                                player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_invited"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)cluster.getName())))});
                            }
                        }
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_added_user"), new TagResolver[0]);
                    }
                });
                return true;
            }
            case "k": 
            case "remove": 
            case "kick": {
                PlotCluster cluster;
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_KICK)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_KICK))});
                    return false;
                }
                if (args.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster kick <player>")))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if ((cluster = area.getCluster(player.getLocation())) == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                if (!cluster.hasHelperRights(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_CLUSTER_KICK_OTHER)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_KICK_OTHER))});
                    return false;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(args[1], (uuid, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else if (throwable != null) {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                    } else if (uuid.equals(player.getUUID()) || uuid.equals(cluster.owner) || !cluster.isAdded((UUID)uuid)) {
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.cannot_kick_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)cluster.getName())))});
                    } else {
                        if (cluster.helpers.contains(uuid)) {
                            cluster.helpers.remove(uuid);
                            DBFunc.removeHelper(cluster, uuid);
                        }
                        cluster.invited.remove(uuid);
                        DBFunc.removeInvited(cluster, uuid);
                        PlotPlayer<?> player2 = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)uuid);
                        if (player2 != null) {
                            player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_removed"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)cluster.getName())))});
                        }
                        this.removePlayerPlots(cluster, (UUID)uuid, player2.getLocation().getWorldName());
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_kicked_user"), new TagResolver[0]);
                    }
                });
                return true;
            }
            case "quit": 
            case "leave": {
                UUID uuid3;
                PlotCluster cluster;
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_LEAVE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_LEAVE))});
                    return false;
                }
                if (args.length != 1 && args.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster leave [name]")))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if (args.length == 2) {
                    cluster = area.getCluster(args[1]);
                    if (cluster == null) {
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.invalid_cluster_name"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                        return false;
                    }
                } else {
                    cluster = area.getCluster(player.getLocation());
                    if (cluster == null) {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                        return false;
                    }
                }
                if (!cluster.isAdded(uuid3 = player.getUUID())) {
                    player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_not_added"), new TagResolver[0]);
                    return false;
                }
                if (uuid3.equals(cluster.owner)) {
                    player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_cannot_leave"), new TagResolver[0]);
                    return false;
                }
                if (cluster.helpers.contains(uuid3)) {
                    cluster.helpers.remove(uuid3);
                    DBFunc.removeHelper(cluster, uuid3);
                }
                cluster.invited.remove(uuid3);
                DBFunc.removeInvited(cluster, uuid3);
                player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_removed"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)cluster.getName())))});
                this.removePlayerPlots(cluster, uuid3, player.getLocation().getWorldName());
                return true;
            }
            case "members": {
                PlotCluster cluster;
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_HELPERS)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)Permission.PERMISSION_CLUSTER_HELPERS.toString())))});
                    return false;
                }
                if (args.length != 3) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster members <add | remove> <player>")))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if ((cluster = area.getCluster(player.getLocation())) == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(args[2], (uuid, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else if (throwable != null) {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[2])))});
                    } else if (args[1].equalsIgnoreCase("add")) {
                        cluster.helpers.add((UUID)uuid);
                        DBFunc.setHelper(cluster, uuid);
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_added_helper"), new TagResolver[0]);
                    } else if (args[1].equalsIgnoreCase("remove")) {
                        cluster.helpers.remove(uuid);
                        DBFunc.removeHelper(cluster, uuid);
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_removed_helper"), new TagResolver[0]);
                    } else {
                        player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster members <add | remove> <player>")))});
                    }
                });
                return true;
            }
            case "spawn": 
            case "home": 
            case "tp": {
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_TP)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_TP))});
                    return false;
                }
                if (args.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster tp <name>")))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                PlotCluster cluster = area.getCluster(args[1]);
                if (cluster == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("cluster.invalid_cluster_name"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                    return false;
                }
                UUID uuid4 = player.getUUID();
                if (!cluster.isAdded(uuid4) && !player.hasPermission(Permission.PERMISSION_CLUSTER_TP_OTHER)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_TP_OTHER))});
                    return false;
                }
                cluster.getHome(home -> player.teleport((Location)home, TeleportCause.COMMAND_CLUSTER_TELEPORT));
                player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_teleporting"), new TagResolver[0]);
                return true;
            }
            case "i": 
            case "info": 
            case "show": 
            case "information": {
                PlotCluster cluster;
                PlotArea area;
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_INFO)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_TP))});
                    return false;
                }
                if (args.length != 1 && args.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster info [name]")))});
                }
                if ((area = player.getApplicablePlotArea()) == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                if (args.length == 2) {
                    cluster = area.getCluster(args[1]);
                    if (cluster == null) {
                        player.sendMessage((Caption)TranslatableCaption.of("cluster.invalid_cluster_name"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                        return false;
                    }
                } else {
                    cluster = area.getCluster(player.getLocation());
                    if (cluster == null) {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                        return false;
                    }
                }
                String id = cluster.toString();
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(cluster.owner, (username, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else {
                        String owner = Objects.requireNonNullElse(username, "unknown");
                        String name = cluster.getName();
                        String size = cluster.getP2().getX() - cluster.getP1().getX() + 1 + "x" + (cluster.getP2().getY() - cluster.getP1().getY() + 1);
                        String rights = "" + cluster.isAdded(player.getUUID());
                        TranslatableCaption message = TranslatableCaption.of("cluster.cluster_info");
                        TagResolver resolver = TagResolver.builder().tag("id", Tag.inserting((Component)Component.text((String)id))).tag("owner", Tag.inserting((Component)Component.text((String)owner))).tag("name", Tag.inserting((Component)Component.text((String)name))).tag("size", Tag.inserting((Component)Component.text((String)size))).tag("rights", Tag.inserting((Component)Component.text((String)rights))).build();
                        player.sendMessage((Caption)message, resolver);
                    }
                });
                return true;
            }
            case "sh": 
            case "setspawn": 
            case "sethome": {
                PlotCluster cluster;
                if (!player.hasPermission(Permission.PERMISSION_CLUSTER_SETHOME)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_SETHOME))});
                    return false;
                }
                if (args.length != 1 && args.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot cluster sethome")))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if ((cluster = area.getCluster(player.getLocation())) == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                if (!cluster.hasHelperRights(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_CLUSTER_SETHOME_OTHER)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_CLUSTER_SETHOME_OTHER))});
                    return false;
                }
                Location base = cluster.getClusterBottom();
                Location relative = player.getLocation().subtract(base.getX(), 0, base.getZ());
                BlockLoc blockloc = new BlockLoc(relative.getX(), relative.getY(), relative.getZ());
                cluster.settings.setPosition(blockloc);
                DBFunc.setPosition(cluster, relative.getX() + "," + relative.getY() + "," + relative.getZ());
                player.sendMessage((Caption)TranslatableCaption.of("position.position_set"), new TagResolver[0]);
                return true;
            }
        }
        player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_available_args"), new TagResolver[]{TagResolver.resolver((String)"list", (Tag)Tag.inserting((Component)ComponentHelper.join((ComponentLike[])AVAILABLE_ARGS, SEPARATOR)))});
        return false;
    }

    private void removePlayerPlots(PlotCluster cluster, UUID uuid, String world) {
        block0: for (Plot plot : PlotQuery.newQuery().inWorld(world).ownedBy(uuid)) {
            PlotCluster current = plot.getCluster();
            if (current == null || !current.equals(cluster)) continue;
            if (plot.getOwners().size() == 1) {
                plot.unclaim();
                continue;
            }
            for (UUID newOwner : plot.getOwners()) {
                if (newOwner.equals(uuid)) continue;
                plot.setOwner(newOwner);
                continue block0;
            }
        }
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_LIST)) {
                completions.add("list");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_CREATE)) {
                completions.add("create");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_DELETE)) {
                completions.add("delete");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE)) {
                completions.add("resize");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_INVITE)) {
                completions.add("invite");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_KICK)) {
                completions.add("kick");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_KICK)) {
                completions.add("leave");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_HELPERS)) {
                completions.add("members");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_INFO)) {
                completions.add("info");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_TP)) {
                completions.add("tp");
            }
            if (player.hasPermission(Permission.PERMISSION_CLUSTER_SETHOME)) {
                completions.add("sethome");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (player.hasPermission(Permission.PERMISSION_CLUSTER) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

