/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import cloud.commandframework.services.ServicePipeline;
import cloud.commandframework.services.types.Service;
import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlayerAutoPlotEvent;
import com.plotsquared.core.events.PlotAutoMergeEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.services.plots.AutoQuery;
import com.plotsquared.core.services.plots.AutoService;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.task.AutoClaimFinishTask;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import io.leangen.geantyref.TypeToken;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@CommandDeclaration(command="auto", permission="plots.auto", category=CommandCategory.CLAIMING, requiredType=RequiredType.NONE, aliases={"a"}, usage="/plot auto [length, width]")
public class Auto
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;
    private final ServicePipeline servicePipeline;

    @Inject
    public Auto(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler, @NonNull ServicePipeline servicePipeline) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
        this.servicePipeline = servicePipeline;
        this.servicePipeline.registerServiceType(TypeToken.get(AutoService.class), (Service)new AutoService.DefaultAutoService());
        AutoService.MultiPlotService multiPlotService = new AutoService.MultiPlotService();
        this.servicePipeline.registerServiceImplementation(AutoService.class, (Service)multiPlotService, Collections.singletonList(multiPlotService));
        AutoService.SinglePlotService singlePlotService = new AutoService.SinglePlotService();
        this.servicePipeline.registerServiceImplementation(AutoService.class, (Service)singlePlotService, Collections.singletonList(singlePlotService));
    }

    public static boolean checkAllowedPlots(PlotPlayer<?> player, PlotArea plotarea, @Nullable Integer allowedPlots, int sizeX, int sizeZ) {
        block15: {
            if (allowedPlots == null) {
                allowedPlots = player.getAllowedPlots();
            }
            int currentPlots = Settings.Limit.GLOBAL ? player.getPlotCount() : player.getPlotCount(plotarea.getWorldName());
            int diff = allowedPlots - currentPlots;
            if (diff - sizeX * sizeZ < 0) {
                try (MetaDataAccess<Integer> metaDataAccess = player.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_GRANTED_PLOTS);){
                    if (metaDataAccess.isPresent()) {
                        int left;
                        int grantedPlots = metaDataAccess.get().orElse(0);
                        if (diff < 0 && grantedPlots < sizeX * sizeZ) {
                            player.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)(diff + grantedPlots))))});
                            boolean bl = false;
                            return bl;
                        }
                        if (diff >= 0 && grantedPlots + diff < sizeX * sizeZ) {
                            player.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)(diff + grantedPlots))))});
                            boolean bl = false;
                            return bl;
                        }
                        int n = left = grantedPlots + diff < 0 ? 0 : diff - sizeX * sizeZ;
                        if (left == 0) {
                            metaDataAccess.remove();
                        } else {
                            metaDataAccess.set(left);
                        }
                        player.sendMessage((Caption)TranslatableCaption.of("economy.removed_granted_plot"), TagResolver.builder().tag("used_grants", Tag.inserting((Component)Component.text((int)(grantedPlots - left)))).tag("remaining_grants", Tag.inserting((Component)Component.text((int)left))).build());
                        break block15;
                    }
                    player.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)player.getAllowedPlots())))});
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    private void claimSingle(final @NonNull PlotPlayer<?> player, final @NonNull Plot plot, final @NonNull PlotArea plotArea, final @Nullable String schematic) {
        try (MetaDataAccess<Boolean> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_AUTO);){
            metaDataAccess.set(true);
        }
        plot.setOwnerAbs(player.getUUID());
        RunnableVal<Plot> runnableVal = new RunnableVal<Plot>(){
            {
                this.value = plot;
            }

            @Override
            public void run(Plot plot2) {
                try {
                    TaskManager.getPlatformImplementation().sync(new AutoClaimFinishTask(player, plot2, plotArea, schematic, PlotSquared.get().getEventDispatcher()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        DBFunc.createPlotSafe(plot, runnableVal, () -> this.claimSingle(player, plot, plotArea, schematic));
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        PlayerAutoPlotEvent event;
        PlotArea plotarea = player.getApplicablePlotArea();
        if (plotarea == null) {
            PermissionHandler permissionHandler = PlotSquared.platform().permissionHandler();
            if (permissionHandler.hasCapability(PermissionHandler.PermissionHandlerCapability.PER_WORLD_PERMISSIONS)) {
                for (PlotArea area : this.plotAreaManager.getAllPlotAreas()) {
                    if (!player.hasPermission(area.getWorldName(), "plots.auto")) continue;
                    if (plotarea != null) {
                        plotarea = null;
                        break;
                    }
                    plotarea = area;
                }
            }
            if (this.plotAreaManager.getAllPlotAreas().length == 1) {
                plotarea = this.plotAreaManager.getAllPlotAreas()[0];
            }
            if (plotarea == null) {
                player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                return false;
            }
        }
        int sizeX = 1;
        int sizeZ = 1;
        String schematic = null;
        boolean mega = false;
        if (args.length > 0) {
            try {
                String[] split = args[0].split("[,;]");
                if (split.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)this.getUsage())))});
                    return true;
                }
                sizeX = Integer.parseInt(split[0]);
                sizeZ = Integer.parseInt(split[1]);
                if (sizeX < 1 || sizeZ < 1) {
                    player.sendMessage((Caption)TranslatableCaption.of("error.plot_size_negative"), new TagResolver[0]);
                    return true;
                }
                if (args.length > 1) {
                    schematic = args[1];
                }
                mega = true;
            }
            catch (NumberFormatException ignored) {
                sizeX = 1;
                sizeZ = 1;
                schematic = args[0];
            }
        }
        if ((event = this.eventDispatcher.callAuto(player, plotarea, schematic, sizeX, sizeZ)).getEventResult() == Result.DENY) {
            player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Auto claim")))});
            return true;
        }
        boolean force = event.getEventResult() == Result.FORCE;
        sizeX = event.getSizeX();
        sizeZ = event.getSizeZ();
        schematic = event.getSchematic();
        if (!force && mega && !player.hasPermission(Permission.PERMISSION_AUTO_MEGA)) {
            player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_AUTO_MEGA))});
            return false;
        }
        if (!force && sizeX * sizeZ > Settings.Claim.MAX_AUTO_AREA) {
            player.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots_num"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)Settings.Claim.MAX_AUTO_AREA)))});
            return false;
        }
        int allowed_plots = player.getAllowedPlots();
        try (MetaDataAccess<Boolean> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_AUTO);){
            if (!(force || !metaDataAccess.get().orElse(false).booleanValue() && Auto.checkAllowedPlots(player, plotarea, allowed_plots, sizeX, sizeZ))) {
                boolean bl = false;
                return bl;
            }
        }
        if (schematic != null && !schematic.isEmpty()) {
            if (!plotarea.hasSchematic(schematic)) {
                player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid_named"), TagResolver.builder().tag("schemname", Tag.inserting((Component)Component.text((String)schematic))).tag("reason", Tag.inserting((Component)Component.text((String)"non-existent"))).build());
                return true;
            }
            if (!(force || player.hasPermission(Permission.PERMISSION_CLAIM_SCHEMATIC.format(schematic)) || player.hasPermission("plots.admin.command.schematic"))) {
                player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.claim.%s0")))});
                return true;
            }
        }
        if (this.econHandler != null && plotarea.useEconomy() && !player.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON)) {
            PlotExpression costExp = plotarea.getPrices().get("claim");
            PlotExpression mergeCostExp = plotarea.getPrices().get("merge");
            int size = sizeX * sizeZ;
            double mergeCost = size <= 1 || mergeCostExp == null ? 0.0 : mergeCostExp.evaluate(size);
            double cost = costExp.evaluate(Settings.Limit.GLOBAL ? (double)player.getPlotCount() : (double)player.getPlotCount(plotarea.getWorldName()));
            if ((cost = (double)size * cost + mergeCost) > 0.0) {
                if (!this.econHandler.isSupported()) {
                    player.sendMessage((Caption)TranslatableCaption.of("economy.vault_or_consumer_null"), new TagResolver[0]);
                    return false;
                }
                if (!force && this.econHandler.getMoney(player) < cost) {
                    player.sendMessage((Caption)TranslatableCaption.of("economy.cannot_afford_plot"), TagResolver.builder().tag("money", Tag.inserting((Component)Component.text((String)this.econHandler.format(cost)))).tag("balance", Tag.inserting((Component)Component.text((String)this.econHandler.format(this.econHandler.getMoney(player))))).build());
                    return false;
                }
                this.econHandler.withdrawMoney(player, cost);
                player.sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), new TagResolver[]{TagResolver.resolver((String)"money", (Tag)Tag.inserting((Component)Component.text((String)this.econHandler.format(cost))))});
            }
        }
        List<Plot> plots = (List<Plot>)this.servicePipeline.pump((Object)new AutoQuery(player, null, sizeX, sizeZ, plotarea)).through(AutoService.class).getResult();
        if ((plots = this.eventDispatcher.callAutoPlotsChosen(player, plots).getPlots()).isEmpty()) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.no_free_plots"), new TagResolver[0]);
            return false;
        }
        if (plots.size() != 1) {
            Iterator<Plot> plotIterator = plots.iterator();
            while (plotIterator.hasNext()) {
                Plot plot = plotIterator.next();
                if (!plot.canClaim(player)) continue;
                plot.claim(player, !plotIterator.hasNext(), null, true, true);
                this.eventDispatcher.callPostAuto(player, plot);
            }
            PlotAutoMergeEvent mergeEvent = this.eventDispatcher.callAutoMerge(plots.get(0), plots.stream().map(Plot::getId).collect(Collectors.toList()));
            if (!force && mergeEvent.getEventResult() == Result.DENY) {
                player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Auto merge")))});
                return false;
            }
            return plotarea.mergePlots(mergeEvent.getPlots(), true);
        }
        this.claimSingle(player, plots.get(0), plotarea, schematic);
        return true;
    }
}

