/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.types.NumberFlag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class IntegerFlag<F extends NumberFlag<Integer, F>>
extends NumberFlag<Integer, F> {
    protected IntegerFlag(int value, int minimum, int maximum, @NonNull Caption flagDescription) {
        super(value, minimum, maximum, TranslatableCaption.of("flags.flag_category_integers"), flagDescription);
    }

    protected IntegerFlag(@NonNull Caption flagDescription) {
        this(0, Integer.MIN_VALUE, Integer.MAX_VALUE, flagDescription);
    }

    @Override
    public F merge(@NonNull Integer newValue) {
        return (F)((NumberFlag)this.flagOf((Integer)this.getValue() + newValue));
    }

    @Override
    public String toString() {
        return ((Integer)this.getValue()).toString();
    }

    @Override
    public String getExample() {
        return "10";
    }

    @Override
    protected @NonNull Integer parseNumber(String input) throws FlagParseException {
        try {
            return Integer.parseInt(input);
        }
        catch (Throwable throwable) {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_integer"), new TagResolver[0]);
        }
    }
}

