/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.collection.QuadMap;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.GridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public abstract class PlotArea
implements ComponentLike {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotArea.class.getSimpleName()));
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private static final DecimalFormat FLAG_DECIMAL_FORMAT = new DecimalFormat("0");
    protected final ConcurrentHashMap<PlotId, Plot> plots = new ConcurrentHashMap();
    private final @NonNull String worldName;
    private final String id;
    private final @NonNull PlotManager plotManager;
    private final int worldHash;
    private final PlotId min;
    private final PlotId max;
    private final @NonNull IndependentPlotGenerator generator;
    private final FlagContainer flagContainer = new FlagContainer(GlobalFlagContainer.getInstance());
    private final FlagContainer roadFlagContainer = new FlagContainer(GlobalFlagContainer.getInstance());
    private final YamlConfiguration worldConfiguration;
    private final GlobalBlockQueue globalBlockQueue;
    private boolean roadFlags = false;
    private boolean autoMerge = false;
    private boolean allowSigns = true;
    private boolean miscSpawnUnowned = false;
    private boolean mobSpawning = false;
    private boolean mobSpawnerSpawning = false;
    private BiomeType plotBiome = BiomeTypes.FOREST;
    private boolean plotChat = true;
    private boolean forcingPlotChat = false;
    private boolean schematicClaimSpecify = false;
    private boolean schematicOnClaim = false;
    private String schematicFile = "null";
    private boolean spawnEggs = false;
    private boolean spawnCustom = true;
    private boolean spawnBreeding = false;
    private PlotAreaType type = PlotAreaType.NORMAL;
    private PlotAreaTerrainType terrain = PlotAreaTerrainType.NONE;
    private boolean homeAllowNonmember = false;
    private BlockLoc nonmemberHome;
    private BlockLoc defaultHome;
    private int maxBuildHeight = PlotSquared.platform().versionMaxHeight() + 1;
    private int minBuildHeight = PlotSquared.platform().versionMinHeight() + 1;
    private int maxGenHeight = PlotSquared.platform().versionMaxHeight();
    private int minGenHeight = PlotSquared.platform().versionMinHeight();
    private GameMode gameMode = GameModes.CREATIVE;
    private Map<String, PlotExpression> prices = new HashMap<String, PlotExpression>();
    private List<String> schematics = new ArrayList<String>();
    private boolean worldBorder = false;
    private int borderSize = 1;
    private boolean useEconomy = false;
    private int hash;
    private CuboidRegion region;
    private ConcurrentHashMap<String, Object> meta;
    private QuadMap<PlotCluster> clusters;
    private String signMaterial = "OAK_WALL_SIGN";
    private String legacySignMaterial = "WALL_SIGN";

    public PlotArea(@NonNull String worldName, @Nullable String id, @NonNull IndependentPlotGenerator generator, @Nullable PlotId min, @Nullable PlotId max, @WorldConfig @Nullable YamlConfiguration worldConfiguration, @NonNull GlobalBlockQueue blockQueue) {
        this.worldName = worldName;
        this.id = id;
        this.plotManager = this.createManager();
        this.generator = generator;
        this.globalBlockQueue = blockQueue;
        if (min == null || max == null) {
            if (min != max) {
                throw new IllegalArgumentException("None of the ids can be null for this constructor");
            }
            this.min = null;
            this.max = null;
        } else {
            this.min = min;
            this.max = max;
        }
        this.worldHash = worldName.hashCode();
        this.worldConfiguration = worldConfiguration;
    }

    private static void parseFlags(FlagContainer flagContainer, List<String> flagStrings) {
        for (String key : flagStrings) {
            String[] split = key.contains(";") ? key.split(";") : key.split(":");
            PlotFlag<?, ?> flagInstance = GlobalFlagContainer.getInstance().getFlagFromString(split[0]);
            if (flagInstance != null) {
                try {
                    flagContainer.addFlag(flagInstance.parse(split[1]));
                }
                catch (FlagParseException e) {
                    LOGGER.warn("Failed to parse default flag with key '{}' and value '{}'. Reason: {}. This flag will not be added as a default flag.", (Object)e.getFlag().getName(), (Object)e.getValue(), (Object)e.getErrorMessage());
                    e.printStackTrace();
                }
                continue;
            }
            flagContainer.addUnknownFlag(split[0], split[1]);
        }
    }

    protected abstract @NonNull PlotManager createManager();

    public QueueCoordinator getQueue() {
        return this.globalBlockQueue.getNewQueue(PlotSquared.platform().worldUtil().getWeWorld(this.worldName));
    }

    public CuboidRegion getRegion() {
        this.region = this.getRegionAbs();
        if (this.region == null) {
            return new CuboidRegion(BlockVector3.at((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE), BlockVector3.at((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        }
        return this.region;
    }

    private CuboidRegion getRegionAbs() {
        if (this.region == null && this.min != null) {
            Location bot = this.getPlotManager().getPlotBottomLocAbs(this.min);
            Location top = this.getPlotManager().getPlotTopLocAbs(this.max);
            BlockVector3 pos1 = bot.getBlockVector3().subtract(BlockVector3.ONE);
            BlockVector3 pos2 = top.getBlockVector3().add(BlockVector3.ONE);
            this.region = new CuboidRegion(pos1, pos2);
        }
        return this.region;
    }

    public @NonNull PlotId getMin() {
        return this.min == null ? PlotId.of(Integer.MIN_VALUE, Integer.MIN_VALUE) : this.min;
    }

    public @NonNull PlotId getMax() {
        return this.max == null ? PlotId.of(Integer.MAX_VALUE, Integer.MAX_VALUE) : this.max;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlotArea plotarea = (PlotArea)obj;
        return this.getWorldHash() == plotarea.getWorldHash() && this.getWorldName().equals(plotarea.getWorldName()) && StringMan.isEqual(this.getId(), plotarea.getId());
    }

    public Set<PlotCluster> getClusters() {
        return this.clusters == null ? new HashSet() : this.clusters.getAll();
    }

    public boolean isCompatible(@NonNull PlotArea plotArea) {
        ConfigurationSection section = this.worldConfiguration.getConfigurationSection("worlds");
        for (ConfigurationNode setting : plotArea.getSettingNodes()) {
            Object constant = section.get(plotArea.worldName + "." + setting.getConstant());
            if (constant != null && constant.equals(section.get(this.worldName + "." + setting.getConstant()))) continue;
            return false;
        }
        return true;
    }

    public void loadDefaultConfiguration(ConfigurationSection config) {
        if (!(this.min == null && this.max == null || this instanceof GridPlotWorld)) {
            throw new IllegalArgumentException("Must extend GridPlotWorld to provide");
        }
        if (config.contains("generator.terrain")) {
            this.terrain = ConfigurationUtil.getTerrain(config);
            this.type = ConfigurationUtil.getType(config);
        }
        this.mobSpawning = config.getBoolean("natural_mob_spawning");
        this.miscSpawnUnowned = config.getBoolean("misc_spawn_unowned");
        this.mobSpawnerSpawning = config.getBoolean("mob_spawner_spawning");
        this.autoMerge = config.getBoolean("plot.auto_merge");
        this.allowSigns = config.getBoolean("plot.create_signs");
        if (PlotSquared.platform().serverVersion()[1] == 13) {
            this.legacySignMaterial = config.getString("plot.legacy_sign_material");
        } else {
            this.signMaterial = config.getString("plot.sign_material");
        }
        Object biomeString = config.getString("plot.biome");
        if (!((String)biomeString).startsWith("minecraft:")) {
            biomeString = "minecraft:" + (String)biomeString;
            config.set("plot.biome", ((String)biomeString).toLowerCase());
        }
        this.plotBiome = ConfigurationUtil.BIOME.parseString(((String)biomeString).toLowerCase());
        this.schematicOnClaim = config.getBoolean("schematic.on_claim");
        this.schematicFile = config.getString("schematic.file");
        this.schematicClaimSpecify = config.getBoolean("schematic.specify_on_claim");
        this.schematics = new ArrayList<String>(config.getStringList("schematic.schematics"));
        this.schematics.replaceAll(String::toLowerCase);
        this.useEconomy = config.getBoolean("economy.use");
        ConfigurationSection priceSection = config.getConfigurationSection("economy.prices");
        if (this.useEconomy) {
            this.prices = new HashMap<String, PlotExpression>();
            for (String key : priceSection.getKeys(false)) {
                String raw = priceSection.getString(key);
                if (raw.contains("{arg}")) {
                    raw = raw.replace("{arg}", "plots");
                    priceSection.set(key, raw);
                }
                this.prices.put(key, PlotExpression.compile(raw, "plots"));
            }
        }
        this.plotChat = config.getBoolean("chat.enabled");
        this.forcingPlotChat = config.getBoolean("chat.forced");
        this.worldBorder = config.getBoolean("world.border");
        this.borderSize = config.getInt("world.border_size");
        this.maxBuildHeight = config.getInt("world.max_height");
        this.minBuildHeight = config.getInt("world.min_height");
        this.minGenHeight = config.getInt("world.min_gen_height");
        this.maxGenHeight = config.getInt("world.max_gen_height");
        switch (config.getString("world.gamemode").toLowerCase()) {
            case "creative": 
            case "c": 
            case "1": {
                this.gameMode = GameModes.CREATIVE;
                break;
            }
            case "adventure": 
            case "a": 
            case "2": {
                this.gameMode = GameModes.ADVENTURE;
                break;
            }
            case "spectator": 
            case "3": {
                this.gameMode = GameModes.SPECTATOR;
                break;
            }
            default: {
                this.gameMode = GameModes.SURVIVAL;
            }
        }
        String homeNonMembers = config.getString("home.nonmembers");
        String homeDefault = config.getString("home.default");
        this.defaultHome = BlockLoc.fromString(homeDefault);
        this.homeAllowNonmember = homeNonMembers.equalsIgnoreCase(homeDefault);
        this.nonmemberHome = this.homeAllowNonmember ? this.defaultHome : BlockLoc.fromString(homeNonMembers);
        if ("side".equalsIgnoreCase(homeDefault)) {
            this.defaultHome = null;
        } else if (StringMan.isEqualIgnoreCaseToAny(homeDefault, "center", "middle", "centre")) {
            this.defaultHome = new BlockLoc(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        } else {
            try {
                this.defaultHome = BlockLoc.fromString(homeDefault);
            }
            catch (NumberFormatException ignored) {
                this.defaultHome = null;
            }
        }
        this.spawnEggs = config.getBoolean("event.spawn.egg");
        this.spawnCustom = config.getBoolean("event.spawn.custom");
        this.spawnBreeding = config.getBoolean("event.spawn.breeding");
        if (PlotSquared.get().isWeInitialised()) {
            this.loadFlags(config);
        } else {
            ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("flags.delaying_loading_area_flags"), new TagResolver[]{TagResolver.resolver((String)"area", (Tag)Tag.inserting((Component)Component.text((String)(this.id == null ? this.worldName : this.id))))});
            TaskManager.runTaskLater(() -> this.loadFlags(config), TaskTime.ticks(1L));
        }
        this.loadConfiguration(config);
    }

    private void loadFlags(ConfigurationSection config) {
        ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("flags.loading_area_flags"), new TagResolver[]{TagResolver.resolver((String)"area", (Tag)Tag.inserting((Component)Component.text((String)(this.id == null ? this.worldName : this.id))))});
        List<String> flags = config.getStringList("flags.default");
        if (flags.isEmpty() && (flags = config.getStringList("flags")).isEmpty()) {
            flags = new ArrayList<String>();
            ConfigurationSection section = config.getConfigurationSection("flags");
            Set<String> keys = section.getKeys(false);
            for (String key : keys) {
                if ("default".equals(key)) continue;
                flags.add(key + ";" + section.get(key));
            }
        }
        PlotArea.parseFlags(this.getFlagContainer(), flags);
        ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("flags.area_flags"), new TagResolver[]{TagResolver.resolver((String)"flags", (Tag)Tag.inserting((Component)Component.text((String)flags.toString())))});
        List<String> roadflags = config.getStringList("road.flags");
        if (roadflags.isEmpty()) {
            roadflags = new ArrayList<String>();
            ConfigurationSection section = config.getConfigurationSection("road.flags");
            Set<String> keys = section.getKeys(false);
            for (String key : keys) {
                if ("default".equals(key)) continue;
                roadflags.add(key + ";" + section.get(key));
            }
        }
        this.roadFlags = !roadflags.isEmpty();
        PlotArea.parseFlags(this.getRoadFlagContainer(), roadflags);
        ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("flags.road_flags"), new TagResolver[]{TagResolver.resolver((String)"flags", (Tag)Tag.inserting((Component)Component.text((String)roadflags.toString())))});
    }

    public abstract void loadConfiguration(ConfigurationSection var1);

    public void saveConfiguration(ConfigurationSection config) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("natural_mob_spawning", this.isMobSpawning());
        options.put("misc_spawn_unowned", this.isMiscSpawnUnowned());
        options.put("mob_spawner_spawning", this.isMobSpawnerSpawning());
        options.put("plot.auto_merge", this.isAutoMerge());
        options.put("plot.create_signs", this.allowSigns());
        if (PlotSquared.platform().serverVersion()[1] == 13) {
            options.put("plot.legacy_sign_material", this.legacySignMaterial);
        } else {
            options.put("plot.sign_material", this.signMaterial());
        }
        options.put("plot.biome", "minecraft:forest");
        options.put("schematic.on_claim", this.isSchematicOnClaim());
        options.put("schematic.file", this.getSchematicFile());
        options.put("schematic.specify_on_claim", this.isSchematicClaimSpecify());
        options.put("schematic.schematics", this.getSchematics());
        options.put("economy.use", this.useEconomy());
        options.put("economy.prices.claim", 100);
        options.put("economy.prices.merge", 100);
        options.put("economy.prices.sell", 100);
        options.put("chat.enabled", this.isPlotChat());
        options.put("chat.forced", this.isForcingPlotChat());
        options.put("flags.default", null);
        options.put("event.spawn.egg", this.isSpawnEggs());
        options.put("event.spawn.custom", this.isSpawnCustom());
        options.put("event.spawn.breeding", this.isSpawnBreeding());
        options.put("world.border", this.hasWorldBorder());
        options.put("world.border_size", this.getBorderSize());
        options.put("home.default", "side");
        String position = config.getString("home.nonmembers", config.getBoolean("home.allow-nonmembers", false) ? config.getString("home.default", "side") : "side");
        options.put("home.nonmembers", position);
        options.put("world.max_height", this.getMaxBuildHeight());
        options.put("world.min_height", this.getMinBuildHeight());
        options.put("world.min_gen_height", this.getMinGenHeight());
        options.put("world.max_gen_height", this.getMaxGenHeight());
        options.put("world.gamemode", this.getGameMode().getName().toLowerCase());
        options.put("road.flags.default", null);
        if (this.getType() != PlotAreaType.NORMAL) {
            options.put("generator.terrain", (Object)this.getTerrain());
            options.put("generator.type", this.getType().toString());
        }
        ConfigurationNode[] settings = this.getSettingNodes();
        for (ConfigurationNode setting : settings) {
            options.put(setting.getConstant(), setting.getValue());
        }
        for (Map.Entry entry : options.entrySet()) {
            if (config.contains((String)entry.getKey())) continue;
            config.set((String)entry.getKey(), entry.getValue());
        }
        if (!config.contains("flags")) {
            config.set("flags.use", "63,64,68,69,71,77,96,143,167,193,194,195,196,197,77,143,69,70,72,147,148,107,183,184,185,186,187,132");
        }
        if (!config.contains("road.flags")) {
            config.set("road.flags.liquid-flow", false);
        }
    }

    public @NonNull String toString() {
        if (this.getId() == null) {
            return this.getWorldName();
        }
        return this.getWorldName() + ";" + this.getId();
    }

    @NotNull
    public Component asComponent() {
        return Component.text((String)this.toString());
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.toString().hashCode();
        return this.hash;
    }

    public abstract ConfigurationNode[] getSettingNodes();

    public @Nullable Plot getPlotAbs(@NonNull Location location) {
        PlotId pid = this.getPlotManager().getPlotId(location.getX(), location.getY(), location.getZ());
        if (pid == null) {
            return null;
        }
        return this.getPlotAbs(pid);
    }

    public @Nullable Plot getPlot(@NonNull Location location) {
        PlotId pid = this.getPlotManager().getPlotId(location.getX(), location.getY(), location.getZ());
        if (pid == null) {
            return null;
        }
        return this.getPlot(pid);
    }

    public @Nullable Plot getOwnedPlot(@NonNull Location location) {
        PlotId pid = this.getPlotManager().getPlotId(location.getX(), location.getY(), location.getZ());
        if (pid == null) {
            return null;
        }
        Plot plot = this.plots.get(pid);
        return plot == null ? null : plot.getBasePlot(false);
    }

    public @Nullable Plot getOwnedPlotAbs(@NonNull Location location) {
        PlotId pid = this.getPlotManager().getPlotId(location.getX(), location.getY(), location.getZ());
        if (pid == null) {
            return null;
        }
        return this.plots.get(pid);
    }

    public @Nullable Plot getOwnedPlotAbs(@NonNull PlotId id) {
        return this.plots.get(id);
    }

    public @Nullable Plot getOwnedPlot(@NonNull PlotId id) {
        Plot plot = this.plots.get(id);
        return plot == null ? null : plot.getBasePlot(false);
    }

    public boolean contains(int x, int z) {
        return this.getType() != PlotAreaType.PARTIAL || RegionUtil.contains(this.getRegionAbs(), x, z);
    }

    public boolean contains(@NonNull PlotId id) {
        return this.min == null || id.getX() >= this.min.getX() && id.getX() <= this.max.getX() && id.getY() >= this.min.getY() && id.getY() <= this.max.getY();
    }

    public boolean contains(@NonNull Location location) {
        return StringMan.isEqual(location.getWorldName(), this.getWorldName()) && (this.getRegionAbs() == null || this.region.contains(location.getBlockVector3()));
    }

    public boolean buildRangeContainsY(int y) {
        return y >= this.minBuildHeight && y < this.maxBuildHeight;
    }

    public boolean notifyIfOutsideBuildArea(PlotPlayer<?> player, int y) {
        if (!this.buildRangeContainsY(y) && !player.hasPermission(Permission.PERMISSION_ADMIN_BUILD_HEIGHT_LIMIT)) {
            player.sendMessage((Caption)TranslatableCaption.of("height.height_limit"), TagResolver.builder().tag("minheight", Tag.inserting((Component)Component.text((int)this.minBuildHeight))).tag("maxheight", Tag.inserting((Component)Component.text((int)this.maxBuildHeight))).build());
            return true;
        }
        return false;
    }

    public @NonNull Set<Plot> getPlotsAbs(UUID uuid) {
        if (uuid == null) {
            return Collections.emptySet();
        }
        HashSet<Plot> myPlots = new HashSet<Plot>();
        this.forEachPlotAbs(value -> {
            if (uuid.equals(value.getOwnerAbs())) {
                myPlots.add((Plot)value);
            }
        });
        return myPlots;
    }

    public @NonNull Set<Plot> getPlots(@NonNull UUID uuid) {
        return (Set)this.getPlots().stream().filter(plot -> plot.isBasePlot() && plot.isOwner(uuid)).collect(ImmutableSet.toImmutableSet());
    }

    public Collection<Plot> getPlots() {
        return this.plots.values();
    }

    public int getPlotCount(@NonNull UUID uuid) {
        if (!Settings.Done.COUNTS_TOWARDS_LIMIT) {
            return (int)this.getPlotsAbs(uuid).stream().filter(plot -> !DoneFlag.isDone(plot)).count();
        }
        return this.getPlotsAbs(uuid).size();
    }

    @Deprecated
    public Set<Plot> getPlots(@NonNull PlotPlayer<?> player) {
        return this.getPlots(player.getUUID());
    }

    public boolean hasPlot(@NonNull UUID uuid) {
        return this.plots.entrySet().stream().anyMatch(entry -> ((Plot)entry.getValue()).isOwner(uuid));
    }

    public int getPlotCount(@Nullable PlotPlayer<?> player) {
        return player != null ? this.getPlotCount(player.getUUID()) : 0;
    }

    public @Nullable Plot getPlotAbs(@NonNull PlotId id) {
        Plot plot = this.getOwnedPlotAbs(id);
        if (plot == null) {
            if (this.min != null && (id.getX() < this.min.getX() || id.getX() > this.max.getX() || id.getY() < this.min.getY() || id.getY() > this.max.getY())) {
                return null;
            }
            return new Plot(this, id);
        }
        return plot;
    }

    public @Nullable Plot getPlot(@NonNull PlotId id) {
        Plot plot = this.getOwnedPlotAbs(id);
        if (plot == null) {
            if (this.min != null && (id.getX() < this.min.getX() || id.getX() > this.max.getX() || id.getY() < this.min.getY() || id.getY() > this.max.getY())) {
                return null;
            }
            return new Plot(this, id);
        }
        return plot.getBasePlot(false);
    }

    public int getPlotCount() {
        return this.plots.size();
    }

    public @Nullable PlotCluster getCluster(@NonNull Location location) {
        Plot plot = this.getPlot(location);
        if (plot == null) {
            return null;
        }
        return this.clusters != null ? this.clusters.get(plot.getId().getX(), plot.getId().getY()) : null;
    }

    public @Nullable PlotCluster getFirstIntersectingCluster(@NonNull PlotId pos1, @NonNull PlotId pos2) {
        if (this.clusters == null) {
            return null;
        }
        for (PlotCluster cluster : this.clusters.getAll()) {
            if (!cluster.intersects(pos1, pos2)) continue;
            return cluster;
        }
        return null;
    }

    @Nullable PlotCluster getCluster(@NonNull PlotId id) {
        return this.clusters != null ? this.clusters.get(id.getX(), id.getY()) : null;
    }

    public void setMeta(@NonNull String key, @Nullable Object value) {
        if (this.meta == null) {
            this.meta = new ConcurrentHashMap();
        }
        this.meta.put(key, value);
    }

    public <T> @NonNull T getMeta(@NonNull String key, @NonNull T def) {
        Object v = this.getMeta(key);
        return (T)(v == null ? def : v);
    }

    public @Nullable Object getMeta(@NonNull String key) {
        if (this.meta != null) {
            return this.meta.get(key);
        }
        return null;
    }

    public @NonNull Set<Plot> getBasePlots() {
        HashSet<Plot> myPlots = new HashSet<Plot>(this.getPlots());
        myPlots.removeIf(plot -> !plot.isBasePlot());
        return myPlots;
    }

    private void forEachPlotAbs(Consumer<Plot> run) {
        for (Map.Entry<PlotId, Plot> entry : this.plots.entrySet()) {
            run.accept(entry.getValue());
        }
    }

    public void forEachBasePlot(Consumer<Plot> run) {
        for (Plot plot : this.getPlots()) {
            if (!plot.isBasePlot()) continue;
            run.accept(plot);
        }
    }

    @Deprecated
    public @NonNull Map<PlotId, Plot> getPlotsRaw() {
        return ImmutableMap.copyOf(this.plots);
    }

    public @NonNull Set<Map.Entry<PlotId, Plot>> getPlotEntries() {
        return this.plots.entrySet();
    }

    public boolean addPlot(@NonNull Plot plot) {
        for (PlotPlayer<?> pp : plot.getPlayersInPlot()) {
            MetaDataAccess<Plot> metaDataAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);
            try {
                metaDataAccess.set(plot);
            }
            finally {
                if (metaDataAccess == null) continue;
                metaDataAccess.close();
            }
        }
        return this.plots.put(plot.getId(), plot) == null;
    }

    public Plot getNextFreePlot(PlotPlayer<?> player, @Nullable PlotId start) {
        int plots;
        PlotId center;
        PlotId min = this.getMin();
        PlotId max = this.getMax();
        if (this.getType() == PlotAreaType.PARTIAL) {
            center = PlotId.of(MathMan.average(min.getX(), max.getX()), MathMan.average(min.getY(), max.getY()));
            plots = Math.max(max.getX() - min.getX() + 1, max.getY() - min.getY() + 1) + 1;
            if (start != null) {
                start = PlotId.of(start.getX() - center.getX(), start.getY() - center.getY());
            }
        } else {
            center = PlotId.of(0, 0);
            plots = Integer.MAX_VALUE;
        }
        for (int i = 0; i < plots; ++i) {
            start = start == null ? this.getMeta("lastPlot", PlotId.of(0, 0)) : start.getNextId();
            PlotId currentId = PlotId.of(center.getX() + start.getX(), center.getY() + start.getY());
            Plot plot = this.getPlotAbs(currentId);
            if (plot == null || !plot.canClaim(player)) continue;
            this.setMeta("lastPlot", start);
            return plot;
        }
        return null;
    }

    public boolean addPlotIfAbsent(@NonNull Plot plot) {
        if (this.plots.putIfAbsent(plot.getId(), plot) == null) {
            for (PlotPlayer<?> pp : plot.getPlayersInPlot()) {
                MetaDataAccess<Plot> metaDataAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);
                try {
                    metaDataAccess.set(plot);
                }
                finally {
                    if (metaDataAccess == null) continue;
                    metaDataAccess.close();
                }
            }
            return true;
        }
        return false;
    }

    public boolean addPlotAbs(@NonNull Plot plot) {
        return this.plots.put(plot.getId(), plot) == null;
    }

    @Deprecated(forRemoval=true, since="7.2.0")
    public int getBorder() {
        Integer meta = (Integer)this.getMeta("worldBorder");
        if (meta != null) {
            int border = meta + 1;
            if (border == 0) {
                return Integer.MAX_VALUE;
            }
            return border;
        }
        return Integer.MAX_VALUE;
    }

    public int getBorder(boolean getExtended) {
        Integer meta = (Integer)this.getMeta("worldBorder");
        if (meta != null) {
            int border = meta + 1;
            if (border == 0) {
                return Integer.MAX_VALUE;
            }
            return getExtended ? border + this.borderSize : border;
        }
        return Integer.MAX_VALUE;
    }

    public void setupBorder() {
        if (!this.hasWorldBorder()) {
            return;
        }
        Integer meta = (Integer)this.getMeta("worldBorder");
        if (meta == null) {
            this.setMeta("worldBorder", 1);
        }
        for (Plot plot : this.getPlots()) {
            plot.updateWorldBorder();
        }
    }

    public void deleteMeta(@NonNull String key) {
        if (this.meta != null) {
            this.meta.remove(key);
        }
    }

    public @Nullable List<Plot> canClaim(@Nullable PlotPlayer<?> player, @NonNull PlotId pos1, @NonNull PlotId pos2) {
        if (pos1.getX() == pos2.getX() && pos1.getY() == pos2.getY()) {
            if (this.getOwnedPlot(pos1) != null) {
                return null;
            }
            Plot plot = this.getPlotAbs(pos1);
            if (plot == null) {
                return null;
            }
            if (plot.canClaim(player)) {
                return Collections.singletonList(plot);
            }
            return null;
        }
        LinkedList<Plot> plots = new LinkedList<Plot>();
        for (int x = pos1.getX(); x <= pos2.getX(); ++x) {
            for (int y = pos1.getY(); y <= pos2.getY(); ++y) {
                PlotId id = PlotId.of(x, y);
                Plot plot = this.getPlotAbs(id);
                if (plot == null) {
                    return null;
                }
                if (!plot.canClaim(player)) {
                    return null;
                }
                plots.add(plot);
            }
        }
        return plots;
    }

    public boolean removePlot(@NonNull PlotId id) {
        return this.plots.remove(id) != null;
    }

    public boolean mergePlots(@NonNull List<PlotId> plotIds, boolean removeRoads) {
        return this.mergePlots(plotIds, removeRoads, null);
    }

    public boolean mergePlots(@NonNull List<PlotId> plotIds, boolean removeRoads, @Nullable Runnable whenDone) {
        int y;
        int x;
        if (plotIds.size() < 2) {
            return false;
        }
        PlotId pos1 = plotIds.get(0);
        PlotId pos2 = plotIds.get(plotIds.size() - 1);
        PlotManager manager = this.getPlotManager();
        QueueCoordinator queue = this.getQueue();
        manager.startPlotMerge(plotIds, queue);
        HashSet<UUID> trusted = new HashSet<UUID>();
        HashSet<UUID> members = new HashSet<UUID>();
        HashSet<UUID> denied = new HashSet<UUID>();
        for (x = pos1.getX(); x <= pos2.getX(); ++x) {
            for (y = pos1.getY(); y <= pos2.getY(); ++y) {
                PlotId id = PlotId.of(x, y);
                Plot plot = this.getPlotAbs(id);
                trusted.addAll(plot.getTrusted());
                members.addAll(plot.getMembers());
                denied.addAll(plot.getDenied());
                if (!removeRoads) continue;
                plot.getPlotModificationManager().removeSign();
            }
        }
        members.removeAll(trusted);
        denied.removeAll(trusted);
        denied.removeAll(members);
        for (x = pos1.getX(); x <= pos2.getX(); ++x) {
            for (y = pos1.getY(); y <= pos2.getY(); ++y) {
                Plot plot2;
                boolean lx = x < pos2.getX();
                boolean ly = y < pos2.getY();
                PlotId id = PlotId.of(x, y);
                Plot plot = this.getPlotAbs(id);
                plot.setTrusted(trusted);
                plot.setMembers(members);
                plot.setDenied(denied);
                if (lx) {
                    if (ly && (!plot.isMerged(Direction.EAST) || !plot.isMerged(Direction.SOUTH)) && removeRoads) {
                        plot.getPlotModificationManager().removeRoadSouthEast(queue);
                    }
                    if (!plot.isMerged(Direction.EAST)) {
                        plot2 = plot.getRelative(1, 0);
                        plot.mergePlot(plot2, removeRoads, queue);
                    }
                }
                if (!ly || plot.isMerged(Direction.SOUTH)) continue;
                plot2 = plot.getRelative(0, 1);
                plot.mergePlot(plot2, removeRoads, queue);
            }
        }
        manager.finishPlotMerge(plotIds, queue);
        if (whenDone != null) {
            queue.setCompleteTask(whenDone);
        }
        queue.enqueue();
        return true;
    }

    public Set<Plot> getPlotSelectionOwned(@NonNull PlotId pos1, @NonNull PlotId pos2) {
        int size = (1 + pos2.getX() - pos1.getX()) * (1 + pos2.getY() - pos1.getY());
        HashSet<Plot> result = new HashSet<Plot>();
        if (size < 16 || size < this.getPlotCount()) {
            for (PlotId pid : Lists.newArrayList((Iterable)PlotId.PlotRangeIterator.range(pos1, pos2))) {
                Plot plot = this.getPlotAbs(pid);
                if (!plot.hasOwner() || plot.getId().getX() <= pos1.getX() && plot.getId().getY() <= pos1.getY() && plot.getId().getX() >= pos2.getX() && plot.getId().getY() >= pos2.getY()) continue;
                result.add(plot);
            }
        } else {
            for (Plot plot : this.getPlots()) {
                if (plot.getId().getX() <= pos1.getX() && plot.getId().getY() <= pos1.getY() && plot.getId().getX() >= pos2.getX() && plot.getId().getY() >= pos2.getY()) continue;
                result.add(plot);
            }
        }
        return result;
    }

    public void removeCluster(@Nullable PlotCluster plotCluster) {
        if (this.clusters == null) {
            throw new IllegalAccessError("Clusters not enabled!");
        }
        this.clusters.remove(plotCluster);
    }

    public void addCluster(@Nullable PlotCluster plotCluster) {
        if (this.clusters == null) {
            this.clusters = new QuadMap<PlotCluster>(Integer.MAX_VALUE, 0, 0, 62){

                @Override
                public CuboidRegion getRegion(PlotCluster value) {
                    BlockVector2 pos1 = BlockVector2.at((int)value.getP1().getX(), (int)value.getP1().getY());
                    BlockVector2 pos2 = BlockVector2.at((int)value.getP2().getX(), (int)value.getP2().getY());
                    return new CuboidRegion(pos1.toBlockVector3(PlotArea.this.getMinGenHeight()), pos2.toBlockVector3(PlotArea.this.getMaxGenHeight()));
                }
            };
        }
        this.clusters.add(plotCluster);
    }

    public @Nullable PlotCluster getCluster(String string) {
        for (PlotCluster cluster : this.getClusters()) {
            if (!cluster.getName().equalsIgnoreCase(string)) continue;
            return cluster;
        }
        return null;
    }

    public boolean hasSchematic(@NonNull String schematic) {
        return this.getSchematics().contains(schematic.toLowerCase());
    }

    public boolean useEconomy() {
        return this.useEconomy;
    }

    public boolean hasWorldBorder() {
        return this.worldBorder;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public boolean allowSigns() {
        return this.allowSigns;
    }

    public String signMaterial() {
        return this.signMaterial;
    }

    public String legacySignMaterial() {
        return this.legacySignMaterial;
    }

    public <T> T getFlag(Class<? extends PlotFlag<T, ?>> flagClass) {
        return this.flagContainer.getFlag(flagClass).getValue();
    }

    public <T, V extends PlotFlag<T, ?>> T getFlag(V flag) {
        Class<?> flagClass = flag.getClass();
        PlotFlag<?, ?> flagInstance = this.flagContainer.getFlagErased(flagClass);
        return ((PlotFlag)FlagContainer.castUnsafe(flagInstance)).getValue();
    }

    public <T> T getRoadFlag(Class<? extends PlotFlag<T, ?>> flagClass) {
        return this.roadFlagContainer.getFlag(flagClass).getValue();
    }

    public <T, V extends PlotFlag<T, ?>> T getRoadFlag(V flag) {
        Class<?> flagClass = flag.getClass();
        PlotFlag<?, ?> flagInstance = this.roadFlagContainer.getFlagErased(flagClass);
        return ((PlotFlag)FlagContainer.castUnsafe(flagInstance)).getValue();
    }

    public @NonNull String getWorldName() {
        return this.worldName;
    }

    public String getId() {
        return this.id;
    }

    public @NonNull PlotManager getPlotManager() {
        return this.plotManager;
    }

    public int getWorldHash() {
        return this.worldHash;
    }

    public @NonNull IndependentPlotGenerator getGenerator() {
        return this.generator;
    }

    public boolean isAutoMerge() {
        return this.autoMerge;
    }

    public boolean isMiscSpawnUnowned() {
        return this.miscSpawnUnowned;
    }

    public boolean isMobSpawning() {
        return this.mobSpawning;
    }

    public boolean isMobSpawnerSpawning() {
        return this.mobSpawnerSpawning;
    }

    public BiomeType getPlotBiome() {
        return this.plotBiome;
    }

    public boolean isPlotChat() {
        return this.plotChat;
    }

    public boolean isForcingPlotChat() {
        return this.forcingPlotChat;
    }

    public boolean isSchematicClaimSpecify() {
        return this.schematicClaimSpecify;
    }

    public boolean isSchematicOnClaim() {
        return this.schematicOnClaim;
    }

    public String getSchematicFile() {
        return this.schematicFile;
    }

    public boolean isSpawnEggs() {
        return this.spawnEggs;
    }

    public String getSignMaterial() {
        return this.signMaterial;
    }

    public boolean isSpawnCustom() {
        return this.spawnCustom;
    }

    public boolean isSpawnBreeding() {
        return this.spawnBreeding;
    }

    public PlotAreaType getType() {
        return this.type;
    }

    public void setType(PlotAreaType type) {
        this.type = type;
    }

    public PlotAreaTerrainType getTerrain() {
        return this.terrain;
    }

    public void setTerrain(PlotAreaTerrainType terrain) {
        this.terrain = terrain;
    }

    public boolean isHomeAllowNonmember() {
        return this.homeAllowNonmember;
    }

    public BlockLoc nonmemberHome() {
        return this.nonmemberHome;
    }

    public BlockLoc defaultHome() {
        return this.defaultHome;
    }

    protected void setDefaultHome(BlockLoc defaultHome) {
        this.defaultHome = defaultHome;
    }

    public int getMaxComponentHeight() {
        return this.maxBuildHeight;
    }

    public int getMinComponentHeight() {
        return this.minBuildHeight;
    }

    public int getMaxBuildHeight() {
        return this.maxBuildHeight;
    }

    public int getMinBuildHeight() {
        return this.minBuildHeight;
    }

    public int getMinGenHeight() {
        return this.minGenHeight;
    }

    public int getMaxGenHeight() {
        return this.maxGenHeight;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public Map<String, PlotExpression> getPrices() {
        return this.prices;
    }

    protected List<String> getSchematics() {
        return this.schematics;
    }

    public boolean isRoadFlags() {
        return this.roadFlags;
    }

    public FlagContainer getFlagContainer() {
        return this.flagContainer;
    }

    public FlagContainer getRoadFlagContainer() {
        return this.roadFlagContainer;
    }

    public void setAllowSigns(boolean allowSigns) {
        this.allowSigns = allowSigns;
    }

    static {
        FLAG_DECIMAL_FORMAT.setMaximumFractionDigits(340);
    }
}

