/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.google.common.collect.ImmutableMap;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.serialization.ConfigurationSerializable;
import com.plotsquared.core.util.BlockUtil;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PatternUtil;
import com.plotsquared.core.util.StringMan;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BlockBucket
implements ConfigurationSerializable {
    private static final Pattern regex = Pattern.compile("((?<namespace>[A-Za-z_]+):)?(?<block>([A-Za-z_]+(\\[?[\\S\\s]+\\])?))(:(?<chance>[0-9]{1,3}))?");
    private final StringBuilder input;
    private boolean compiled;
    private BlockState single;
    private com.sk89q.worldedit.function.pattern.Pattern pattern;

    public BlockBucket(@NonNull BlockType type) {
        this(type.getId());
        this.single = type.getDefaultState();
        this.pattern = new BlockPattern((BlockStateHolder)this.single);
        this.compiled = true;
    }

    public BlockBucket(@NonNull BlockState state) {
        this(state.getAsString());
        this.single = state;
        this.pattern = new BlockPattern((BlockStateHolder)this.single);
        this.compiled = true;
    }

    public BlockBucket(@NonNull String input) {
        this.input = new StringBuilder(input);
    }

    public BlockBucket() {
        this.input = new StringBuilder();
    }

    public static BlockBucket withSingle(@NonNull BlockState block) {
        BlockBucket blockBucket = new BlockBucket();
        blockBucket.addBlock(block, 100);
        return blockBucket;
    }

    public static BlockBucket deserialize(@NonNull Map<String, Object> map) {
        if (!map.containsKey("blocks")) {
            return null;
        }
        return ConfigurationUtil.BLOCK_BUCKET.parseString(map.get("blocks").toString());
    }

    public void addBlock(@NonNull BlockState block) {
        this.addBlock(block, -1);
    }

    public void addBlock(@NonNull BlockState block, int chance) {
        this.addBlock(block, (double)chance);
    }

    private void addBlock(@NonNull BlockState block, double chance) {
        if (chance == -1.0) {
            chance = 1.0;
        }
        String prefix = this.input.length() == 0 ? "" : ",";
        this.input.append(prefix).append(block).append(":").append(chance);
        this.compiled = false;
    }

    public boolean isEmpty() {
        return this.input == null || this.input.length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() {
        if (this.isCompiled()) {
            return;
        }
        BlockBucket blockBucket = this;
        synchronized (blockBucket) {
            if (this.isCompiled()) {
                return;
            }
            Object string = this.input.toString();
            if (((String)string).isEmpty()) {
                this.single = null;
                this.pattern = null;
                this.compiled = true;
                return;
            }
            boolean legacy = false;
            Object[] blocksStr = ((String)string).split(",(?![^\\(\\[]*[\\]\\)])");
            if (blocksStr.length == 1) {
                try {
                    Matcher matcher = regex.matcher((CharSequence)string);
                    if (matcher.find()) {
                        String chanceStr = matcher.group("chance");
                        String block = matcher.group("block");
                        if (chanceStr != null && block != null && !MathMan.isInteger(block) && MathMan.isInteger(chanceStr)) {
                            String namespace = matcher.group("namespace");
                            string = (String)(namespace == null ? "" : namespace + ":") + block;
                        }
                    }
                    this.single = BlockUtil.get((String)string);
                    this.pattern = new BlockPattern((BlockStateHolder)this.single);
                    this.compiled = true;
                    return;
                }
                catch (Exception matcher) {
                    // empty catch block
                }
            }
            for (int i = 0; i < blocksStr.length; ++i) {
                String chanceStr;
                Object entry = blocksStr[i];
                Matcher matcher = regex.matcher((CharSequence)entry);
                if (!matcher.find() || (chanceStr = matcher.group("chance")) == null || !MathMan.isInteger(chanceStr)) continue;
                Object[] parts = ((String)entry).split(":");
                parts = Arrays.copyOf(parts, parts.length - 1);
                blocksStr[i] = entry = chanceStr + "%" + StringMan.join(parts, ":");
                legacy = true;
            }
            if (legacy) {
                string = StringMan.join(blocksStr, ",");
            }
            this.pattern = PatternUtil.parse(null, (String)string);
            this.compiled = true;
        }
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public com.sk89q.worldedit.function.pattern.Pattern toPattern() {
        this.compile();
        return this.pattern;
    }

    public String toString() {
        return this.input.toString();
    }

    public boolean isAir() {
        this.compile();
        return this.isEmpty() || this.single != null && this.single.getBlockType().getMaterial().isAir();
    }

    @Override
    public Map<String, Object> serialize() {
        if (!this.isCompiled()) {
            this.compile();
        }
        return ImmutableMap.of((Object)"blocks", (Object)this.toString());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockBucket)) {
            return false;
        }
        BlockBucket other = (BlockBucket)o;
        StringBuilder this$input = this.input;
        StringBuilder other$input = other.input;
        return Objects.equals(this$input, other$input);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringBuilder $input = this.input;
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        return result;
    }

    private record Range(int min, int max, boolean automatic) {
        public int getWeight() {
            return this.max - this.min;
        }

        public boolean isInRange(int num) {
            return num <= this.max && num >= this.min;
        }
    }
}

