/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.HideInfoFlag;
import com.plotsquared.core.util.TabCompletions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@CommandDeclaration(command="info", aliases={"i"}, usage="/plot info <id> [-f to force info]", category=CommandCategory.INFO)
public class Info
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        boolean full;
        Plot plot;
        String arg;
        if (args.length > 0) {
            switch (arg = args[0]) {
                case "trusted": 
                case "alias": 
                case "biome": 
                case "denied": 
                case "flags": 
                case "id": 
                case "size": 
                case "members": 
                case "creationdate": 
                case "seen": 
                case "owner": 
                case "rating": 
                case "likes": {
                    plot = Plot.getPlotFromString(player, null, false);
                    break;
                }
                default: {
                    plot = Plot.getPlotFromString(player, arg, false);
                    arg = args.length == 2 ? args[1] : null;
                }
            }
            if (plot == null) {
                plot = player.getCurrentPlot();
            }
        } else {
            arg = null;
            plot = player.getCurrentPlot();
        }
        if (plot == null) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (arg != null) {
            args = args.length == 1 ? new String[]{} : new String[]{args[1]};
        }
        if (((Boolean)plot.getFlag(HideInfoFlag.class)).booleanValue()) {
            boolean allowed = false;
            for (String argument : args) {
                if (!argument.equalsIgnoreCase("-f")) continue;
                if (!player.hasPermission(Permission.PERMISSION_AREA_INFO_FORCE.toString())) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_AREA_INFO_FORCE))});
                    return true;
                }
                allowed = true;
                break;
            }
            if (!allowed) {
                player.sendMessage((Caption)TranslatableCaption.of("info.plot_info_hidden"), new TagResolver[0]);
                return true;
            }
        }
        boolean hasOwner = plot.hasOwner();
        boolean containsEveryone = plot.getTrusted().contains(DBFunc.EVERYONE);
        boolean trustedEveryone = plot.getMembers().contains(DBFunc.EVERYONE);
        if (!(hasOwner || containsEveryone || trustedEveryone)) {
            player.sendMessage((Caption)TranslatableCaption.of("info.plot_info_unclaimed"), new TagResolver[]{TagResolver.resolver((String)"plot", (Tag)Tag.inserting((Component)Component.text((String)(plot.getId().getX() + ";" + plot.getId().getY()))))});
            return true;
        }
        Caption info = TranslatableCaption.of("info.plot_info_format");
        if (arg != null) {
            info = this.getCaption(arg);
            if (info == null) {
                if (Settings.Ratings.USE_LIKES) {
                    player.sendMessage((Caption)StaticCaption.of("&6Categories&7: &amembers&7, &aalias&7, &abiome&7, &aseen&7, &adenied&7, &aflags&7, &aid&7, &asize&7, &atrusted&7, &aowner&7,  &alikes"), new TagResolver[0]);
                } else {
                    player.sendMessage((Caption)StaticCaption.of("&6Categories&7: &amembers&7, &aalias&7, &abiome&7, &aseen&7, &adenied&7, &aflags&7, &aid&7, &asize&7, &atrusted&7, &aowner&7,  &arating"), new TagResolver[0]);
                }
                return false;
            }
            full = true;
        } else {
            full = false;
        }
        plot.format(info, player, full).thenAcceptAsync(x$0 -> player.sendMessage((Caption)x$0, new TagResolver[0]));
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        LinkedList<String> completions = new LinkedList<String>();
        if (player.hasPermission(Permission.PERMISSION_AREA_INFO_FORCE)) {
            completions.add("-f");
        }
        List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.PLAYER, CommandCategory.INFO){}).collect(Collectors.toCollection(LinkedList::new));
        if (player.hasPermission(Permission.PERMISSION_AREA_INFO_FORCE) && args[0].length() > 0) {
            commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
        }
        return commands;
    }

    private Caption getCaption(String string) {
        return switch (string) {
            case "trusted" -> TranslatableCaption.of("info.plot_info_trusted");
            case "alias" -> TranslatableCaption.of("info.plot_info_alias");
            case "biome" -> TranslatableCaption.of("info.plot_info_biome");
            case "denied" -> TranslatableCaption.of("info.plot_info_denied");
            case "flags" -> TranslatableCaption.of("info.plot_info_flags");
            case "id" -> TranslatableCaption.of("info.plot_info_id");
            case "size" -> TranslatableCaption.of("info.plot_info_size");
            case "members" -> TranslatableCaption.of("info.plot_info_members");
            case "owner" -> TranslatableCaption.of("info.plot_info_owner");
            case "rating" -> TranslatableCaption.of("info.plot_info_rating");
            case "likes" -> TranslatableCaption.of("info.plot_info_likes");
            case "seen" -> TranslatableCaption.of("info.plot_info_seen");
            case "creationdate" -> TranslatableCaption.of("info.plot_info_creationdate");
            default -> null;
        };
    }
}

