/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.generator.AugmentedUtils;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.annotations.WorldFile;
import com.plotsquared.core.inject.factory.HybridPlotWorldFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.RunnableVal3;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EditSessionBuilder;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="area", permission="plots.area", category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.NONE, aliases={"world"}, usage="/plot area <create | info | list | tp | regen>", confirmation=true)
public class Area
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final YamlConfiguration worldConfiguration;
    private final File worldFile;
    private final HybridPlotWorldFactory hybridPlotWorldFactory;
    private final SetupUtils setupUtils;
    private final WorldUtil worldUtil;
    private final GlobalBlockQueue blockQueue;
    private final Map<UUID, Map<String, Object>> metaData = new HashMap<UUID, Map<String, Object>>();

    @Inject
    public Area(@NonNull PlotAreaManager plotAreaManager, @WorldConfig @NonNull YamlConfiguration worldConfiguration, @WorldFile @NonNull File worldFile, @NonNull HybridPlotWorldFactory hybridPlotWorldFactory, @NonNull SetupUtils setupUtils, @NonNull WorldUtil worldUtil, @NonNull GlobalBlockQueue blockQueue) {
        this.plotAreaManager = plotAreaManager;
        this.worldConfiguration = worldConfiguration;
        this.worldFile = worldFile;
        this.hybridPlotWorldFactory = hybridPlotWorldFactory;
        this.setupUtils = setupUtils;
        this.worldUtil = worldUtil;
        this.blockQueue = blockQueue;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        if (args.length == 0) {
            this.sendUsage(player);
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "single": {
                if (player instanceof ConsolePlayer) {
                    player.sendMessage(RequiredType.CONSOLE.getErrorMessage(), new TagResolver[0]);
                    return false;
                }
                if (!player.hasPermission(Permission.PERMISSION_AREA_CREATE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_AREA_CREATE))});
                    return false;
                }
                if (args.length < 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("single.single_area_needs_name"), new TagResolver[]{TagResolver.resolver((String)"command", (Tag)Tag.inserting((Component)Component.text((String)"/plot area single <name>")))});
                    return false;
                }
                PlotArea existingArea = this.plotAreaManager.getPlotArea(player.getLocation().getWorldName(), args[1]);
                if (existingArea != null && existingArea.getId().equalsIgnoreCase(args[1])) {
                    player.sendMessage((Caption)TranslatableCaption.of("single.single_area_name_taken"), new TagResolver[0]);
                    return false;
                }
                LocalSession localSession = WorldEdit.getInstance().getSessionManager().getIfPresent((SessionOwner)player.toActor());
                if (localSession == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("single.single_area_missing_selection"), new TagResolver[0]);
                    return false;
                }
                Region playerSelectedRegion = null;
                try {
                    playerSelectedRegion = localSession.getSelection(((Player)player.toActor()).getWorld());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (playerSelectedRegion == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("single.single_area_missing_selection"), new TagResolver[0]);
                    return false;
                }
                if (playerSelectedRegion.getWidth() != playerSelectedRegion.getLength()) {
                    player.sendMessage((Caption)TranslatableCaption.of("single.single_area_not_square"), new TagResolver[0]);
                    return false;
                }
                if (this.plotAreaManager.getPlotAreas(Objects.requireNonNull(playerSelectedRegion.getWorld()).getName(), CuboidRegion.makeCuboid((Region)playerSelectedRegion)).length != 0) {
                    player.sendMessage((Caption)TranslatableCaption.of("single.single_area_overlapping"), new TagResolver[0]);
                }
                BlockVector3 playerSelectionMin = playerSelectedRegion.getMinimumPoint();
                BlockVector3 playerSelectionMax = playerSelectedRegion.getMaximumPoint();
                World world = playerSelectedRegion.getWorld();
                CuboidRegion selectedRegion = new CuboidRegion(playerSelectedRegion.getWorld(), BlockVector3.at((int)playerSelectionMin.getX(), (int)world.getMinY(), (int)playerSelectionMin.getZ()), BlockVector3.at((int)playerSelectionMax.getX(), (int)world.getMaxY(), (int)playerSelectionMax.getZ()));
                PlotId plotId = PlotId.of(1, 1);
                HybridPlotWorld hybridPlotWorld = this.hybridPlotWorldFactory.create(player.getLocation().getWorldName(), args[1], Objects.requireNonNull(PlotSquared.platform()).defaultGenerator(), plotId, plotId);
                hybridPlotWorld.SIZE = (short)selectedRegion.getWidth();
                hybridPlotWorld.PLOT_WIDTH = hybridPlotWorld.SIZE;
                hybridPlotWorld.setTerrain(PlotAreaTerrainType.NONE);
                hybridPlotWorld.setType(PlotAreaType.PARTIAL);
                hybridPlotWorld.PLOT_SCHEMATIC = true;
                hybridPlotWorld.ROAD_OFFSET_Z = 0;
                hybridPlotWorld.ROAD_OFFSET_X = 0;
                hybridPlotWorld.ROAD_WIDTH = 0;
                hybridPlotWorld.ROAD_HEIGHT = hybridPlotWorld.WALL_HEIGHT = playerSelectionMin.getBlockY();
                hybridPlotWorld.PLOT_HEIGHT = hybridPlotWorld.WALL_HEIGHT;
                hybridPlotWorld.setAllowSigns(false);
                File parentFile = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS + File.separator + "GEN_ROAD_SCHEMATIC" + File.separator + hybridPlotWorld.getWorldName() + File.separator + hybridPlotWorld.getId());
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    player.sendMessage((Caption)TranslatableCaption.of("single.single_area_could_not_make_directories"), new TagResolver[0]);
                    return false;
                }
                File file = new File(parentFile, "plot.schem");
                try (ClipboardWriter clipboardWriter = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(file));){
                    BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)selectedRegion);
                    EditSessionBuilder editSessionBuilder = WorldEdit.getInstance().newEditSessionBuilder();
                    editSessionBuilder.world(selectedRegion.getWorld());
                    EditSession editSession = editSessionBuilder.build();
                    ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, (Region)selectedRegion, (Extent)clipboard, selectedRegion.getMinimumPoint());
                    forwardExtentCopy.setCopyingBiomes(true);
                    forwardExtentCopy.setCopyingEntities(true);
                    Operations.complete((Operation)forwardExtentCopy);
                    clipboardWriter.write((Clipboard)clipboard);
                }
                catch (Exception e) {
                    player.sendMessage((Caption)TranslatableCaption.of("single.single_area_failed_to_save"), new TagResolver[0]);
                    e.printStackTrace();
                    return false;
                }
                try {
                    hybridPlotWorld.setupSchematics();
                }
                catch (SchematicHandler.UnsupportedFormatException e) {
                    e.printStackTrace();
                }
                BlockVector3 singlePos1 = selectedRegion.getMinimumPoint();
                PlotAreaBuilder singleBuilder = PlotAreaBuilder.ofPlotArea(hybridPlotWorld).plotManager(PlotSquared.platform().pluginName()).generatorName(PlotSquared.platform().pluginName()).maximumId(plotId).minimumId(plotId);
                Runnable singleRun = () -> {
                    String worldName;
                    String path = "worlds." + hybridPlotWorld.getWorldName() + ".areas." + hybridPlotWorld.getId() + "-" + singleBuilder.minimumId() + "-" + singleBuilder.maximumId();
                    int offsetX = singlePos1.getX();
                    int offsetZ = singlePos1.getZ();
                    if (offsetX != 0) {
                        this.worldConfiguration.set(path + ".road.offset.x", offsetX);
                    }
                    if (offsetZ != 0) {
                        this.worldConfiguration.set(path + ".road.offset.z", offsetZ);
                    }
                    if (this.worldUtil.isWorld(worldName = this.setupUtils.setupWorld(singleBuilder))) {
                        PlotSquared.get().loadWorld(worldName, null);
                        player.sendMessage((Caption)TranslatableCaption.of("single.single_area_created"), new TagResolver[0]);
                    } else {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.error_create"), new TagResolver[]{TagResolver.resolver((String)"world", (Tag)Tag.inserting((Component)Component.text((String)hybridPlotWorld.getWorldName())))});
                    }
                };
                singleRun.run();
                return true;
            }
            case "c": 
            case "setup": 
            case "create": {
                if (!player.hasPermission(Permission.PERMISSION_AREA_CREATE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_AREA_CREATE))});
                    return false;
                }
                switch (args.length) {
                    case 1: {
                        player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot area create [world[:id]] [<modifier>=<value>]...")))});
                        return false;
                    }
                    case 2: {
                        switch (args[1].toLowerCase()) {
                            case "pos1": {
                                HybridPlotWorld area = (HybridPlotWorld)this.metaData.computeIfAbsent(player.getUUID(), missingUUID -> new HashMap()).get("area_create_area");
                                if (area == null) {
                                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot area create [world[:id]] [<modifier>=<value>]...")))});
                                    return false;
                                }
                                Location location = player.getLocation();
                                this.metaData.computeIfAbsent(player.getUUID(), missingUUID -> new HashMap()).put("area_pos1", location);
                                player.sendMessage((Caption)TranslatableCaption.of("set.set_attribute"), TagResolver.builder().tag("attribute", Tag.inserting((Component)Component.text((String)"area_pos1"))).tag("value", Tag.inserting((Component)((TextComponent)Component.text((int)location.getX()).append((Component)Component.text((String)","))).append((Component)Component.text((int)location.getZ())))).build());
                                player.sendMessage((Caption)TranslatableCaption.of("area.set_pos2"), new TagResolver[]{TagResolver.resolver((String)"command", (Tag)Tag.inserting((Component)Component.text((String)"/plot area create pos2")))});
                                return true;
                            }
                            case "pos2": {
                                HybridPlotWorld area = (HybridPlotWorld)this.metaData.computeIfAbsent(player.getUUID(), missingUUID -> new HashMap()).get("area_create_area");
                                if (area == null) {
                                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot area create [world[:id]] [<modifier>=<value>]...")))});
                                    return false;
                                }
                                Location pos1 = player.getLocation();
                                Location pos2 = (Location)this.metaData.computeIfAbsent(player.getUUID(), missingUUID -> new HashMap()).get("area_pos1");
                                int dx = Math.abs(pos1.getX() - pos2.getX());
                                int dz = Math.abs(pos1.getZ() - pos2.getZ());
                                int numX = Math.max(1, (dx + 1 + area.ROAD_WIDTH + area.SIZE / 2) / area.SIZE);
                                int numZ = Math.max(1, (dz + 1 + area.ROAD_WIDTH + area.SIZE / 2) / area.SIZE);
                                int ddx = dx - (numX * area.SIZE - area.ROAD_WIDTH);
                                int ddz = dz - (numZ * area.SIZE - area.ROAD_WIDTH);
                                int bx = Math.min(pos1.getX(), pos2.getX()) + ddx;
                                int bz = Math.min(pos1.getZ(), pos2.getZ()) + ddz;
                                int tx = Math.max(pos1.getX(), pos2.getX()) - ddx;
                                int tz = Math.max(pos1.getZ(), pos2.getZ()) - ddz;
                                int lower = (area.ROAD_WIDTH & 1) == 0 ? area.ROAD_WIDTH / 2 - 1 : area.ROAD_WIDTH / 2;
                                int offsetX = bx - (area.ROAD_WIDTH == 0 ? 0 : lower);
                                int offsetZ = bz - (area.ROAD_WIDTH == 0 ? 0 : lower);
                                CuboidRegion region = RegionUtil.createRegion(bx, tx, 0, 0, bz, tz);
                                Set<PlotArea> areas = this.plotAreaManager.getPlotAreasSet(area.getWorldName(), region);
                                if (!areas.isEmpty()) {
                                    player.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_intersection"), new TagResolver[]{TagResolver.resolver((String)"cluster", (Tag)Tag.inserting((ComponentLike)areas.iterator().next()))});
                                    return false;
                                }
                                PlotAreaBuilder builder = PlotAreaBuilder.ofPlotArea(area).plotManager(PlotSquared.platform().pluginName()).generatorName(PlotSquared.platform().pluginName()).minimumId(PlotId.of(1, 1)).maximumId(PlotId.of(numX, numZ));
                                String path = "worlds." + area.getWorldName() + ".areas." + area.getId() + "-" + builder.minimumId() + "-" + builder.maximumId();
                                Runnable run = () -> {
                                    String world;
                                    if (offsetX != 0) {
                                        this.worldConfiguration.set(path + ".road.offset.x", offsetX);
                                    }
                                    if (offsetZ != 0) {
                                        this.worldConfiguration.set(path + ".road.offset.z", offsetZ);
                                    }
                                    if (this.worldUtil.isWorld(world = this.setupUtils.setupWorld(builder))) {
                                        PlotSquared.get().loadWorld(world, null);
                                        player.teleport(this.worldUtil.getSpawn(world), TeleportCause.COMMAND_AREA_CREATE);
                                        player.sendMessage((Caption)TranslatableCaption.of("setup.setup_finished"), new TagResolver[0]);
                                        if (area.getTerrain() != PlotAreaTerrainType.ALL) {
                                            QueueCoordinator queue = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(world));
                                            queue.setChunkConsumer(chunk -> AugmentedUtils.generateChunk(world, chunk.getX(), chunk.getZ(), null));
                                            queue.addReadChunks(region.getChunks());
                                            queue.enqueue();
                                        }
                                    } else {
                                        player.sendMessage((Caption)TranslatableCaption.of("errors.error_create"), new TagResolver[]{TagResolver.resolver((String)"world", (Tag)Tag.inserting((Component)Component.text((String)area.getWorldName())))});
                                    }
                                };
                                if (this.hasConfirmation(player)) {
                                    CmdConfirm.addPending(player, this.getCommandString() + " create pos2 (Creates world)", run);
                                } else {
                                    run.run();
                                }
                                return true;
                            }
                        }
                    }
                }
                String[] split = args[1].split(":");
                String id = split.length == 2 ? split[1] : null;
                PlotAreaBuilder builder = PlotAreaBuilder.newBuilder();
                builder.worldName(split[0]);
                HybridPlotWorld pa = this.hybridPlotWorldFactory.create(builder.worldName(), id, PlotSquared.platform().defaultGenerator(), null, null);
                PlotArea other = this.plotAreaManager.getPlotArea(pa.getWorldName(), id);
                if (other != null && Objects.equals(pa.getId(), other.getId())) {
                    player.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_taken"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)pa.getId())))});
                    return false;
                }
                Set<PlotArea> areas = this.plotAreaManager.getPlotAreasSet(pa.getWorldName());
                if (!areas.isEmpty()) {
                    PlotArea area = areas.iterator().next();
                    pa.setType(area.getType());
                }
                pa.SIZE = (short)(pa.PLOT_WIDTH + pa.ROAD_WIDTH);
                block90: for (int i = 2; i < args.length; ++i) {
                    String[] pair = args[i].split("=");
                    if (pair.length != 2) {
                        player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting((Component)Component.text((String)this.getCommandString()))).tag("value2", Tag.inserting((Component)Component.text((String)"create [world[:id]] [<modifier>=<value>]..."))).build());
                        return false;
                    }
                    switch (pair[0].toLowerCase()) {
                        case "s": 
                        case "size": {
                            pa.PLOT_WIDTH = Integer.parseInt(pair[1]);
                            pa.SIZE = (short)(pa.PLOT_WIDTH + pa.ROAD_WIDTH);
                            continue block90;
                        }
                        case "g": 
                        case "gap": {
                            pa.ROAD_WIDTH = Integer.parseInt(pair[1]);
                            pa.SIZE = (short)(pa.PLOT_WIDTH + pa.ROAD_WIDTH);
                            continue block90;
                        }
                        case "h": 
                        case "height": {
                            int value;
                            pa.PLOT_HEIGHT = value = Integer.parseInt(pair[1]);
                            pa.ROAD_HEIGHT = value;
                            pa.WALL_HEIGHT = value;
                            continue block90;
                        }
                        case "f": 
                        case "floor": {
                            pa.TOP_BLOCK = ConfigurationUtil.BLOCK_BUCKET.parseString(pair[1]);
                            continue block90;
                        }
                        case "m": 
                        case "main": {
                            pa.MAIN_BLOCK = ConfigurationUtil.BLOCK_BUCKET.parseString(pair[1]);
                            continue block90;
                        }
                        case "w": 
                        case "wall": {
                            pa.WALL_FILLING = ConfigurationUtil.BLOCK_BUCKET.parseString(pair[1]);
                            continue block90;
                        }
                        case "b": 
                        case "border": {
                            pa.WALL_BLOCK = ConfigurationUtil.BLOCK_BUCKET.parseString(pair[1]);
                            continue block90;
                        }
                        case "terrain": {
                            pa.setTerrain(PlotAreaTerrainType.fromString(pair[1]).orElseThrow(() -> new IllegalArgumentException(pair[1] + " is not a valid terrain.")));
                            builder.terrainType(pa.getTerrain());
                            continue block90;
                        }
                        case "type": {
                            pa.setType(PlotAreaType.fromString(pair[1]).orElseThrow(() -> new IllegalArgumentException(pair[1] + " is not a valid type.")));
                            builder.plotAreaType(pa.getType());
                            continue block90;
                        }
                        default: {
                            player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting((Component)Component.text((String)this.getCommandString()))).tag("value2", Tag.inserting((Component)Component.text((String)" create [world[:id]] [<modifier>=<value>]..."))).build());
                            return false;
                        }
                    }
                }
                if (pa.getType() != PlotAreaType.PARTIAL) {
                    if (this.worldUtil.isWorld(pa.getWorldName())) {
                        player.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_taken"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)pa.getWorldName())))});
                        return false;
                    }
                    Runnable run = () -> {
                        String path = "worlds." + pa.getWorldName();
                        if (!this.worldConfiguration.contains(path)) {
                            this.worldConfiguration.createSection(path);
                        }
                        ConfigurationSection section = this.worldConfiguration.getConfigurationSection(path);
                        pa.saveConfiguration(section);
                        pa.loadConfiguration(section);
                        builder.plotManager(PlotSquared.platform().pluginName());
                        builder.generatorName(PlotSquared.platform().pluginName());
                        String world = this.setupUtils.setupWorld(builder);
                        if (this.worldUtil.isWorld(world)) {
                            player.teleport(this.worldUtil.getSpawn(world), TeleportCause.COMMAND_AREA_CREATE);
                            player.sendMessage((Caption)TranslatableCaption.of("setup.setup_finished"), new TagResolver[0]);
                        } else {
                            player.sendMessage((Caption)TranslatableCaption.of("errors.error_create"), new TagResolver[]{TagResolver.resolver((String)"world", (Tag)Tag.inserting((Component)Component.text((String)pa.getWorldName())))});
                        }
                        try {
                            this.worldConfiguration.save(this.worldFile);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    };
                    if (this.hasConfirmation(player)) {
                        CmdConfirm.addPending(player, this.getCommandString() + " " + StringMan.join(args, " "), run);
                    } else {
                        run.run();
                    }
                    return true;
                }
                if (pa.getId() == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)this.getUsage())))});
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting((Component)Component.text((String)this.getCommandString()))).tag("value2", Tag.inserting((Component)Component.text((String)" create [world[:id]] [<modifier>=<value>]..."))).build());
                    return false;
                }
                if (this.worldUtil.isWorld(pa.getWorldName())) {
                    if (!player.getLocation().getWorldName().equals(pa.getWorldName())) {
                        player.teleport(this.worldUtil.getSpawn(pa.getWorldName()), TeleportCause.COMMAND_AREA_CREATE);
                    }
                } else {
                    builder.terrainType(PlotAreaTerrainType.NONE);
                    builder.plotAreaType(PlotAreaType.NORMAL);
                    this.setupUtils.setupWorld(builder);
                    player.teleport(this.worldUtil.getSpawn(pa.getWorldName()), TeleportCause.COMMAND_AREA_CREATE);
                }
                this.metaData.computeIfAbsent(player.getUUID(), missingUUID -> new HashMap()).put("area_create_area", pa);
                player.sendMessage((Caption)TranslatableCaption.of("single.get_position"), new TagResolver[]{TagResolver.resolver((String)"command", (Tag)Tag.inserting((Component)Component.text((String)this.getCommandString())))});
                return true;
            }
            case "i": 
            case "info": {
                String region;
                double percent;
                Object name;
                PlotArea area;
                if (!player.hasPermission(Permission.PERMISSION_AREA_INFO)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_AREA_INFO))});
                    return false;
                }
                switch (args.length) {
                    case 1: {
                        area = player.getApplicablePlotArea();
                        break;
                    }
                    case 2: {
                        area = this.plotAreaManager.getPlotAreaByString(args[1]);
                        break;
                    }
                    default: {
                        player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting((Component)Component.text((String)this.getCommandString()))).tag("value2", Tag.inserting((Component)Component.text((String)" info [area]"))).build());
                        return false;
                    }
                }
                if (area == null) {
                    if (args.length == 2) {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                    } else {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    }
                    return false;
                }
                int claimed = area.getPlotCount();
                int clusters = area.getClusters().size();
                String generator = String.valueOf(area.getGenerator());
                if (area.getType() == PlotAreaType.PARTIAL) {
                    PlotId min = area.getMin();
                    PlotId max = area.getMax();
                    name = area.getWorldName() + ";" + area.getId() + ";" + min + ";" + max;
                    int size = (max.getX() - min.getX() + 1) * (max.getY() - min.getY() + 1);
                    percent = claimed == 0 ? 0.0 : (double)size / (double)claimed;
                    region = area.getRegion().toString();
                } else {
                    name = area.getWorldName();
                    percent = claimed == 0 ? 0.0 : 100.0 * (double)claimed / 2.147483647E9;
                    region = "N/A";
                }
                TagResolver resolver = TagResolver.builder().tag("header", Tag.inserting((Component)TranslatableCaption.of("info.plot_info_header").toComponent(player))).tag("name", Tag.inserting((Component)Component.text((String)name))).tag("type", Tag.inserting((Component)Component.text((String)area.getType().name()))).tag("terrain", Tag.inserting((Component)Component.text((String)area.getTerrain().name()))).tag("usage", Tag.inserting((Component)Component.text((String)String.format("%.2f", percent)))).tag("claimed", Tag.inserting((Component)Component.text((int)claimed))).tag("clusters", Tag.inserting((Component)Component.text((int)clusters))).tag("region", Tag.inserting((Component)Component.text((String)region))).tag("generator", Tag.inserting((Component)Component.text((String)generator))).tag("footer", Tag.inserting((Component)TranslatableCaption.of("info.plot_info_footer").toComponent(player))).build();
                player.sendMessage((Caption)TranslatableCaption.of("info.area_info_format"), resolver);
                return true;
            }
            case "l": 
            case "list": {
                int page;
                if (!player.hasPermission(Permission.PERMISSION_AREA_LIST)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_AREA_LIST))});
                    return false;
                }
                switch (args.length) {
                    case 1: {
                        page = 0;
                        break;
                    }
                    case 2: {
                        if (MathMan.isInteger(args[1])) {
                            page = Integer.parseInt(args[1]) - 1;
                            break;
                        }
                    }
                    default: {
                        player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting((Component)Component.text((String)this.getCommandString()))).tag("value2", Tag.inserting((Component)Component.text((String)" list [#]"))).build());
                        return false;
                    }
                }
                ArrayList<PlotArea> areas = new ArrayList<PlotArea>(Arrays.asList(this.plotAreaManager.getAllPlotAreas()));
                this.paginate(player, areas, 8, page, new RunnableVal3<Integer, PlotArea, CaptionHolder>(){

                    @Override
                    public void run(Integer i, PlotArea area, CaptionHolder caption) {
                        String region;
                        double percent;
                        Object name;
                        int claimed = area.getPlotCount();
                        int clusters = area.getClusters().size();
                        String generator = String.valueOf(area.getGenerator());
                        if (area.getType() == PlotAreaType.PARTIAL) {
                            PlotId min = area.getMin();
                            PlotId max = area.getMax();
                            name = area.getWorldName() + ";" + area.getId() + ";" + min + ";" + max;
                            int size = (max.getX() - min.getX() + 1) * (max.getY() - min.getY() + 1);
                            percent = claimed == 0 ? 0.0 : (double)claimed / (double)size;
                            region = area.getRegion().toString();
                        } else {
                            name = area.getWorldName();
                            percent = claimed == 0 ? 0.0 : (double)claimed / 32767.0 * 32767.0;
                            region = "N/A";
                        }
                        Component tooltip = Command.MINI_MESSAGE.deserialize(TranslatableCaption.of("info.area_list_tooltip").getComponent(player), TagResolver.builder().tag("claimed", Tag.inserting((Component)Component.text((int)claimed))).tag("usage", Tag.inserting((Component)Component.text((String)(String.format("%.2f", percent) + "%")))).tag("clusters", Tag.inserting((Component)Component.text((int)clusters))).tag("region", Tag.inserting((Component)Component.text((String)region))).tag("generator", Tag.inserting((Component)Component.text((String)generator))).build());
                        TagResolver resolver = TagResolver.builder().tag("hover_info", Tag.inserting((Component)tooltip)).tag("command_tp", (Tag)Tag.preProcessParsed((String)("/plot area tp " + (String)name))).tag("command_info", (Tag)Tag.preProcessParsed((String)("/plot area info " + (String)name))).tag("number", Tag.inserting((Component)Component.text((int)i))).tag("area_name", Tag.inserting((Component)Component.text((String)name))).tag("area_type", Tag.inserting((Component)Component.text((String)area.getType().name()))).tag("area_terrain", Tag.inserting((Component)Component.text((String)area.getTerrain().name()))).build();
                        caption.set(TranslatableCaption.of("info.area_list_item"));
                        caption.setTagResolvers(resolver);
                    }
                }, "/plot area list", TranslatableCaption.of("list.area_list_header_paged"));
                return true;
            }
            case "regen": 
            case "clear": 
            case "reset": 
            case "regenerate": {
                if (!player.hasPermission(Permission.PERMISSION_AREA_REGEN)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_AREA_REGEN))});
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                if (area.getType() != PlotAreaType.PARTIAL) {
                    player.sendMessage((Caption)TranslatableCaption.of("single.delete_world_region"), new TagResolver[]{TagResolver.resolver((String)"world", (Tag)Tag.inserting((Component)Component.text((String)area.getWorldName())))});
                    return false;
                }
                QueueCoordinator queue = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(area.getWorldName()));
                queue.setChunkConsumer(chunk -> AugmentedUtils.generateChunk(area.getWorldName(), chunk.getX(), chunk.getZ(), null));
                queue.addReadChunks(area.getRegion().getChunks());
                queue.setCompleteTask(() -> player.sendMessage((Caption)TranslatableCaption.of("single.regeneration_complete"), new TagResolver[0]));
                queue.enqueue();
                return true;
            }
            case "goto": 
            case "v": 
            case "teleport": 
            case "visit": 
            case "tp": {
                if (!player.hasPermission(Permission.PERMISSION_AREA_TP)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_AREA_TP))});
                    return false;
                }
                if (args.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot area tp [area]")))});
                    return false;
                }
                PlotArea area = this.plotAreaManager.getPlotAreaByString(args[1]);
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                    return false;
                }
                if (area instanceof SinglePlotArea) {
                    ((SinglePlotArea)area).loadWorld(PlotId.of(0, 0));
                    Location center = this.worldUtil.getSpawn(PlotId.of(0, 0).toUnderscoreSeparatedString());
                    player.teleport(center, TeleportCause.COMMAND_AREA_TELEPORT);
                } else if (area.getType() != PlotAreaType.PARTIAL) {
                    Location center = this.worldUtil.getSpawn(area.getWorldName());
                    player.teleport(center, TeleportCause.COMMAND_AREA_TELEPORT);
                } else {
                    CuboidRegion region = area.getRegion();
                    Location center = Location.at(area.getWorldName(), region.getMinimumPoint().getX() + (region.getMaximumPoint().getX() - region.getMinimumPoint().getX()) / 2, 0, region.getMinimumPoint().getZ() + (region.getMaximumPoint().getZ() - region.getMinimumPoint().getZ()) / 2);
                    this.worldUtil.getHighestBlock(area.getWorldName(), center.getX(), center.getZ(), y -> player.teleport(center.withY(1 + y), TeleportCause.COMMAND_AREA_TELEPORT));
                }
                return true;
            }
            case "delete": 
            case "remove": {
                player.sendMessage((Caption)TranslatableCaption.of("single.worldcreation_location"), new TagResolver[0]);
                return true;
            }
        }
        this.sendUsage(player);
        return false;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (player.hasPermission(Permission.PERMISSION_AREA_CREATE)) {
                completions.add("create");
            }
            if (player.hasPermission(Permission.PERMISSION_AREA_CREATE)) {
                completions.add("single");
            }
            if (player.hasPermission(Permission.PERMISSION_AREA_LIST)) {
                completions.add("list");
            }
            if (player.hasPermission(Permission.PERMISSION_AREA_INFO)) {
                completions.add("info");
            }
            if (player.hasPermission(Permission.PERMISSION_AREA_TP)) {
                completions.add("tp");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (player.hasPermission(Permission.PERMISSION_AREA) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

