/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.comment;

import com.google.inject.TypeLiteral;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.comment.CommentInbox;
import com.plotsquared.core.plot.comment.InboxOwner;
import com.plotsquared.core.plot.comment.InboxPublic;
import com.plotsquared.core.plot.comment.InboxReport;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public class CommentManager {
    public static final HashMap<String, CommentInbox> inboxes = new HashMap();

    public static void sendTitle(final PlotPlayer<?> player, Plot plot) {
        if (!Settings.Enabled_Components.COMMENT_NOTIFIER || !plot.isOwner(player.getUUID())) {
            return;
        }
        TaskManager.runTaskLaterAsync(() -> {
            Collection<CommentInbox> boxes = inboxes.values();
            final AtomicInteger count = new AtomicInteger(0);
            final AtomicInteger size = new AtomicInteger(boxes.size());
            for (final CommentInbox inbox : inboxes.values()) {
                inbox.getComments(plot, new RunnableVal<List<PlotComment>>(){

                    @Override
                    public void run(List<PlotComment> value) {
                        int total;
                        if (value != null) {
                            int num = 0;
                            for (PlotComment comment : value) {
                                if (comment.timestamp() <= CommentManager.getTimestamp(player, inbox.toString())) continue;
                                ++num;
                            }
                            total = count.addAndGet(num);
                        } else {
                            total = count.get();
                        }
                        if (size.decrementAndGet() == 0 && total > 0) {
                            player.sendTitle((Caption)StaticCaption.of(""), (Caption)TranslatableCaption.of("comment.inbox_notification"), TagResolver.builder().tag("amount", Tag.inserting((Component)Component.text((int)total))).tag("command", Tag.inserting((Component)Component.text((String)"/plot inbox"))).build());
                        }
                    }
                });
            }
        }, TaskTime.seconds(1L));
    }

    public static long getTimestamp(PlotPlayer<?> player, String inbox) {
        MetaDataKey<Long> inboxKey = MetaDataKey.of(String.format("inbox:%s", inbox), new TypeLiteral<Long>(){});
        try (MetaDataAccess<Long> inboxAccess = player.accessTemporaryMetaData(inboxKey);){
            long l = inboxAccess.get().orElse(player.getLastPlayed());
            return l;
        }
    }

    public static void addInbox(CommentInbox inbox) {
        inboxes.put(inbox.toString().toLowerCase(), inbox);
    }

    public static void registerDefaultInboxes() {
        CommentManager.addInbox(new InboxReport());
        CommentManager.addInbox(new InboxPublic());
        CommentManager.addInbox(new InboxOwner());
    }
}

