/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PlotWorld {
    private final String world;

    protected PlotWorld(@NonNull String world) {
        this.world = world;
    }

    public abstract @Nullable PlotArea getArea(@NonNull Location var1);

    public abstract @NonNull Collection<PlotArea> getAreas();

    public abstract @NonNull Collection<PlotArea> getAreasInRegion(@NonNull CuboidRegion var1);

    public void addArea(@NonNull PlotArea area) {
        throw new UnsupportedOperationException("This world type does not allow adding new areas");
    }

    public void removeArea(@NonNull PlotArea area) {
        throw new UnsupportedOperationException("This world type does not allow removing areas");
    }

    public String getWorld() {
        return this.world;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlotWorld plotWorld = (PlotWorld)o;
        return this.world.equals(plotWorld.world);
    }

    public int hashCode() {
        return this.world.hashCode();
    }
}

