/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.generator.SquarePlotWorld;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockTypes;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ClassicPlotWorld
extends SquarePlotWorld {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ClassicPlotWorld.class.getSimpleName()));
    public int ROAD_HEIGHT = 62;
    public int PLOT_HEIGHT = 62;
    public int WALL_HEIGHT = 62;
    public BlockBucket MAIN_BLOCK = new BlockBucket(BlockTypes.STONE);
    public BlockBucket TOP_BLOCK = new BlockBucket(BlockTypes.GRASS_BLOCK);
    public BlockBucket WALL_BLOCK = new BlockBucket(BlockTypes.STONE_SLAB);
    public BlockBucket CLAIMED_WALL_BLOCK = new BlockBucket(BlockTypes.SANDSTONE_SLAB);
    public BlockBucket WALL_FILLING = new BlockBucket(BlockTypes.STONE);
    public BlockBucket ROAD_BLOCK = new BlockBucket(BlockTypes.QUARTZ_BLOCK);
    public boolean PLOT_BEDROCK = true;
    public boolean PLACE_TOP_BLOCK = true;
    public boolean COMPONENT_BELOW_BEDROCK = false;

    public ClassicPlotWorld(@NonNull String worldName, @Nullable String id, @NonNull IndependentPlotGenerator generator, @Nullable PlotId min, @Nullable PlotId max, @WorldConfig @NonNull YamlConfiguration worldConfiguration, @NonNull GlobalBlockQueue blockQueue) {
        super(worldName, id, generator, min, max, worldConfiguration, blockQueue);
    }

    private static BlockBucket createCheckedBlockBucket(String input, BlockBucket def) {
        BlockBucket bucket = new BlockBucket(input);
        Pattern pattern = null;
        try {
            pattern = bucket.toPattern();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pattern == null) {
            LOGGER.error("Failed to parse pattern '{}', check your worlds.yml", (Object)input);
            LOGGER.error("Falling back to {}", (Object)def);
            return def;
        }
        return bucket;
    }

    @Override
    public @NonNull ConfigurationNode[] getSettingNodes() {
        return new ConfigurationNode[]{new ConfigurationNode("plot.height", this.PLOT_HEIGHT, TranslatableCaption.of("setup.plot_height"), ConfigurationUtil.INTEGER), new ConfigurationNode("plot.size", this.PLOT_WIDTH, TranslatableCaption.of("setup.plot_width"), ConfigurationUtil.INTEGER), new ConfigurationNode("plot.filling", this.MAIN_BLOCK, TranslatableCaption.of("setup.plot_block"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.place_top_block", this.PLACE_TOP_BLOCK, TranslatableCaption.of("setup.top_block_boolean"), ConfigurationUtil.BOOLEAN), new ConfigurationNode("plot.floor", this.TOP_BLOCK, TranslatableCaption.of("setup.plot_block_floor"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.block", this.WALL_BLOCK, TranslatableCaption.of("setup.top_wall_block"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.block_claimed", this.CLAIMED_WALL_BLOCK, TranslatableCaption.of("setup.wall_block_claimed"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("road.width", this.ROAD_WIDTH, TranslatableCaption.of("setup.road_width"), ConfigurationUtil.INTEGER), new ConfigurationNode("road.height", this.ROAD_HEIGHT, TranslatableCaption.of("setup.road_height"), ConfigurationUtil.INTEGER), new ConfigurationNode("road.block", this.ROAD_BLOCK, TranslatableCaption.of("setup.road_block"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.filling", this.WALL_FILLING, TranslatableCaption.of("setup.wall_filling_block"), ConfigurationUtil.BLOCK_BUCKET), new ConfigurationNode("wall.height", this.WALL_HEIGHT, TranslatableCaption.of("setup.wall_height"), ConfigurationUtil.INTEGER), new ConfigurationNode("plot.bedrock", this.PLOT_BEDROCK, TranslatableCaption.of("setup.bedrock_boolean"), ConfigurationUtil.BOOLEAN), new ConfigurationNode("world.component_below_bedrock", this.COMPONENT_BELOW_BEDROCK, TranslatableCaption.of("setup.component_below_bedrock_boolean"), ConfigurationUtil.BOOLEAN)};
    }

    @Override
    public void loadConfiguration(ConfigurationSection config) {
        super.loadConfiguration(config);
        this.PLOT_BEDROCK = config.getBoolean("plot.bedrock");
        this.PLOT_HEIGHT = Math.min(this.getMaxGenHeight(), config.getInt("plot.height"));
        this.MAIN_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(config.getString("plot.filling"), this.MAIN_BLOCK);
        this.TOP_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(config.getString("plot.floor"), this.TOP_BLOCK);
        this.WALL_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(config.getString("wall.block"), this.WALL_BLOCK);
        this.ROAD_HEIGHT = Math.min(this.getMaxGenHeight(), config.getInt("road.height"));
        this.ROAD_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(config.getString("road.block"), this.ROAD_BLOCK);
        this.WALL_FILLING = ClassicPlotWorld.createCheckedBlockBucket(config.getString("wall.filling"), this.WALL_FILLING);
        this.PLACE_TOP_BLOCK = config.getBoolean("wall.place_top_block");
        this.WALL_HEIGHT = Math.min(this.getMaxGenHeight() - (this.PLACE_TOP_BLOCK ? 1 : 0), config.getInt("wall.height"));
        this.CLAIMED_WALL_BLOCK = ClassicPlotWorld.createCheckedBlockBucket(config.getString("wall.block_claimed"), this.CLAIMED_WALL_BLOCK);
        this.COMPONENT_BELOW_BEDROCK = config.getBoolean("world.component_below_bedrock");
    }

    @Override
    public int getMinComponentHeight() {
        return this.COMPONENT_BELOW_BEDROCK && this.getMinGenHeight() >= this.getMinBuildHeight() ? this.getMinGenHeight() + (this.PLOT_BEDROCK ? 1 : 0) : this.getMinBuildHeight();
    }

    int schematicStartHeight() {
        int plotRoadMin = Math.min(this.PLOT_HEIGHT, this.ROAD_HEIGHT);
        if (!Settings.Schematics.USE_WALL_IN_ROAD_SCHEM_HEIGHT) {
            return plotRoadMin;
        }
        return Math.min(this.WALL_HEIGHT, plotRoadMin);
    }
}

