/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.AreaBoundDelegateQueueCoordinator;
import com.plotsquared.core.queue.LocationOffsetDelegateQueueCoordinator;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.RegionUtil;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AugmentedUtils {
    private static boolean enabled = true;

    public static void bypass(boolean bypass, Runnable run) {
        enabled = bypass;
        run.run();
        enabled = true;
    }

    public static boolean generateChunk(@NonNull String world, int chunkX, int chunkZ, @Nullable QueueCoordinator queue) {
        if (!enabled) {
            return false;
        }
        int blockX = chunkX << 4;
        int blockZ = chunkZ << 4;
        CuboidRegion region = RegionUtil.createRegion(blockX, blockX + 15, 0, 0, blockZ, blockZ + 15);
        Set<PlotArea> areas = PlotSquared.get().getPlotAreaManager().getPlotAreasSet(world, region);
        if (areas.isEmpty()) {
            return false;
        }
        boolean enqueue = false;
        boolean generationResult = false;
        for (PlotArea area : areas) {
            QueueCoordinator secondaryMask;
            int startYOffset;
            QueueCoordinator primaryMask;
            int relativeTopZ;
            int relativeTopX;
            if (area.getType() == PlotAreaType.NORMAL) {
                return false;
            }
            if (area.getTerrain() == PlotAreaTerrainType.ALL || !area.contains(blockX, blockZ)) continue;
            IndependentPlotGenerator generator = area.getGenerator();
            if (queue == null) {
                enqueue = true;
                queue = PlotSquared.platform().globalBlockQueue().getNewQueue(PlotSquared.platform().worldUtil().getWeWorld(world));
            }
            if (area.getType() == PlotAreaType.PARTIAL) {
                relativeBottomX = Math.max(0, area.getRegion().getMinimumPoint().getX() - blockX);
                relativeBottomZ = Math.max(0, area.getRegion().getMinimumPoint().getZ() - blockZ);
                relativeTopX = Math.min(15, area.getRegion().getMaximumPoint().getX() - blockX);
                relativeTopZ = Math.min(15, area.getRegion().getMaximumPoint().getZ() - blockZ);
                primaryMask = new AreaBoundDelegateQueueCoordinator(area, queue);
            } else {
                relativeBottomZ = 0;
                relativeBottomX = 0;
                relativeTopZ = 15;
                relativeTopX = 15;
                primaryMask = queue;
            }
            BlockState air = BlockTypes.AIR.getDefaultState();
            int n = startYOffset = !(area instanceof ClassicPlotWorld) || ((ClassicPlotWorld)area).PLOT_BEDROCK ? 1 : 0;
            if (area.getTerrain() == PlotAreaTerrainType.ROAD) {
                PlotManager manager = area.getPlotManager();
                boolean[][] canPlace = new boolean[16][16];
                boolean has = false;
                for (int x = relativeBottomX; x <= relativeTopX; ++x) {
                    for (int z = relativeBottomZ; z <= relativeTopZ; ++z) {
                        boolean can;
                        int worldX = x + blockX;
                        int worldZ = z + blockZ;
                        boolean bl = can = manager.getPlotId(worldX, 0, worldZ) == null;
                        if (!can) continue;
                        for (int y = area.getMinGenHeight() + startYOffset; y <= area.getMaxGenHeight(); ++y) {
                            queue.setBlock(worldX, y, worldZ, air);
                        }
                        canPlace[x][z] = true;
                        has = true;
                    }
                }
                if (!has) continue;
                generationResult = true;
                secondaryMask = new LocationOffsetDelegateQueueCoordinator(canPlace, blockX, blockZ, primaryMask);
            } else {
                secondaryMask = primaryMask;
                for (int x = relativeBottomX; x <= relativeTopX; ++x) {
                    for (int z = relativeBottomZ; z <= relativeTopZ; ++z) {
                        for (int y = area.getMinGenHeight() + startYOffset; y <= area.getMaxGenHeight(); ++y) {
                            queue.setBlock(blockX + x, y, blockZ + z, air);
                        }
                    }
                }
                generationResult = true;
            }
            ZeroedDelegateScopedQueueCoordinator scoped = new ZeroedDelegateScopedQueueCoordinator(secondaryMask, Location.at(world, blockX, area.getMinGenHeight(), blockZ), Location.at(world, blockX + 15, area.getMaxGenHeight(), blockZ + 15));
            generator.generateChunk(scoped, area, true);
            generator.populateChunk(scoped, area);
        }
        if (enqueue) {
            queue.enqueue();
        }
        return generationResult;
    }
}

