/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.database;

import com.plotsquared.core.configuration.Storage;
import com.plotsquared.core.database.Database;
import com.plotsquared.core.util.StringMan;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MySQL
extends Database {
    private final String user;
    private final String database;
    private final String password;
    private final String port;
    private final String hostname;
    private Connection connection;

    public MySQL(String hostname, String port, String database, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.user = username;
        this.password = password;
        this.connection = null;
    }

    @Override
    public Connection forceConnection() throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database + "?" + StringMan.join(Storage.MySQL.PROPERTIES, "&"), this.user, this.password);
        return this.connection;
    }

    @Override
    public Connection openConnection() throws SQLException {
        if (this.checkConnection()) {
            return this.connection;
        }
        return this.forceConnection();
    }

    @Override
    public boolean checkConnection() throws SQLException {
        return this.connection != null && !this.connection.isClosed();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean closeConnection() throws SQLException {
        if (this.connection == null) {
            return false;
        }
        this.connection.close();
        this.connection = null;
        return true;
    }

    @Override
    public ResultSet querySQL(String query) throws SQLException {
        if (this.checkConnection()) {
            this.openConnection();
        }
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(query);
            return resultSet;
        }
    }

    @Override
    public int updateSQL(String query) throws SQLException {
        if (this.checkConnection()) {
            this.openConnection();
        }
        try (Statement statement = this.connection.createStatement();){
            int n = statement.executeUpdate(query);
            return n;
        }
    }
}

