/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="schematic", permission="plots.schematic", aliases={"schem"}, category=CommandCategory.SCHEMATIC, usage="/plot schematic <save | saveall | paste | list>")
public class SchematicCmd
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final SchematicHandler schematicHandler;
    private boolean running = false;

    @Inject
    public SchematicCmd(@NonNull PlotAreaManager plotAreaManager, @NonNull SchematicHandler schematicHandler) {
        this.plotAreaManager = plotAreaManager;
        this.schematicHandler = schematicHandler;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        String arg;
        if (args.length < 1) {
            player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Possible values: save, paste, exportall, list")))});
            return true;
        }
        switch (arg = args[0].toLowerCase()) {
            case "paste": {
                if (!player.hasPermission(Permission.PERMISSION_SCHEMATIC_PASTE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_SCHEMATIC_PASTE))});
                    return false;
                }
                if (args.length < 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Possible values: save, paste, exportall, list")))});
                    break;
                }
                Location loc = player.getLocation();
                Plot plot = loc.getPlotAbs();
                if (plot == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                    return false;
                }
                if (!plot.hasOwner()) {
                    player.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
                    return false;
                }
                if (!plot.isOwner(player.getUUID()) && !player.hasPermission("plots.admin.command.schematic.paste")) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
                    return false;
                }
                if (plot.getVolume() > 2.147483647E9) {
                    player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
                    return false;
                }
                if (this.running) {
                    player.sendMessage((Caption)TranslatableCaption.of("error.task_in_process"), new TagResolver[0]);
                    return false;
                }
                String location = args[1];
                this.running = true;
                TaskManager.runTaskAsync(() -> {
                    Schematic schematic = null;
                    if (location.startsWith("url:")) {
                        try {
                            UUID uuid = UUID.fromString(location.substring(4));
                            URL url = URI.create(Settings.Web.URL + "uploads/" + uuid + ".schematic").toURL();
                            schematic = this.schematicHandler.getSchematic(url);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid"), new TagResolver[]{TagResolver.resolver((String)"reason", (Tag)Tag.inserting((Component)Component.text((String)("non-existent url: " + location))))});
                            this.running = false;
                            return;
                        }
                    }
                    try {
                        schematic = this.schematicHandler.getSchematic(location);
                    }
                    catch (SchematicHandler.UnsupportedFormatException e) {
                        e.printStackTrace();
                    }
                    if (schematic == null) {
                        this.running = false;
                        player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid"), new TagResolver[]{TagResolver.resolver((String)"reason", (Tag)Tag.inserting((Component)Component.text((String)"non-existent or not in gzip format")))});
                        return;
                    }
                    this.schematicHandler.paste(schematic, plot, 0, plot.getArea().getMinBuildHeight(), 0, false, player, new RunnableVal<Boolean>(){

                        @Override
                        public void run(Boolean value) {
                            SchematicCmd.this.running = false;
                            if (value.booleanValue()) {
                                player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_success"), new TagResolver[0]);
                            } else {
                                player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_failed"), new TagResolver[0]);
                            }
                        }
                    });
                });
                break;
            }
            case "saveall": 
            case "exportall": {
                if (!(player instanceof ConsolePlayer)) {
                    player.sendMessage((Caption)TranslatableCaption.of("console.not_console"), new TagResolver[0]);
                    return false;
                }
                if (args.length != 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_world_args"), new TagResolver[0]);
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Use /plot schematic exportall <area>")))});
                    return false;
                }
                PlotArea area = this.plotAreaManager.getPlotAreaByString(args[1]);
                if (area == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                    return false;
                }
                Collection<Plot> plots = area.getPlots();
                if (plots.isEmpty()) {
                    player.sendMessage((Caption)TranslatableCaption.of("schematic.schematic_exportall_world"), new TagResolver[0]);
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Use /plot sch exportall <area>")))});
                    return false;
                }
                boolean result = this.schematicHandler.exportAll(plots, null, null, () -> player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_finished"), new TagResolver[0]));
                if (!result) {
                    player.sendMessage((Caption)TranslatableCaption.of("error.task_in_process"), new TagResolver[0]);
                    return false;
                }
                player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_started"), new TagResolver[0]);
                player.sendMessage((Caption)TranslatableCaption.of("schematics.plot_to_schem"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)plots.size())))});
                break;
            }
            case "export": 
            case "save": {
                if (!player.hasPermission(Permission.PERMISSION_SCHEMATIC_SAVE)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_SCHEMATIC_SAVE))});
                    return false;
                }
                if (this.running) {
                    player.sendMessage((Caption)TranslatableCaption.of("error.task_in_process"), new TagResolver[0]);
                    return false;
                }
                Location location = player.getLocation();
                Plot plot = location.getPlotAbs();
                if (plot == null) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                    return false;
                }
                if (!plot.hasOwner()) {
                    player.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
                    return false;
                }
                if (plot.getVolume() > 2.147483647E9) {
                    player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
                    return false;
                }
                if (!plot.isOwner(player.getUUID()) && !player.hasPermission("plots.admin.command.schematic.save")) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
                    return false;
                }
                ArrayList plots = Lists.newArrayList((Object[])new Plot[]{plot});
                boolean result = this.schematicHandler.exportAll(plots, null, null, () -> {
                    player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_single_finished"), new TagResolver[0]);
                    this.running = false;
                });
                if (!result) {
                    player.sendMessage((Caption)TranslatableCaption.of("error.task_in_process"), new TagResolver[0]);
                    return false;
                }
                player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_started"), new TagResolver[0]);
                break;
            }
            case "list": {
                if (!player.hasPermission(Permission.PERMISSION_SCHEMATIC_LIST)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_SCHEMATIC_LIST))});
                    return false;
                }
                String string = StringMan.join(this.schematicHandler.getSchematicNames(), "$2, $1");
                player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_list"), new TagResolver[]{TagResolver.resolver((String)"list", (Tag)Tag.inserting((Component)Component.text((String)string)))});
                break;
            }
            default: {
                player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Possible values: save, paste, exportall, list")))});
            }
        }
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (player.hasPermission(Permission.PERMISSION_SCHEMATIC_SAVE)) {
                completions.add("save");
            }
            if (player.hasPermission(Permission.PERMISSION_SCHEMATIC_LIST)) {
                completions.add("list");
            }
            if (player.hasPermission(Permission.PERMISSION_SCHEMATIC_PASTE)) {
                completions.add("paste");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (player.hasPermission(Permission.PERMISSION_SCHEMATIC) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

