/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionHolder;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.StringComparison;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Command {
    static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final ArrayList<Command> allCommands = new ArrayList();
    private final ArrayList<Command> dynamicCommands = new ArrayList();
    private final HashMap<String, Command> staticCommands = new HashMap();
    private final Command parent;
    private final boolean isStatic;
    private String id;
    private List<String> aliases;
    private RequiredType required;
    private String usage;
    private Caption description;
    private String permission;
    private boolean confirmation;
    private CommandCategory category;
    private Argument<?>[] arguments;

    public Command(Command parent, boolean isStatic, String id, String permission, RequiredType required, CommandCategory category) {
        this.parent = parent;
        this.isStatic = isStatic;
        this.id = id;
        this.permission = permission;
        this.required = required;
        this.category = category;
        this.aliases = Collections.singletonList(id);
        if (this.parent != null) {
            this.parent.register(this);
        }
    }

    public Command(Command parent, boolean isStatic) {
        this.parent = parent;
        this.isStatic = isStatic;
        CommandDeclaration cdAnnotation = this.getClass().getAnnotation(CommandDeclaration.class);
        if (cdAnnotation != null) {
            this.init(cdAnnotation);
        }
        for (final Method method : this.getClass().getDeclaredMethods()) {
            Class<?>[] types;
            if (!method.isAnnotationPresent(CommandDeclaration.class) || (types = method.getParameterTypes()).length != 5 || types[0] != Command.class || types[1] != PlotPlayer.class || types[2] != String[].class || types[3] != RunnableVal3.class || types[4] != RunnableVal2.class) continue;
            Command tmp = new Command(this, true){

                @Override
                public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, CommandResult> whenDone) {
                    try {
                        method.invoke((Object)Command.this, this, player, args, confirm, whenDone);
                        return CompletableFuture.completedFuture(true);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                        return CompletableFuture.completedFuture(false);
                    }
                }
            };
            tmp.init(method.getAnnotation(CommandDeclaration.class));
        }
    }

    public Command getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    public String getFullId() {
        if (this.parent != null && this.parent.getParent() != null) {
            return this.parent.getFullId() + "." + this.id;
        }
        return this.id;
    }

    public List<Command> getCommands(PlotPlayer<?> player) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Command cmd : this.allCommands) {
            if (!cmd.canExecute(player, false)) continue;
            commands.add(cmd);
        }
        return commands;
    }

    public List<Command> getCommands(CommandCategory category, PlotPlayer<?> player) {
        List<Command> commands = this.getCommands(player);
        if (category != null) {
            commands.removeIf(command -> command.category != category);
        }
        return commands;
    }

    public List<Command> getCommands() {
        return this.allCommands;
    }

    public boolean hasConfirmation(PermissionHolder player) {
        return this.confirmation && !player.hasPermission(this.getPermission() + ".confirm.bypass");
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public Caption getDescription() {
        return this.description;
    }

    public RequiredType getRequiredType() {
        return this.required;
    }

    public Argument<?>[] getRequiredArguments() {
        return this.arguments;
    }

    public void setRequiredArguments(Argument<?>[] arguments) {
        this.arguments = arguments;
    }

    public void init(CommandDeclaration declaration) {
        this.id = declaration.command();
        this.permission = declaration.permission();
        this.required = declaration.requiredType();
        this.category = declaration.category();
        ArrayList<String> aliasOptions = new ArrayList<String>();
        aliasOptions.add(this.id);
        aliasOptions.addAll(Arrays.asList(declaration.aliases()));
        this.aliases = aliasOptions;
        if (declaration.description().isEmpty()) {
            ArrayList<String> path = new ArrayList<String>();
            path.add(this.id);
            for (Command parent = this.getParent(); parent != null && !parent.equals(MainCommand.getInstance()); parent = parent.getParent()) {
                path.add(parent.getId());
            }
            Collections.reverse(path);
            String descriptionKey = String.join((CharSequence)".", path);
            this.description = TranslatableCaption.of(String.format("commands.description.%s", descriptionKey));
        } else {
            this.description = StaticCaption.of(declaration.description());
        }
        this.usage = declaration.usage();
        this.confirmation = declaration.confirmation();
        if (this.parent != null) {
            this.parent.register(this);
        }
    }

    public void register(Command command) {
        if (command.isStatic) {
            for (String alias : command.aliases) {
                this.staticCommands.put(alias.toLowerCase(), command);
            }
        } else {
            this.dynamicCommands.add(command);
        }
        this.allCommands.add(command);
    }

    public String getPermission() {
        if (this.permission != null && !this.permission.isEmpty()) {
            return this.permission;
        }
        if (this.parent == null) {
            return "plots.use";
        }
        return "plots." + this.getFullId();
    }

    public <T> void paginate(PlotPlayer<?> player, List<T> c, int size, int page, RunnableVal3<Integer, T, CaptionHolder> add, String baseCommand, Caption header) {
        int max;
        int totalPages;
        if (page < 0) {
            page = 0;
        }
        if (page > (totalPages = (int)Math.floor((double)c.size() / (double)size))) {
            page = totalPages;
        }
        if ((max = page * size + size) > c.size()) {
            max = c.size();
        }
        player.sendMessage(header, TagResolver.builder().tag("cur", Tag.inserting((Component)Component.text((int)(page + 1)))).tag("max", Tag.inserting((Component)Component.text((int)(totalPages + 1)))).tag("amount", Tag.inserting((Component)Component.text((int)c.size()))).build());
        List<T> subList = c.subList(page * size, max);
        int i = page * size;
        for (T obj : subList) {
            CaptionHolder msg = new CaptionHolder();
            add.run(++i, (Integer)obj, msg);
            player.sendMessage(msg.get(), msg.getTagResolvers());
        }
        player.sendMessage((Caption)TranslatableCaption.of("list.page_turn"), TagResolver.builder().tag("cur", Tag.inserting((Component)Component.text((int)(page + 1)))).tag("command1", (Tag)Tag.preProcessParsed((String)(baseCommand + " " + page))).tag("command2", (Tag)Tag.preProcessParsed((String)(baseCommand + " " + (page + 2)))).tag("clickable", Tag.inserting((Component)TranslatableCaption.of("list.clickable").toComponent(player))).build());
    }

    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, CommandResult> whenDone) throws CommandException {
        if (args.length == 0 || args[0] == null) {
            if (this.parent == null) {
                MainCommand.getInstance().help.displayHelp(player, null, 0);
            } else {
                this.sendUsage(player);
            }
            return CompletableFuture.completedFuture(false);
        }
        if (this.allCommands.isEmpty()) {
            player.sendMessage((Caption)StaticCaption.of("Not Implemented: https://github.com/IntellectualSites/PlotSquared/issues"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        Command cmd = this.getCommand(args[0]);
        if (cmd == null) {
            if (this.parent != null) {
                this.sendUsage(player);
                return CompletableFuture.completedFuture(false);
            }
            try {
                if (!MathMan.isInteger(args[0])) {
                    CommandCategory.valueOf(args[0].toUpperCase());
                }
                MainCommand.getInstance().help.execute(player, args, null, null);
                return CompletableFuture.completedFuture(false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                player.sendMessage((Caption)TranslatableCaption.of("commandconfig.not_valid_subcommand"), new TagResolver[0]);
                List<Command> commands = this.getCommands(player);
                if (commands.isEmpty()) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.did_you_mean"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)MainCommand.getInstance().help.getUsage())))});
                    return CompletableFuture.completedFuture(false);
                }
                HashSet<String> setArgs = new HashSet<String>(args.length);
                for (String arg : args) {
                    setArgs.add(arg.toLowerCase());
                }
                String[] allArgs = setArgs.toArray(new String[0]);
                int best = 0;
                for (Command current : commands) {
                    int match = this.getMatch(allArgs, current, player);
                    if (match <= best) continue;
                    cmd = current;
                }
                if (cmd == null) {
                    cmd = new StringComparison<Command>(args[0], this.allCommands).getMatchObject();
                }
                player.sendMessage((Caption)TranslatableCaption.of("commandconfig.did_you_mean"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)cmd.getUsage())))});
                return CompletableFuture.completedFuture(false);
            }
        }
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        if (!cmd.checkArgs(player, newArgs) || !cmd.canExecute(player, true)) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            cmd.execute(player, newArgs, confirm, whenDone);
        }
        catch (CommandException e) {
            e.perform(player);
        }
        return CompletableFuture.completedFuture(true);
    }

    public boolean checkArgs(PlotPlayer<?> player, String[] args) {
        Argument<?>[] reqArgs = this.getRequiredArguments();
        if (reqArgs != null && reqArgs.length > 0) {
            boolean failed = args.length < reqArgs.length;
            String[] baseSplit = this.getCommandString().split(" ");
            Object[] fullSplit = this.getUsage().split(" ");
            if (fullSplit.length - baseSplit.length < reqArgs.length) {
                String[] tmp = new String[baseSplit.length + reqArgs.length];
                System.arraycopy(fullSplit, 0, tmp, 0, fullSplit.length);
                fullSplit = tmp;
            }
            for (int i = 0; i < reqArgs.length; ++i) {
                fullSplit[i + baseSplit.length] = reqArgs[i].getExample().toString();
                failed = failed || reqArgs[i].parse(args[i]) == null;
            }
            if (failed) {
                player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)StringMan.join(fullSplit, " "))))});
                return false;
            }
        }
        return true;
    }

    public int getMatch(String[] args, Command cmd, PlotPlayer<?> player) {
        String perm = cmd.getPermission();
        int count = cmd.getAliases().stream().filter(alias -> alias.startsWith(args[0])).mapToInt(alias -> 5).sum();
        HashSet<String> desc = new HashSet<String>();
        Collections.addAll(desc, cmd.getDescription().getComponent(player).split(" "));
        for (String arg : args) {
            if (perm.startsWith(arg)) {
                ++count;
            }
            if (!desc.contains(arg)) continue;
            ++count;
        }
        String[] usage = cmd.getUsage().split(" ");
        for (int i = 0; i < Math.min(4, usage.length); ++i) {
            String[] split;
            int require = usage[i].startsWith("<") ? 1 : 0;
            for (String aSplit : split = usage[i].split("\\|| |\\>|\\<|\\[|\\]|\\{|\\}|\\_|\\/")) {
                for (String arg : args) {
                    if (!arg.equalsIgnoreCase(aSplit)) continue;
                    count += 5 - i + require;
                }
            }
        }
        return count += StringMan.intersection(desc, args);
    }

    public Command getCommand(String arg) {
        Command cmd = this.staticCommands.get(arg.toLowerCase());
        if (cmd == null) {
            for (Command command : this.dynamicCommands) {
                if (!command.matches(arg)) continue;
                return command;
            }
        }
        return cmd;
    }

    public Command getCommand(Class<?> clazz) {
        for (Command cmd : this.allCommands) {
            if (cmd.getClass() != clazz) continue;
            return cmd;
        }
        return null;
    }

    public Command getCommandById(String id) {
        Command exact = this.staticCommands.get(id);
        if (exact != null) {
            return exact;
        }
        for (Command cmd : this.allCommands) {
            if (!cmd.getId().equals(id)) continue;
            return cmd;
        }
        return null;
    }

    public boolean canExecute(PlotPlayer<?> player, boolean message) {
        if (player == null) {
            return true;
        }
        if (!this.required.allows(player)) {
            if (message) {
                player.sendMessage(this.required.getErrorMessage(), new TagResolver[0]);
            }
        } else if (!player.hasPermission(this.getPermission())) {
            if (message) {
                player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)this.getPermission())))});
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean matches(String arg) {
        return StringMan.isEqual(arg = arg.toLowerCase(), this.id) || this.aliases.contains(arg);
    }

    public String getCommandString() {
        if (this.parent == null) {
            return "/" + this.toString();
        }
        return this.parent.getCommandString() + " " + this.toString();
    }

    public void sendUsage(PlotPlayer<?> player) {
        player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)this.getUsage())))});
    }

    public String getUsage() {
        if (this.usage != null && !this.usage.isEmpty()) {
            if (this.usage.startsWith("/")) {
                return this.usage;
            }
            return this.getCommandString() + " " + this.usage;
        }
        if (this.allCommands.isEmpty()) {
            return this.getCommandString();
        }
        StringBuilder args = new StringBuilder("[");
        String prefix = "";
        for (Command cmd : this.allCommands) {
            args.append(prefix).append((String)(cmd.isStatic ? cmd.toString() : "<" + cmd + ">"));
            prefix = "|";
        }
        return this.getCommandString() + " " + args + "]";
    }

    public Collection<Command> tabOf(PlotPlayer<?> player, String[] input, boolean space, String ... args) {
        if (!space) {
            return null;
        }
        ArrayList<Command> result = new ArrayList<Command>();
        int index = input.length;
        for (String arg : args) {
            String[] split = (arg = arg.replace(this.getCommandString() + " ", "")).split(" ");
            if (split.length <= index) continue;
            arg = StringMan.join(Arrays.copyOfRange(split, index, split.length), " ");
            Command cmd = new Command(null, false, arg, this.getPermission(), this.getRequiredType(), null){};
            result.add(cmd);
        }
        return result;
    }

    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        switch (args.length) {
            case 0: {
                return this.allCommands;
            }
            case 1: {
                String arg = args[0].toLowerCase();
                if (space) {
                    Command cmd = this.getCommand(arg);
                    if (cmd != null && cmd.canExecute(player, false)) {
                        return cmd.tab(player, Arrays.copyOfRange(args, 1, args.length), space);
                    }
                    return null;
                }
                HashSet<Command> commands = new HashSet<Command>();
                for (Map.Entry<String, Command> entry : this.staticCommands.entrySet()) {
                    if (!entry.getKey().startsWith(arg) || !entry.getValue().canExecute(player, false)) continue;
                    commands.add(entry.getValue());
                }
                return commands;
            }
        }
        Command cmd = this.getCommand(args[0]);
        if (cmd != null) {
            return cmd.tab(player, Arrays.copyOfRange(args, 1, args.length), space);
        }
        return null;
    }

    public String toString() {
        return !this.aliases.isEmpty() ? this.aliases.get(0) : this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Command other = (Command)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        return this.getFullId().equals(other.getFullId());
    }

    public int hashCode() {
        return this.getFullId().hashCode();
    }

    public void checkTrue(boolean mustBeTrue, Caption message, TagResolver ... args) {
        if (!mustBeTrue) {
            throw new CommandException(message, args);
        }
    }

    public <T> T check(T object, Caption message, TagResolver ... args) {
        if (object == null) {
            throw new CommandException(message, args);
        }
        return object;
    }

    public static class CommandException
    extends RuntimeException {
        private final Caption message;
        private final TagResolver[] args;

        public CommandException(@Nullable Caption message, TagResolver ... args) {
            this.message = message;
            this.args = args;
        }

        public void perform(@Nullable PlotPlayer<?> player) {
            if (player != null && this.message != null) {
                player.sendMessage(this.message, this.args);
            }
        }
    }

    public static enum CommandResult {
        FAILURE,
        SUCCESS;

    }
}

