/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.helpmenu;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.ComponentHelper;
import com.plotsquared.core.util.helpmenu.HelpObject;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public class HelpPage {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final List<HelpObject> helpObjects = new ArrayList<HelpObject>();
    private final TagResolver pageHeaderResolver;

    public HelpPage(CommandCategory category, int currentPage, int maxPages) {
        this.pageHeaderResolver = TagResolver.builder().tag("category", Tag.inserting((Component)Component.text((String)(category == null ? "ALL" : category.name())))).tag("current", Tag.inserting((Component)Component.text((int)(currentPage + 1)))).tag("max", Tag.inserting((Component)Component.text((int)(maxPages + 1)))).build();
    }

    public void render(PlotPlayer<?> player) {
        if (this.helpObjects.size() < 1) {
            player.sendMessage((Caption)TranslatableCaption.of("help.no_permission"), new TagResolver[0]);
        } else {
            TagResolver contentResolver = TagResolver.builder().tag("header", Tag.inserting((Component)TranslatableCaption.of("help.help_header").toComponent(player))).tag("page_header", Tag.inserting((Component)MINI_MESSAGE.deserialize(TranslatableCaption.of("help.help_page_header").getComponent(player), this.pageHeaderResolver))).tag("help_objects", Tag.inserting((ComponentLike)ComponentHelper.join(this.helpObjects, (Component)Component.text((String)"\n")))).tag("footer", Tag.inserting((Component)TranslatableCaption.of("help.help_footer").toComponent(player))).build();
            player.sendMessage((Caption)StaticCaption.of("<header>\n<page_header>\n<help_objects>\n<footer>"), contentResolver);
        }
    }

    public void addHelpItem(HelpObject object) {
        this.helpObjects.add(object);
    }
}

