/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.task.RunnableVal;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.entity.EntityType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class WorldUtil {
    public static void setBiome(String world, CuboidRegion region, BiomeType biome) {
        PlotSquared.platform().worldUtil().setBiomes(world, region, biome);
    }

    public abstract boolean isWorld(@NonNull String var1);

    @Deprecated
    public abstract @NonNull String[] getSignSynchronous(@NonNull Location var1);

    public abstract @NonNull Location getSpawn(@NonNull String var1);

    public abstract void setSpawn(@NonNull Location var1);

    public abstract void saveWorld(@NonNull String var1);

    public abstract  @NonNull StringComparison.ComparisonResult getClosestBlock(@NonNull String var1);

    public abstract void setSign(@NonNull Location var1, @NonNull Caption[] var2, TagResolver ... var3);

    public abstract void getBiome(@NonNull String var1, int var2, int var3, @NonNull Consumer<BiomeType> var4);

    @Deprecated
    public abstract @NonNull BiomeType getBiomeSynchronous(@NonNull String var1, int var2, int var3);

    public abstract void getBlock(@NonNull Location var1, @NonNull Consumer<BlockState> var2);

    @Deprecated
    public abstract @NonNull BlockState getBlockSynchronous(@NonNull Location var1);

    public abstract void getHighestBlock(@NonNull String var1, int var2, int var3, @NonNull IntConsumer var4);

    @Deprecated
    public abstract @NonNegative int getHighestBlockSynchronous(@NonNull String var1, int var2, int var3);

    public void setBiomes(@NonNull String worldName, @NonNull CuboidRegion region, @NonNull BiomeType biome) {
        World world = this.getWeWorld(worldName);
        region.forEach(bv -> world.setBiome(bv, biome));
    }

    public abstract @NonNull World getWeWorld(@NonNull String var1);

    public abstract void refreshChunk(int var1, int var2, String var3);

    @Deprecated(forRemoval=true, since="6.11.0")
    public void upload(final @NonNull Plot plot, @Nullable UUID uuid, @Nullable String file, @NonNull RunnableVal<URL> whenDone) {
        plot.getHome(home -> SchematicHandler.upload(uuid, file, "zip", new RunnableVal<OutputStream>(){

            @Override
            public void run(OutputStream output) {
                try (ZipOutputStream zos = new ZipOutputStream(output);){
                    File dat = WorldUtil.this.getDat(plot.getWorldName());
                    Location spawn = WorldUtil.this.getSpawn(plot.getWorldName());
                    if (dat != null) {
                        ZipEntry ze = new ZipEntry("world" + File.separator + dat.getName());
                        zos.putNextEntry(ze);
                        try (NBTInputStream nis = new NBTInputStream((InputStream)new GZIPInputStream(new FileInputStream(dat)));){
                            Map tag = ((CompoundTag)nis.readNamedTag().getTag()).getValue();
                            HashMap<String, Object> newMap = new HashMap<String, Object>();
                            for (Map.Entry entry : tag.entrySet()) {
                                if (!((String)entry.getKey()).equals("Data")) {
                                    newMap.put((String)entry.getKey(), (Tag)entry.getValue());
                                    continue;
                                }
                                HashMap<String, IntTag> data = new HashMap<String, IntTag>(((CompoundTag)entry.getValue()).getValue());
                                data.put("SpawnX", new IntTag(home.getX()));
                                data.put("SpawnY", new IntTag(home.getY()));
                                data.put("SpawnZ", new IntTag(home.getZ()));
                                newMap.put("Data", new CompoundTag(data));
                            }
                            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                                try (NBTOutputStream out = new NBTOutputStream((OutputStream)new GZIPOutputStream((OutputStream)baos, true));){
                                    out.writeNamedTag("Schematic????", (Tag)new CompoundTag(newMap));
                                }
                                zos.write(baos.toByteArray());
                            }
                        }
                    }
                    WorldUtil.this.setSpawn(spawn);
                    byte[] buffer = new byte[1024];
                    HashSet<BlockVector2> added = new HashSet<BlockVector2>();
                    for (Plot current : plot.getConnectedPlots()) {
                        Location bot = current.getBottomAbs();
                        Location top = current.getTopAbs();
                        int brx = bot.getX() >> 9;
                        int brz = bot.getZ() >> 9;
                        int trx = top.getX() >> 9;
                        int trz = top.getZ() >> 9;
                        Set<BlockVector2> files = WorldUtil.this.getChunkChunks(bot.getWorldName());
                        for (BlockVector2 mca : files) {
                            File file;
                            if (mca.getX() < brx || mca.getX() > trx || mca.getZ() < brz || mca.getZ() > trz || added.contains(mca) || (file = WorldUtil.this.getMcr(plot.getWorldName(), mca.getX(), mca.getZ())) == null) continue;
                            String name = file.getName();
                            ZipEntry ze = new ZipEntry("world" + File.separator + "region" + File.separator + name);
                            zos.putNextEntry(ze);
                            added.add(mca);
                            try (FileInputStream in = new FileInputStream(file);){
                                int len;
                                while ((len = in.read(buffer)) > 0) {
                                    zos.write(buffer, 0, len);
                                }
                            }
                            zos.closeEntry();
                        }
                    }
                    zos.closeEntry();
                    zos.flush();
                    zos.finish();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, whenDone));
    }

    final @Nullable File getDat(@NonNull String world) {
        File file = new File(PlotSquared.platform().worldContainer() + File.separator + world + File.separator + "level.dat");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private @Nullable File getMcr(@NonNull String world, int x, int z) {
        File file = new File(PlotSquared.platform().worldContainer(), world + File.separator + "region" + File.separator + "r." + x + "." + z + ".mca");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public Set<BlockVector2> getChunkChunks(String world) {
        File folder = new File(PlotSquared.platform().worldContainer(), world + File.separator + "region");
        File[] regionFiles = folder.listFiles();
        if (regionFiles == null) {
            throw new RuntimeException("Could not find worlds folder: " + folder + " ? (no read access?)");
        }
        HashSet<BlockVector2> chunks = new HashSet<BlockVector2>();
        for (File file : regionFiles) {
            String name = file.getName();
            if (!name.endsWith("mca")) continue;
            String[] split = name.split("\\.");
            try {
                int x = Integer.parseInt(split[1]);
                int z = Integer.parseInt(split[2]);
                BlockVector2 loc = BlockVector2.at((int)x, (int)z);
                chunks.add(loc);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return chunks;
    }

    public abstract boolean isBlockSame(@NonNull BlockState var1, @NonNull BlockState var2);

    public abstract @NonNegative double getHealth(@NonNull PlotPlayer<?> var1);

    public abstract void setHealth(@NonNull PlotPlayer<?> var1, @NonNegative double var2);

    public abstract @NonNegative int getFoodLevel(@NonNull PlotPlayer<?> var1);

    public abstract void setFoodLevel(@NonNull PlotPlayer<?> var1, @NonNegative int var2);

    public abstract @NonNull Set<EntityType> getTypesInCategory(@NonNull String var1);

    public abstract @NonNull Collection<BlockType> getTileEntityTypes();

    public abstract @NonNegative int getTileEntityCount(@NonNull String var1, @NonNull BlockVector2 var2);
}

