/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.PlotWeather;
import com.plotsquared.core.plot.flag.PlotFlag;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WeatherFlag
extends PlotFlag<PlotWeather, WeatherFlag> {
    public static final WeatherFlag PLOT_WEATHER_FLAG_RAIN = new WeatherFlag(PlotWeather.RAIN);
    public static final WeatherFlag PLOT_WEATHER_FLAG_CLEAR = new WeatherFlag(PlotWeather.CLEAR);
    public static final WeatherFlag PLOT_WEATHER_FLAG_WORLD = new WeatherFlag(PlotWeather.WORLD);
    public static final WeatherFlag PLOT_WEATHER_FLAG_OFF = new WeatherFlag(PlotWeather.OFF);

    protected WeatherFlag(@NonNull PlotWeather value) {
        super(value, TranslatableCaption.of("flags.flag_category_weather"), TranslatableCaption.of("flags.flag_description_weather"));
    }

    @Override
    public WeatherFlag parse(@NonNull String input) {
        return switch (input.toLowerCase()) {
            case "rain" -> this.flagOf(PlotWeather.RAIN);
            case "clear" -> this.flagOf(PlotWeather.CLEAR);
            case "reset" -> this.flagOf(PlotWeather.WORLD);
            default -> this.flagOf(PlotWeather.OFF);
        };
    }

    @Override
    public WeatherFlag merge(@NonNull PlotWeather newValue) {
        return this.flagOf(newValue);
    }

    @Override
    public String toString() {
        return ((PlotWeather)((Object)this.getValue())).toString();
    }

    @Override
    public String getExample() {
        return "rain";
    }

    @Override
    protected WeatherFlag flagOf(@NonNull PlotWeather value) {
        return switch (value) {
            case PlotWeather.RAIN -> PLOT_WEATHER_FLAG_RAIN;
            case PlotWeather.CLEAR -> PLOT_WEATHER_FLAG_CLEAR;
            case PlotWeather.WORLD -> PLOT_WEATHER_FLAG_WORLD;
            default -> PLOT_WEATHER_FLAG_OFF;
        };
    }

    @Override
    public Collection<String> getTabCompletions() {
        return Arrays.asList("clear", "rain");
    }
}

