/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.StringMan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ListFlag<V, F extends PlotFlag<List<V>, F>>
extends PlotFlag<List<V>, F> {
    public ListFlag(List<V> valueList, Caption category, Caption description) {
        super(Collections.unmodifiableList(valueList), category, description);
    }

    @Override
    public F merge(@NonNull List<V> newValue) {
        ArrayList mergedList = new ArrayList();
        for (Object v : (List)this.getValue()) {
            if (mergedList.contains(v)) continue;
            mergedList.add(v);
        }
        for (Object v : newValue) {
            if (mergedList.contains(v)) continue;
            mergedList.add(v);
        }
        return this.flagOf(mergedList);
    }

    @Override
    public String toString() {
        return StringMan.join((Collection)this.getValue(), ",");
    }
}

