/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.types.BlockTypeWrapper;
import com.plotsquared.core.plot.flag.types.ListFlag;
import com.plotsquared.core.util.BlockUtil;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class BlockTypeListFlag<F extends ListFlag<BlockTypeWrapper, F>>
extends ListFlag<BlockTypeWrapper, F> {
    public static boolean skipCategoryVerification = false;

    protected BlockTypeListFlag(List<BlockTypeWrapper> blockTypeList, Caption description) {
        super(blockTypeList, (Caption)TranslatableCaption.of("flags.flag_category_block_list"), description);
    }

    @Override
    public F parse(@NonNull String input) throws FlagParseException {
        ArrayList<BlockTypeWrapper> parsedBlocks = new ArrayList<BlockTypeWrapper>();
        String[] split = input.replaceAll("\\s+", "").split(",(?![^\\(\\[]*[\\]\\)])");
        if (split.length == 0) {
            return (F)((ListFlag)this.flagOf(parsedBlocks));
        }
        for (String blockString : split) {
            BlockState blockState = BlockUtil.get(blockString);
            BlockTypeWrapper blockTypeWrapper = blockState == null ? this.getCategory(blockString) : BlockTypeWrapper.get(blockState.getBlockType());
            if (parsedBlocks.contains(blockTypeWrapper)) continue;
            parsedBlocks.add(blockTypeWrapper);
        }
        return (F)((ListFlag)this.flagOf(parsedBlocks));
    }

    @Override
    public String getExample() {
        return "air,grass_block";
    }

    @Override
    public Collection<String> getTabCompletions() {
        ArrayList<String> tabCompletions = new ArrayList<String>();
        tabCompletions.addAll(BlockType.REGISTRY.keySet().stream().map(val -> val.replace("minecraft:", "")).collect(Collectors.toList()));
        tabCompletions.addAll(BlockCategory.REGISTRY.keySet().stream().map(val -> "#" + val.replace("minecraft:", "")).collect(Collectors.toList()));
        return tabCompletions;
    }

    private BlockTypeWrapper getCategory(String blockString) throws FlagParseException {
        BlockTypeWrapper blockTypeWrapper;
        if (!blockString.startsWith("#")) {
            throw new FlagParseException(this, blockString, TranslatableCaption.of("flags.flag_error_invalid_block"), new TagResolver[0]);
        }
        String categoryId = blockString.substring(1);
        if (skipCategoryVerification) {
            blockTypeWrapper = BlockTypeWrapper.get(categoryId);
        } else {
            BlockCategory blockCategory = (BlockCategory)BlockCategory.REGISTRY.get(categoryId);
            if (blockCategory == null) {
                throw new FlagParseException(this, blockString, TranslatableCaption.of("flags.flag_error_invalid_block"), new TagResolver[0]);
            }
            blockTypeWrapper = BlockTypeWrapper.get(blockCategory);
        }
        return blockTypeWrapper;
    }
}

