/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.player;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.collection.ByteArrayUtilities;
import com.plotsquared.core.command.CommandCaller;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionMap;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.NullPermissionProfile;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.permissions.PermissionProfile;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PersistentMetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.TemporaryMetaDataAccess;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotWeather;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.synchronization.LockRepository;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.item.ItemType;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PlotPlayer<P>
implements CommandCaller,
OfflinePlotPlayer,
LocaleHolder {
    private static final String NON_EXISTENT_CAPTION = "<red>PlotSquared does not recognize the caption: ";
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotPlayer.class.getSimpleName()));
    private static final Set<PlotPlayer<?>> debugModeEnabled = Collections.synchronizedSet(new HashSet());
    private static final Map<Class<?>, PlotPlayerConverter> converters = new HashMap();
    private final LockRepository lockRepository = new LockRepository();
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final PermissionHandler permissionHandler;
    private Map<String, byte[]> metaMap = new HashMap<String, byte[]>();
    private ConcurrentHashMap<String, Object> meta;
    private int hash;
    private Locale locale;
    private PermissionProfile permissionProfile;

    public PlotPlayer(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull PermissionHandler permissionHandler) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.permissionHandler = permissionHandler;
    }

    public static <T> PlotPlayer<T> from(@NonNull T object) {
        Class current;
        if (converters.containsKey(object.getClass())) {
            return converters.get(object.getClass()).convert(object);
        }
        ArrayDeque toVisit = new ArrayDeque();
        toVisit.add(object.getClass());
        while ((current = (Class)toVisit.poll()) != null) {
            PlotPlayerConverter converter = converters.get(current);
            if (converter != null) {
                if (current != object.getClass()) {
                    converters.put(object.getClass(), converter);
                    LOGGER.info("Registered {} as with converter for {}", object.getClass(), (Object)current);
                }
                return converter.convert(object);
            }
            if (current.getSuperclass() != null) {
                toVisit.add(current.getSuperclass());
            }
            toVisit.addAll(Arrays.asList(current.getInterfaces()));
        }
        throw new IllegalArgumentException(String.format("There is no registered PlotPlayer converter for type %s", object.getClass().getSimpleName()));
    }

    public static <T> void registerConverter(@NonNull Class<T> clazz, PlotPlayerConverter<T> converter) {
        converters.put(clazz, converter);
    }

    public static Collection<PlotPlayer<?>> getDebugModePlayers() {
        return Collections.unmodifiableCollection(debugModeEnabled);
    }

    public static Collection<PlotPlayer<?>> getDebugModePlayersInPlot(@NonNull Plot plot) {
        if (debugModeEnabled.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList players = new LinkedList();
        for (PlotPlayer<?> player : debugModeEnabled) {
            if (!player.getCurrentPlot().equals(plot)) continue;
            players.add(player);
        }
        return players;
    }

    protected void setupPermissionProfile() {
        this.permissionProfile = this.permissionHandler.getPermissionProfile(this).orElse(NullPermissionProfile.INSTANCE);
    }

    @Override
    public final boolean hasPermission(@Nullable String world, @NonNull String permission) {
        return this.permissionProfile.hasPermission(world, permission);
    }

    @Override
    public final boolean hasKeyedPermission(@Nullable String world, @NonNull String permission, @NonNull String key) {
        return this.permissionProfile.hasKeyedPermission(world, permission, key);
    }

    @Override
    public final boolean hasPermission(@NonNull String permission, boolean notify) {
        if (!this.hasPermission(permission)) {
            if (notify) {
                this.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)permission)))});
            }
            return false;
        }
        return true;
    }

    public abstract Actor toActor();

    public abstract P getPlatformPlayer();

    void setMeta(String key, Object value) {
        if (value == null) {
            this.deleteMeta(key);
        } else {
            if (this.meta == null) {
                this.meta = new ConcurrentHashMap();
            }
            this.meta.put(key, value);
        }
    }

    <T> T getMeta(String key) {
        if (this.meta != null) {
            return (T)this.meta.get(key);
        }
        return null;
    }

    <T> T getMeta(String key, T defaultValue) {
        T meta = this.getMeta(key);
        if (meta == null) {
            return defaultValue;
        }
        return meta;
    }

    public ConcurrentHashMap<String, Object> getMeta() {
        return this.meta;
    }

    Object deleteMeta(String key) {
        return this.meta == null ? null : this.meta.remove(key);
    }

    public String toString() {
        return this.getName();
    }

    public Plot getCurrentPlot() {
        try (MetaDataAccess<Plot> lastPlotAccess = this.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
            if (lastPlotAccess.get().orElse(null) == null && !Settings.Enabled_Components.EVENTS) {
                Plot plot = this.getLocation().getPlot();
                return plot;
            }
            Plot plot = lastPlotAccess.get().orElse(null);
            return plot;
        }
    }

    public int getAllowedPlots() {
        return this.hasPermissionRange("plots.plot", Settings.Limit.MAX_PLOTS);
    }

    public int getPlotCount() {
        if (!Settings.Limit.GLOBAL) {
            return this.getPlotCount(this.getLocation().getWorldName());
        }
        AtomicInteger count = new AtomicInteger(0);
        UUID uuid = this.getUUID();
        this.plotAreaManager.forEachPlotArea(value -> {
            if (!Settings.Done.COUNTS_TOWARDS_LIMIT) {
                for (Plot plot : value.getPlotsAbs(uuid)) {
                    if (DoneFlag.isDone(plot)) continue;
                    count.incrementAndGet();
                }
            } else {
                count.addAndGet(value.getPlotsAbs(uuid).size());
            }
        });
        return count.get();
    }

    public int getClusterCount() {
        if (!Settings.Limit.GLOBAL) {
            return this.getClusterCount(this.getLocation().getWorldName());
        }
        AtomicInteger count = new AtomicInteger(0);
        this.plotAreaManager.forEachPlotArea(value -> {
            for (PlotCluster cluster : value.getClusters()) {
                if (!cluster.isOwner(this.getUUID())) continue;
                count.incrementAndGet();
            }
        });
        return count.get();
    }

    public int getPlotCount(String world) {
        UUID uuid = this.getUUID();
        int count = 0;
        for (PlotArea area : this.plotAreaManager.getPlotAreasSet(world)) {
            if (!Settings.Done.COUNTS_TOWARDS_LIMIT) {
                count = (int)((long)count + area.getPlotsAbs(uuid).stream().filter(plot -> !DoneFlag.isDone(plot)).count());
                continue;
            }
            count += area.getPlotsAbs(uuid).size();
        }
        return count;
    }

    public int getClusterCount(String world) {
        int count = 0;
        for (PlotArea area : this.plotAreaManager.getPlotAreasSet(world)) {
            for (PlotCluster cluster : area.getClusters()) {
                if (!cluster.isOwner(this.getUUID())) continue;
                ++count;
            }
        }
        return count;
    }

    public Set<Plot> getPlots() {
        return PlotQuery.newQuery().ownedBy(this).asSet();
    }

    public @Nullable PlotArea getPlotAreaAbs() {
        return this.plotAreaManager.getPlotArea(this.getLocation());
    }

    public PlotArea getApplicablePlotArea() {
        return this.plotAreaManager.getApplicablePlotArea(this.getLocation());
    }

    @Override
    public @NonNull RequiredType getSuperCaller() {
        return RequiredType.PLAYER;
    }

    public @NonNull Location getLocation() {
        Location location = (Location)this.getMeta("location");
        if (location != null) {
            return location;
        }
        return this.getLocationFull();
    }

    public abstract Location getLocationFull();

    @Override
    public abstract @NonNull UUID getUUID();

    public boolean canTeleport(@NonNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"Specified location cannot be null");
        Location current = this.getLocationFull();
        this.teleport(location);
        boolean result = this.getLocation().equals(location);
        this.teleport(current);
        return result;
    }

    public void teleport(Location location) {
        this.teleport(location, TeleportCause.PLUGIN);
    }

    public abstract void teleport(Location var1, TeleportCause var2);

    public void plotkick(Location location) {
        this.setMeta("kick", true);
        this.teleport(location, TeleportCause.KICK);
        this.deleteMeta("kick");
    }

    public abstract void setCompassTarget(Location var1);

    public void setAttribute(String key) {
        this.setPersistentMeta("attrib_" + key, new byte[]{1});
    }

    public boolean getAttribute(String key) {
        if (!this.hasPersistentMeta("attrib_" + key)) {
            return false;
        }
        return this.getPersistentMeta("attrib_" + key)[0] == 1;
    }

    public void removeAttribute(String key) {
        this.removePersistentMeta("attrib_" + key);
    }

    public abstract void setWeather(@NonNull PlotWeather var1);

    public abstract @NonNull GameMode getGameMode();

    public abstract void setGameMode(@NonNull GameMode var1);

    public abstract void setTime(long var1);

    public abstract boolean getFlight();

    public abstract void setFlight(boolean var1);

    public abstract void playMusic(@NonNull Location var1, @NonNull ItemType var2);

    public abstract boolean isBanned();

    public abstract void kick(String var1);

    public void refreshDebug() {
        boolean debug = this.getAttribute("debug");
        if (debug && !debugModeEnabled.contains(this)) {
            debugModeEnabled.add(this);
        } else if (!debug) {
            debugModeEnabled.remove(this);
        }
    }

    public void unregister() {
        Plot plot = this.getCurrentPlot();
        if (plot != null && Settings.Enabled_Components.PERSISTENT_META && plot.getArea() instanceof SinglePlotArea) {
            PlotId id = plot.getId();
            int x = id.getX();
            int z = id.getY();
            ByteBuffer buffer = ByteBuffer.allocate(13);
            buffer.putShort((short)x);
            buffer.putShort((short)z);
            Location location = this.getLocation();
            buffer.putInt(location.getX());
            buffer.put((byte)location.getY());
            buffer.putInt(location.getZ());
            this.setPersistentMeta("quitLoc", buffer.array());
        } else if (this.hasPersistentMeta("quitLoc")) {
            this.removePersistentMeta("quitLoc");
        }
        if (plot != null) {
            this.eventDispatcher.callLeave(this, plot);
        }
        if (Settings.Enabled_Components.BAN_DELETER && this.isBanned()) {
            for (Plot owned : this.getPlots()) {
                owned.getPlotModificationManager().deletePlot(null, null);
                LOGGER.info("Plot {} was deleted + cleared due to {} getting banned", (Object)owned.getId(), (Object)this.getName());
            }
        }
        if (PlotSquared.platform().expireManager() != null) {
            PlotSquared.platform().expireManager().storeDate(this.getUUID(), System.currentTimeMillis());
        }
        PlotSquared.platform().playerManager().removePlayer(this);
        PlotSquared.platform().unregister(this);
        debugModeEnabled.remove(this);
    }

    public int getPlayerClusterCount(String world) {
        return PlotSquared.get().getClusters(world).stream().filter(cluster -> this.getUUID().equals(cluster.owner)).mapToInt(PlotCluster::getArea).sum();
    }

    public int getPlayerClusterCount() {
        AtomicInteger count = new AtomicInteger();
        this.plotAreaManager.forEachPlotArea(value -> count.addAndGet(value.getClusters().size()));
        return count.get();
    }

    public Set<Plot> getPlots(String world) {
        return PlotQuery.newQuery().inWorld(world).ownedBy(this.getUUID()).asSet();
    }

    public void populatePersistentMetaMap() {
        if (Settings.Enabled_Components.PERSISTENT_META) {
            DBFunc.getPersistentMeta(this.getUUID(), new RunnableVal<Map<String, byte[]>>(){

                @Override
                public void run(Map<String, byte[]> value) {
                    try {
                        PlotPlayer.this.metaMap = value;
                        if (value.isEmpty()) {
                            return;
                        }
                        if (PlotPlayer.this.getAttribute("debug")) {
                            debugModeEnabled.add(PlotPlayer.this);
                        }
                        if (!Settings.Teleport.ON_LOGIN) {
                            return;
                        }
                        PlotAreaManager manager = PlotPlayer.this.plotAreaManager;
                        if (!(manager instanceof SinglePlotAreaManager)) {
                            return;
                        }
                        SinglePlotArea area = ((SinglePlotAreaManager)manager).getArea();
                        byte[] arr = PlotPlayer.this.getPersistentMeta("quitLoc");
                        if (arr == null) {
                            return;
                        }
                        PlotPlayer.this.removePersistentMeta("quitLoc");
                        if (!PlotPlayer.this.getMeta("teleportOnLogin", true).booleanValue()) {
                            return;
                        }
                        ByteBuffer quitWorld = ByteBuffer.wrap(arr);
                        short plotX = quitWorld.getShort();
                        short plotZ = quitWorld.getShort();
                        PlotId id = PlotId.of(plotX, plotZ);
                        int x = quitWorld.getInt();
                        int y = quitWorld.get() & 0xFF;
                        int z = quitWorld.getInt();
                        Plot plot = area.getOwnedPlot(id);
                        if (plot == null) {
                            return;
                        }
                        Location location = Location.at(plot.getWorldName(), x, y, z);
                        if (plot.isLoaded()) {
                            TaskManager.runTask(() -> {
                                if (PlotPlayer.this.getMeta("teleportOnLogin", true).booleanValue()) {
                                    PlotPlayer.this.teleport(location, TeleportCause.LOGIN);
                                    PlotPlayer.this.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_plot"), new TagResolver[0]);
                                }
                            });
                        } else if (!PlotSquared.get().isMainThread(Thread.currentThread()) && PlotPlayer.this.getMeta("teleportOnLogin", true).booleanValue()) {
                            plot.teleportPlayer(PlotPlayer.this, result -> TaskManager.runTask(() -> {
                                if (PlotPlayer.this.getMeta("teleportOnLogin", true).booleanValue() && plot.isLoaded()) {
                                    PlotPlayer.this.teleport(location, TeleportCause.LOGIN);
                                    PlotPlayer.this.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_plot"), new TagResolver[0]);
                                }
                            }));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    byte[] getPersistentMeta(String key) {
        return this.metaMap.get(key);
    }

    Object removePersistentMeta(String key) {
        byte[] old = this.metaMap.remove(key);
        if (Settings.Enabled_Components.PERSISTENT_META) {
            DBFunc.removePersistentMeta(this.getUUID(), key);
        }
        return old;
    }

    public <T> @NonNull MetaDataAccess<T> accessPersistentMetaData(@NonNull MetaDataKey<T> key) {
        return new PersistentMetaDataAccess<T>(this, key, this.lockRepository.lock(key.getLockKey()));
    }

    public <T> @NonNull MetaDataAccess<T> accessTemporaryMetaData(@NonNull MetaDataKey<T> key) {
        return new TemporaryMetaDataAccess<T>(this, key, this.lockRepository.lock(key.getLockKey()));
    }

    <T> void setPersistentMeta(@NonNull MetaDataKey<T> key, @NonNull T value) {
        if (key.getType().getRawType().equals(Integer.class)) {
            this.setPersistentMeta(key.toString(), Ints.toByteArray((int)((Integer)value)));
        } else if (key.getType().getRawType().equals(Boolean.class)) {
            this.setPersistentMeta(key.toString(), ByteArrayUtilities.booleanToBytes((Boolean)value));
        } else {
            throw new IllegalArgumentException(String.format("Unknown meta data type '%s'", key.getType()));
        }
    }

    <T> @Nullable T getPersistentMeta(@NonNull MetaDataKey<T> key) {
        Constable returnValue;
        byte[] value = this.getPersistentMeta(key.toString());
        if (value == null) {
            return null;
        }
        if (key.getType().getRawType().equals(Integer.class)) {
            returnValue = Ints.fromByteArray((byte[])value);
        } else if (key.getType().getRawType().equals(Boolean.class)) {
            returnValue = Boolean.valueOf(ByteArrayUtilities.bytesToBoolean(value));
        } else {
            throw new IllegalArgumentException(String.format("Unknown meta data type '%s'", key.getType()));
        }
        return (T)returnValue;
    }

    void setPersistentMeta(String key, byte[] value) {
        boolean delete = this.hasPersistentMeta(key);
        this.metaMap.put(key, value);
        if (Settings.Enabled_Components.PERSISTENT_META) {
            DBFunc.addPersistentMeta(this.getUUID(), key, value, delete);
        }
    }

    public void sendTitle(@NonNull Caption title, @NonNull Caption subtitle, TagResolver ... replacements) {
        this.sendTitle(title, subtitle, Settings.Titles.TITLES_FADE_IN, Settings.Titles.TITLES_STAY, Settings.Titles.TITLES_FADE_OUT, replacements);
    }

    public void sendTitle(@NonNull Caption title, @NonNull Caption subtitle, int fadeIn, int stay, int fadeOut, TagResolver ... replacements) {
        Component titleComponent = MiniMessage.miniMessage().deserialize(title.getComponent(this), replacements);
        Component subtitleComponent = MiniMessage.miniMessage().deserialize(subtitle.getComponent(this), replacements);
        Title.Times times = Title.Times.times((Duration)Duration.of((long)Settings.Titles.TITLES_FADE_IN * 50L, ChronoUnit.MILLIS), (Duration)Duration.of((long)Settings.Titles.TITLES_STAY * 50L, ChronoUnit.MILLIS), (Duration)Duration.of((long)Settings.Titles.TITLES_FADE_OUT * 50L, ChronoUnit.MILLIS));
        this.getAudience().showTitle(Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)times));
    }

    public void sendActionBar(@NonNull Caption caption, TagResolver ... replacements) {
        Object message;
        try {
            message = caption.getComponent(this);
        }
        catch (CaptionMap.NoSuchCaptionException exception) {
            message = NON_EXISTENT_CAPTION + ((TranslatableCaption)caption).getKey();
            exception.printStackTrace();
        }
        if (((String)message).isEmpty()) {
            return;
        }
        message = CaptionUtility.format(this, (String)message).replace('\u2010', '%').replace('\u2020', '&').replace('\u2030', '&').replace("<prefix>", TranslatableCaption.of("core.prefix").getComponent(this));
        Component component = MiniMessage.miniMessage().deserialize((String)message, replacements);
        this.getAudience().sendActionBar(component);
    }

    @Override
    public void sendMessage(@NonNull Caption caption, TagResolver ... replacements) {
        Object message;
        try {
            message = caption.getComponent(this);
        }
        catch (CaptionMap.NoSuchCaptionException exception) {
            message = NON_EXISTENT_CAPTION + ((TranslatableCaption)caption).getKey();
            exception.printStackTrace();
        }
        if (((String)message).isEmpty()) {
            return;
        }
        message = CaptionUtility.format(this, (String)message).replace('\u2010', '%').replace('\u2020', '&').replace('\u2030', '&').replace("<prefix>", TranslatableCaption.of("core.prefix").getComponent(this));
        Component component = MiniMessage.miniMessage().deserialize((String)message, replacements);
        if (!Objects.equal((Object)component, this.getMeta("lastMessage")) || System.currentTimeMillis() - (Long)this.getMeta("lastMessageTime") > 5000L) {
            this.setMeta("lastMessage", component);
            this.setMeta("lastMessageTime", System.currentTimeMillis());
            this.getAudience().sendMessage(component);
        }
    }

    public final CompletableFuture<Void> sendMessage(@NonNull Caption caption, CompletableFuture<@NonNull TagResolver> asyncReplacement) {
        return this.sendMessage(caption, new CompletableFuture[]{asyncReplacement}, new TagResolver[0]);
    }

    public final CompletableFuture<Void> sendMessage(@NonNull Caption caption, CompletableFuture<@NonNull TagResolver>[] asyncReplacements, TagResolver ... replacements) {
        return CompletableFuture.allOf(asyncReplacements).whenComplete((unused, throwable) -> {
            HashSet<TagResolver> resolvers = new HashSet<TagResolver>(Arrays.asList(replacements));
            if (throwable != null) {
                this.sendMessage((Caption)TranslatableCaption.of("errors.error"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Failed to resolve asynchronous caption replacements")))});
                LOGGER.error("Failed to resolve asynchronous tagresolver(s) for " + caption, throwable);
            } else {
                for (CompletableFuture asyncReplacement : asyncReplacements) {
                    resolvers.add((TagResolver)asyncReplacement.join());
                }
            }
            this.sendMessage(caption, (TagResolver[])resolvers.toArray(TagResolver[]::new));
        });
    }

    @Override
    public boolean hasPermission(@NonNull String permission) {
        return this.hasPermission(null, permission);
    }

    boolean hasPersistentMeta(String key) {
        return this.metaMap.containsKey(key);
    }

    public abstract boolean canSee(PlotPlayer<?> var1);

    public abstract void stopSpectating();

    public boolean hasDebugMode() {
        return this.getAttribute("debug");
    }

    @Override
    public @NonNull Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.forLanguageTag(Settings.Enabled_Components.DEFAULT_LOCALE);
        }
        return this.locale;
    }

    @Override
    public void setLocale(@NonNull Locale locale) {
        this.locale = !PlotSquared.get().getCaptionMap("plotsquared").supportsLocale(locale) ? Locale.forLanguageTag(Settings.Enabled_Components.DEFAULT_LOCALE) : locale;
    }

    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + this.getUUID().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlotPlayer)) {
            return false;
        }
        PlotPlayer other = (PlotPlayer)obj;
        return this.getUUID().equals(other.getUUID());
    }

    public abstract @NonNull Audience getAudience();

    public @NonNull LockRepository getLockRepository() {
        return this.lockRepository;
    }

    public abstract void removeEffect(@NonNull String var1);

    @FunctionalInterface
    public static interface PlotPlayerConverter<BaseObject> {
        public PlotPlayer<?> convert(BaseObject var1);
    }
}

