/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.InternalFlag;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.types.IntegerFlag;
import com.plotsquared.core.plot.flag.types.ListFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.StringComparison;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.helpmenu.HelpMenu;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@CommandDeclaration(command="flag", aliases={"f", "flag"}, usage="/plot flag <set | remove | add | list | info> <flag> <value>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag")
public final class FlagCommand
extends Command {
    private final EventDispatcher eventDispatcher;

    @Inject
    public FlagCommand(@NonNull EventDispatcher eventDispatcher) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
    }

    private static boolean sendMessage(PlotPlayer<?> player) {
        player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot flag <set | remove | add | list | info> <flag> <value>")))});
        return true;
    }

    private static boolean checkPermValue(@NonNull PlotPlayer<?> player, @NonNull PlotFlag<?, ?> flag, @NonNull String key, @NonNull String value) {
        boolean result;
        key = key.toLowerCase();
        value = value.toLowerCase();
        String perm = Permission.PERMISSION_SET_FLAG_KEY_VALUE.format(key.toLowerCase(), value.toLowerCase());
        if (flag instanceof IntegerFlag && MathMan.isInteger(value)) {
            try {
                int numeric = Integer.parseInt(value);
                perm = perm.substring(0, perm.length() - value.length() - 1);
                boolean result2 = false;
                if (numeric > 0) {
                    int checkRange = PlotSquared.get().getPlatform().equalsIgnoreCase("bukkit") ? numeric : Settings.Limit.MAX_PLOTS;
                    boolean bl = result2 = player.hasPermissionRange(perm, checkRange) >= numeric;
                }
                if (!result2) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)(perm + "." + numeric))))});
                }
                return result2;
            }
            catch (NumberFormatException numeric) {}
        } else if (flag instanceof ListFlag) {
            ListFlag listFlag = (ListFlag)flag;
            try {
                Object parsedFlag = listFlag.parse(value);
                for (Object entry : (List)((PlotFlag)parsedFlag).getValue()) {
                    String permission = Permission.PERMISSION_SET_FLAG_KEY_VALUE.format(key.toLowerCase(), entry.toString().toLowerCase());
                    boolean result3 = player.hasPermission(permission);
                    if (result3) continue;
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)permission)))});
                    return false;
                }
            }
            catch (FlagParseException e) {
                player.sendMessage((Caption)TranslatableCaption.of("flag.flag_parse_error"), TagResolver.builder().tag("flag_name", Tag.inserting((Component)Component.text((String)flag.getName()))).tag("flag_value", Tag.inserting((Component)Component.text((String)e.getValue()))).tag("error", Tag.inserting((Component)e.getErrorMessage().toComponent(player))).build());
                return false;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        String basePerm = Permission.PERMISSION_SET_FLAG_KEY.format(key.toLowerCase());
        if (flag.isValuedPermission()) {
            result = player.hasKeyedPermission(basePerm, value);
        } else {
            result = player.hasPermission(basePerm);
            perm = basePerm;
        }
        if (!result) {
            player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)perm)))});
        }
        return result;
    }

    private static boolean checkRequirements(@NonNull PlotPlayer<?> player) {
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage((Caption)TranslatableCaption.of("working.plot_not_claimed"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_SET_FLAG_OTHER)) {
            player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_SET_FLAG_OTHER))});
            return false;
        }
        return true;
    }

    private static @Nullable PlotFlag<?, ?> getFlag(@NonNull PlotPlayer<?> player, @NonNull String arg) {
        if (arg.length() > 0) {
            PlotFlag<?, ?> flag = GlobalFlagContainer.getInstance().getFlagFromString(arg);
            if (flag instanceof InternalFlag || flag == null) {
                boolean suggested = false;
                try {
                    StringComparison<PlotFlag> stringComparison = new StringComparison<PlotFlag>(arg, GlobalFlagContainer.getInstance().getFlagMap().values(), PlotFlag::getName);
                    String best = stringComparison.getBestMatch();
                    if (best != null) {
                        player.sendMessage((Caption)TranslatableCaption.of("flag.not_valid_flag_suggested"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)best)))});
                        suggested = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!suggested) {
                    player.sendMessage((Caption)TranslatableCaption.of("flag.not_valid_flag"), new TagResolver[0]);
                }
                return null;
            }
            return flag;
        }
        return null;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        if (args.length == 0 || !Arrays.asList("set", "s", "list", "l", "delete", "remove", "r", "add", "a", "info", "i").contains(args[0].toLowerCase(Locale.ENGLISH))) {
            new HelpMenu(player).setCategory(CommandCategory.SETTINGS).setCommands(this.getCommands()).generateMaxPages().generatePage(0, this.getParent().toString(), player).render();
            return CompletableFuture.completedFuture(true);
        }
        return super.execute(player, args, confirm, whenDone);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            return Stream.of("set", "add", "remove", "delete", "info", "list").filter(value -> value.startsWith(args[0].toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, (String)value, "", RequiredType.NONE, null){}).collect(Collectors.toList());
        }
        if (Arrays.asList("set", "add", "remove", "delete", "info").contains(args[0].toLowerCase(Locale.ENGLISH)) && args.length == 2) {
            return GlobalFlagContainer.getInstance().getRecognizedPlotFlags().stream().filter(flag -> !(flag instanceof InternalFlag)).filter(flag -> flag.getName().startsWith(args[1].toLowerCase(Locale.ENGLISH))).map(flag -> new Command(null, false, flag.getName(), "", RequiredType.NONE, null){}).collect(Collectors.toList());
        }
        if (Arrays.asList("set", "add", "remove", "delete").contains(args[0].toLowerCase(Locale.ENGLISH)) && args.length == 3) {
            try {
                PlotFlag<?, ?> flag2 = GlobalFlagContainer.getInstance().getFlagFromString(args[1]);
                if (flag2 != null) {
                    Stream<String> stream = flag2.getTabCompletions().stream();
                    if (flag2 instanceof ListFlag && args[2].contains(",")) {
                        String cmp;
                        String[] split = args[2].split(",");
                        StringBuilder prefix = new StringBuilder();
                        for (int i = 0; i < split.length - 1; ++i) {
                            prefix.append(split[i]).append(",");
                        }
                        if (!args[2].endsWith(",")) {
                            cmp = split[split.length - 1];
                        } else {
                            prefix.append(split[split.length - 1]).append(",");
                            cmp = "";
                        }
                        return stream.filter(value -> value.startsWith(cmp.toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, prefix + value, "", RequiredType.NONE, null){}).collect(Collectors.toList());
                    }
                    return stream.filter(value -> value.startsWith(args[2].toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, (String)value, "", RequiredType.NONE, null){}).collect(Collectors.toList());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.tabOf(player, args, space, new String[0]);
    }

    @CommandDeclaration(command="set", aliases={"s", "set"}, usage="/plot flag set <flag> <value>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.set.flag")
    public void set(Command command, PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Object parsed;
        if (!FlagCommand.checkRequirements(player)) {
            return;
        }
        if (args.length < 2) {
            player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot flag set <flag> <value>")))});
            return;
        }
        PlotFlag<?, ?> plotFlag = FlagCommand.getFlag(player, args[0]);
        if (plotFlag == null) {
            return;
        }
        Plot plot = player.getLocation().getPlotAbs();
        PlotFlagAddEvent event = this.eventDispatcher.callFlagAdd(plotFlag, plot);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Flag set")))});
            return;
        }
        boolean force = event.getEventResult() == Result.FORCE;
        String value = StringMan.join(Arrays.copyOfRange(args, 1, args.length), " ");
        if (!force && !FlagCommand.checkPermValue(player, plotFlag, args[0], value)) {
            return;
        }
        value = CaptionUtility.stripClickEvents(plotFlag, value);
        try {
            parsed = plotFlag.parse(value);
        }
        catch (FlagParseException e) {
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_parse_error"), TagResolver.builder().tag("flag_name", Tag.inserting((Component)Component.text((String)plotFlag.getName()))).tag("flag_value", Tag.inserting((Component)Component.text((String)e.getValue()))).tag("error", Tag.inserting((Component)e.getErrorMessage().toComponent(player))).build());
            return;
        }
        plot.setFlag(parsed);
        player.sendMessage((Caption)TranslatableCaption.of("flag.flag_added"), TagResolver.builder().tag("flag", Tag.inserting((Component)Component.text((String)args[0]))).tag("value", Tag.inserting((Component)Component.text((String)((PlotFlag)parsed).toString()))).build());
    }

    @CommandDeclaration(command="add", aliases={"a", "add"}, usage="/plot flag add <flag> <value>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag.add")
    public void add(Command command, PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Object parsed;
        if (!FlagCommand.checkRequirements(player)) {
            return;
        }
        if (args.length < 2) {
            player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot flag add <flag> <values>")))});
            return;
        }
        PlotFlag<?, ?> plotFlag = FlagCommand.getFlag(player, args[0]);
        if (plotFlag == null) {
            return;
        }
        Plot plot = player.getLocation().getPlotAbs();
        PlotFlagAddEvent event = this.eventDispatcher.callFlagAdd(plotFlag, plot);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Flag add")))});
            return;
        }
        boolean force = event.getEventResult() == Result.FORCE;
        Object localFlag = player.getLocation().getPlotAbs().getFlagContainer().getFlag(event.getFlag().getClass());
        if (!force) {
            for (String entry : args[1].split(",")) {
                if (FlagCommand.checkPermValue(player, event.getFlag(), args[0], entry)) continue;
                return;
            }
        }
        String value = StringMan.join(Arrays.copyOfRange(args, 1, args.length), " ");
        try {
            parsed = event.getFlag().parse(value);
        }
        catch (FlagParseException e) {
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_parse_error"), TagResolver.builder().tag("flag_name", Tag.inserting((Component)Component.text((String)plotFlag.getName()))).tag("flag_value", Tag.inserting((Component)Component.text((String)e.getValue()))).tag("error", Tag.inserting((Component)e.getErrorMessage().toComponent(player))).build());
            return;
        }
        boolean result = player.getLocation().getPlotAbs().setFlag(((PlotFlag)localFlag).merge(((PlotFlag)parsed).getValue()));
        if (!result) {
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_added"), new TagResolver[0]);
            return;
        }
        player.sendMessage((Caption)TranslatableCaption.of("flag.flag_added"), TagResolver.builder().tag("flag", Tag.inserting((Component)Component.text((String)args[0]))).tag("value", Tag.inserting((Component)Component.text((String)((PlotFlag)parsed).toString()))).build());
    }

    @CommandDeclaration(command="remove", aliases={"r", "remove", "delete"}, usage="/plot flag remove <flag> [values]", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag.remove")
    public void remove(Command command, PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        if (!FlagCommand.checkRequirements(player)) {
            return;
        }
        if (args.length != 1 && args.length != 2) {
            player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot flag remove <flag> [values]")))});
            return;
        }
        PlotFlag<?, ?> flag = FlagCommand.getFlag(player, args[0]);
        if (flag == null) {
            return;
        }
        Plot plot = player.getLocation().getPlotAbs();
        Object flagWithOldValue = plot.getFlagContainer().getFlag(flag.getClass());
        PlotFlagRemoveEvent event = this.eventDispatcher.callFlagRemove(flag, plot);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Flag remove")))});
            return;
        }
        boolean force = event.getEventResult() == Result.FORCE;
        flag = event.getFlag();
        if (!force && !player.hasPermission(Permission.PERMISSION_SET_FLAG_KEY.format(args[0].toLowerCase())) && args.length != 2) {
            player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)Permission.PERMISSION_SET_FLAG_KEY.format(args[0].toLowerCase()))))});
            return;
        }
        if (args.length == 2 && flag instanceof ListFlag) {
            Object parsedFlag;
            ListFlag listFlag = (ListFlag)flag;
            String value = StringMan.join(Arrays.copyOfRange(args, 1, args.length), " ");
            ArrayList list = new ArrayList((Collection)plot.getFlag(listFlag.getClass()));
            try {
                parsedFlag = listFlag.parse(value);
            }
            catch (FlagParseException e) {
                player.sendMessage((Caption)TranslatableCaption.of("flag.flag_parse_error"), TagResolver.builder().tag("flag_name", Tag.inserting((Component)Component.text((String)flag.getName()))).tag("flag_value", Tag.inserting((Component)Component.text((String)e.getValue()))).tag("error", Tag.inserting((Component)e.getErrorMessage().toComponent(player))).build());
                return;
            }
            if (((List)((PlotFlag)parsedFlag).getValue()).isEmpty()) {
                player.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
                return;
            }
            if (list.removeAll((List)((PlotFlag)parsedFlag).getValue())) {
                if (list.isEmpty()) {
                    if (plot.removeFlag(flag)) {
                        player.sendMessage((Caption)TranslatableCaption.of("flag.flag_removed"), TagResolver.builder().tag("flag", Tag.inserting((Component)Component.text((String)args[0]))).tag("value", Tag.inserting((Component)Component.text((String)flag.toString()))).build());
                        return;
                    }
                    player.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
                    return;
                }
                Object plotFlag = ((PlotFlag)parsedFlag).createFlagInstance(list);
                PlotFlagAddEvent addEvent = this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)plotFlag, plot);
                if (addEvent.getEventResult() == Result.DENY) {
                    player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)("Re-addition of " + ((PlotFlag)plotFlag).getName()))))});
                    return;
                }
                if (plot.setFlag(addEvent.getFlag())) {
                    player.sendMessage((Caption)TranslatableCaption.of("flag.flag_partially_removed"), new TagResolver[0]);
                    return;
                }
                player.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
                return;
            }
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
            return;
        }
        boolean result = plot.removeFlag(flag);
        if (!result) {
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_not_removed"), new TagResolver[0]);
            return;
        }
        player.sendMessage((Caption)TranslatableCaption.of("flag.flag_removed"), TagResolver.builder().tag("flag", Tag.inserting((Component)Component.text((String)args[0]))).tag("value", Tag.inserting((Component)Component.text((String)flag.toString()))).build());
    }

    @CommandDeclaration(command="list", aliases={"l", "list", "flags"}, usage="/plot flag list", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag.list")
    public void list(Command command, PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Component category;
        if (!FlagCommand.checkRequirements(player)) {
            return;
        }
        HashMap<Component, ArrayList> flags = new HashMap<Component, ArrayList>();
        for (PlotFlag<?, ?> plotFlag : GlobalFlagContainer.getInstance().getRecognizedPlotFlags()) {
            if (plotFlag instanceof InternalFlag) continue;
            category = plotFlag.getFlagCategory().toComponent(player);
            Collection flagList = flags.computeIfAbsent(category, k -> new ArrayList());
            flagList.add(plotFlag.getName());
        }
        for (Map.Entry entry : flags.entrySet()) {
            Collections.sort((List)entry.getValue());
            category = MINI_MESSAGE.deserialize(TranslatableCaption.of("flag.flag_list_categories").getComponent(player), (TagResolver)TagResolver.resolver((String)"category", (Tag)Tag.inserting((Component)((Component)entry.getKey()).style(Style.empty()))));
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(category);
            Iterator flagIterator = ((ArrayList)entry.getValue()).iterator();
            while (flagIterator.hasNext()) {
                String flag = (String)flagIterator.next();
                builder.append(MINI_MESSAGE.deserialize(TranslatableCaption.of("flag.flag_list_flag").getComponent(player), TagResolver.builder().tag("command", (Tag)Tag.preProcessParsed((String)("/plot flag info " + flag))).tag("flag", Tag.inserting((Component)Component.text((String)flag))).tag("suffix", Tag.inserting((Component)Component.text((String)(flagIterator.hasNext() ? ", " : "")))).build()));
            }
            player.sendMessage((Caption)StaticCaption.of((String)MINI_MESSAGE.serialize((Component)builder.build())), new TagResolver[0]);
        }
    }

    @CommandDeclaration(command="info", aliases={"i", "info"}, usage="/plot flag info <flag>", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, permission="plots.flag.info")
    public void info(Command command, PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        if (!FlagCommand.checkRequirements(player)) {
            return;
        }
        if (args.length < 1) {
            player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot flag info <flag>")))});
            return;
        }
        PlotFlag<?, ?> plotFlag = FlagCommand.getFlag(player, args[0]);
        if (plotFlag != null) {
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_header"), new TagResolver[0]);
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_name"), new TagResolver[]{TagResolver.resolver((String)"flag", (Tag)Tag.inserting((Component)Component.text((String)plotFlag.getName())))});
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_category"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)plotFlag.getFlagCategory().toComponent(player)))});
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_description"), new TagResolver[0]);
            player.sendMessage(plotFlag.getFlagDescription(), new TagResolver[0]);
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_example"), TagResolver.builder().tag("command", (Tag)Tag.preProcessParsed((String)"/plot flag set")).tag("flag", (Tag)Tag.preProcessParsed((String)plotFlag.getName())).tag("value", (Tag)Tag.preProcessParsed((String)plotFlag.getExample())).build());
            String defaultValue = player.getLocation().getPlotArea().getFlagContainer().getFlagErased(plotFlag.getClass()).toString();
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_default_value"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)defaultValue)))});
            player.sendMessage((Caption)TranslatableCaption.of("flag.flag_info_footer"), new TagResolver[0]);
        }
    }
}

