/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlayerClaimPlotEvent;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.task.TaskManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="claim", aliases={"c"}, category=CommandCategory.CLAIMING, requiredType=RequiredType.PLAYER, permission="plots.claim", usage="/plot claim")
public class Claim
extends SubCommand {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + Claim.class.getSimpleName()));
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;

    @Inject
    public Claim(@NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler) {
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        int border;
        Location location;
        Plot plot;
        String schematic = null;
        if (args.length >= 1) {
            schematic = args[0];
        }
        if ((plot = (location = player.getLocation()).getPlotAbs()) == null) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        PlayerClaimPlotEvent event = this.eventDispatcher.callClaim(player, plot, schematic);
        schematic = event.getSchematic();
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Claim")))});
            return true;
        }
        boolean force = event.getEventResult() == Result.FORCE;
        int currentPlots = Settings.Limit.GLOBAL ? player.getPlotCount() : player.getPlotCount(location.getWorldName());
        PlotArea area = plot.getArea();
        try (MetaDataAccess<Integer> metaDataAccess = player.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_GRANTED_PLOTS);){
            int grants = 0;
            if (currentPlots >= player.getAllowedPlots() && !force) {
                if (metaDataAccess.isPresent()) {
                    grants = metaDataAccess.get().orElse(0);
                    if (grants <= 0) {
                        player.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)grants)))});
                        metaDataAccess.remove();
                    }
                } else {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_plots"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)player.getAllowedPlots())))});
                    boolean bl = false;
                    return bl;
                }
            }
            if (!plot.canClaim(player)) {
                player.sendMessage((Caption)TranslatableCaption.of("working.plot_is_claimed"), new TagResolver[0]);
                boolean bl = false;
                return bl;
            }
            if (schematic != null && !schematic.isEmpty() && area.isSchematicClaimSpecify()) {
                if (!area.hasSchematic(schematic)) {
                    player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid_named"), TagResolver.builder().tag("schemname", Tag.inserting((Component)Component.text((String)schematic))).tag("reason", Tag.inserting((Component)Component.text((String)"non-existent"))).build());
                }
                if (!(player.hasPermission(Permission.PERMISSION_CLAIM_SCHEMATIC.format(schematic)) || player.hasPermission("plots.admin.command.schematic") || force)) {
                    player.sendMessage((Caption)TranslatableCaption.of("permission.no_schematic_permission"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)schematic)))});
                }
            }
            if (this.econHandler.isEnabled(area) && !force && !player.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_ECON)) {
                PlotExpression costExr = area.getPrices().get("claim");
                double[] dArray = new double[]{currentPlots};
                double cost = costExr.evaluate(dArray);
                if (cost > 0.0) {
                    if (!this.econHandler.isSupported()) {
                        player.sendMessage((Caption)TranslatableCaption.of("economy.vault_or_consumer_null"), new TagResolver[0]);
                        boolean bl = false;
                        return bl;
                    }
                    if (this.econHandler.getMoney(player) < cost) {
                        player.sendMessage((Caption)TranslatableCaption.of("economy.cannot_afford_plot"), TagResolver.builder().tag("money", Tag.inserting((Component)Component.text((String)this.econHandler.format(cost)))).tag("balance", Tag.inserting((Component)Component.text((String)this.econHandler.format(this.econHandler.getMoney(player))))).build());
                        boolean bl = false;
                        return bl;
                    }
                    this.econHandler.withdrawMoney(player, cost);
                    player.sendMessage((Caption)TranslatableCaption.of("economy.removed_balance"), TagResolver.builder().tag("money", Tag.inserting((Component)Component.text((String)this.econHandler.format(cost)))).tag("balance", Tag.inserting((Component)Component.text((String)this.econHandler.format(this.econHandler.getMoney(player))))).build());
                }
            }
            if (grants > 0) {
                if (grants == 1) {
                    metaDataAccess.remove();
                } else {
                    metaDataAccess.set(grants - 1);
                }
                player.sendMessage((Caption)TranslatableCaption.of("economy.removed_granted_plot"), TagResolver.builder().tag("used_grants", Tag.inserting((Component)Component.text((int)(grants - 1)))).tag("remaining_grants", Tag.inserting((Component)Component.text((int)grants))).build());
            }
        }
        if (!player.hasPermission(Permission.PERMISSION_ADMIN_BYPASS_BORDER) && (border = area.getBorder(false)) != Integer.MAX_VALUE && plot.getDistanceFromOrigin() > border && !force) {
            player.sendMessage((Caption)TranslatableCaption.of("border.denied"), new TagResolver[0]);
            return false;
        }
        plot.setOwnerAbs(player.getUUID());
        String finalSchematic = schematic;
        DBFunc.createPlotSafe(plot, () -> {
            try {
                TaskManager.getPlatformImplementation().sync(() -> {
                    if (!plot.claim(player, true, finalSchematic, false, false)) {
                        LOGGER.info("Failed to claim plot {}", (Object)plot.getId().toCommaSeparatedString());
                        player.sendMessage((Caption)TranslatableCaption.of("working.plot_not_claimed"), new TagResolver[0]);
                        plot.setOwnerAbs(null);
                    } else if (area.isAutoMerge()) {
                        PlotMergeEvent mergeEvent = this.eventDispatcher.callMerge(plot, Direction.ALL, Integer.MAX_VALUE, player);
                        if (mergeEvent.getEventResult() == Result.DENY) {
                            player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Auto merge on claim")))});
                        } else if (plot.getPlotModificationManager().autoMerge(mergeEvent.getDir(), mergeEvent.getMax(), player.getUUID(), player, true)) {
                            this.eventDispatcher.callPostMerge(player, plot);
                        }
                    }
                    return null;
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, () -> {
            LOGGER.info("Failed to add plot to database: {}", (Object)plot.getId().toCommaSeparatedString());
            player.sendMessage((Caption)TranslatableCaption.of("working.plot_not_claimed"), new TagResolver[0]);
            plot.setOwnerAbs(null);
        });
        return true;
    }
}

