/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.collection;

import com.plotsquared.core.collection.RandomCollection;
import com.plotsquared.core.util.MathMan;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;

public class FlatRandomCollection<T>
extends RandomCollection<T> {
    private final T[] values;

    public FlatRandomCollection(Map<T, Double> weights, Random random) {
        super(weights, random);
        int max = 0;
        int[] counts = new int[weights.size()];
        Double[] weightDoubles = weights.values().toArray(new Double[0]);
        for (int i = 0; i < weightDoubles.length; ++i) {
            int weight;
            counts[i] = weight = (int)(weightDoubles[i] * 100.0);
            if ((double)weight != weightDoubles[i] * 100.0) {
                throw new IllegalArgumentException("Too small");
            }
            if (weight <= max) continue;
            max = weight;
        }
        int gcd = MathMan.gcd(counts);
        if (max / gcd > 100000) {
            throw new IllegalArgumentException("Too large");
        }
        ArrayList<T> parsed = new ArrayList<T>();
        for (Map.Entry<T, Double> entry : weights.entrySet()) {
            int num = (int)(100.0 * entry.getValue());
            for (int j = 0; j < num / gcd; ++j) {
                parsed.add(entry.getKey());
            }
        }
        this.values = parsed.toArray();
    }

    @Override
    public T next() {
        return this.values[this.random.nextInt(this.values.length)];
    }
}

