/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.queue.DelegateQueueCoordinator;
import com.plotsquared.core.queue.QueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AreaBoundDelegateQueueCoordinator
extends DelegateQueueCoordinator {
    private final PlotArea area;

    public AreaBoundDelegateQueueCoordinator(@NonNull PlotArea area, @Nullable QueueCoordinator parent) {
        super(parent);
        this.area = Objects.requireNonNull(area);
    }

    public PlotArea getArea() {
        return this.area;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BlockState id) {
        if (this.area.contains(x, z)) {
            return super.setBlock(x, y, z, id);
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BaseBlock id) {
        if (this.area.contains(x, z)) {
            return super.setBlock(x, y, z, id);
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        if (this.area.contains(x, z)) {
            return super.setBlock(x, y, z, pattern);
        }
        return false;
    }

    @Override
    public boolean setBiome(int x, int z, @NonNull BiomeType biome) {
        if (this.area.contains(x, z)) {
            return super.setBiome(x, z, biome);
        }
        return false;
    }

    @Override
    public boolean setBiome(int x, int y, int z, @NonNull BiomeType biome) {
        if (this.area.contains(x, z)) {
            return super.setBiome(x, y, z, biome);
        }
        return false;
    }

    @Override
    public boolean setTile(int x, int y, int z, @NonNull CompoundTag tag) {
        if (this.area.contains(x, z)) {
            return super.setTile(x, y, z, tag);
        }
        return false;
    }
}

