/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotInventory;
import com.plotsquared.core.plot.PlotItemStack;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.MusicFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.InventoryUtil;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="music", permission="plots.music", usage="/plot music", category=CommandCategory.APPEARANCE, requiredType=RequiredType.PLAYER)
public class Music
extends SubCommand {
    private static final Collection<String> DISCS = Arrays.asList("music_disc_13", "music_disc_cat", "music_disc_blocks", "music_disc_chirp", "music_disc_far", "music_disc_mall", "music_disc_mellohi", "music_disc_stal", "music_disc_strad", "music_disc_ward", "music_disc_11", "music_disc_wait", "music_disc_otherside", "music_disc_pigstep", "music_disc_5", "music_disc_relic");
    private final InventoryUtil inventoryUtil;
    private final EventDispatcher eventDispatcher;

    @Inject
    public Music(@Nullable InventoryUtil inventoryUtil, @NonNull EventDispatcher eventDispatcher) {
        this.inventoryUtil = inventoryUtil;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocation();
        final Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (!plot.isAdded(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_ADMIN_MUSIC_OTHER)) {
            player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_ADMIN_MUSIC_OTHER))});
            return true;
        }
        PlotInventory inv = new PlotInventory(this.inventoryUtil, player, 2, TranslatableCaption.of("plotjukebox.jukebox_header").getComponent(player)){

            @Override
            public boolean onClick(int index) {
                PlotItemStack item = this.getItem(index);
                if (item == null) {
                    return true;
                }
                if (item.getType() == ItemTypes.BEDROCK) {
                    Object plotFlag = plot.getFlagContainer().getFlag(MusicFlag.class).createFlagInstance(item.getType());
                    PlotFlagRemoveEvent event = Music.this.eventDispatcher.callFlagRemove((PlotFlag<?, ?>)plotFlag, plot);
                    if (event.getEventResult() == Result.DENY) {
                        this.getPlayer().sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Music removal")))});
                        return true;
                    }
                    plot.removeFlag(event.getFlag());
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("flag.flag_removed"), TagResolver.builder().tag("flag", Tag.inserting((Component)Component.text((String)"music"))).tag("value", Tag.inserting((Component)Component.text((String)"music_disc"))).build());
                } else if (item.getName().toLowerCase(Locale.ENGLISH).contains("disc")) {
                    Object plotFlag = plot.getFlagContainer().getFlag(MusicFlag.class).createFlagInstance(item.getType());
                    PlotFlagAddEvent event = Music.this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)plotFlag, plot);
                    if (event.getEventResult() == Result.DENY) {
                        this.getPlayer().sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Music addition")))});
                        return true;
                    }
                    plot.setFlag(event.getFlag());
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("flag.flag_added"), TagResolver.builder().tag("flag", Tag.inserting((Component)Component.text((String)"music"))).tag("value", Tag.inserting((Component)Component.text((String)event.getFlag().getValue().toString()))).build());
                } else {
                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("flag.flag_not_added"), new TagResolver[0]);
                }
                return false;
            }
        };
        int index = 0;
        for (String disc : DISCS) {
            PlotItemStack item;
            String name = String.format("<gold>%s</gold>", disc);
            String[] lore = new String[]{TranslatableCaption.of("plotjukebox.click_to_play").getComponent(player)};
            ItemType type = ItemTypes.get((String)disc);
            if (type == null || !inv.setItemChecked(index, item = new PlotItemStack(type, 1, name, lore))) continue;
            ++index;
        }
        String name = TranslatableCaption.of("plotjukebox.cancel_music").getComponent(player);
        String[] lore = new String[]{TranslatableCaption.of("plotjukebox.reset_music").getComponent(player)};
        inv.setItem(index, new PlotItemStack("bedrock", 1, name, lore));
        inv.openInventory();
        return true;
    }
}

