/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="condense", permission="plots.admin", usage="/plot condense <area> <start|stop|info> [radius]", category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.CONSOLE)
public class Condense
extends SubCommand {
    public static boolean TASK = false;
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public Condense(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        if (args.length != 2 && args.length != 3) {
            player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot condense <area> <start | stop | info> [radius]")))});
            return false;
        }
        PlotArea area = this.plotAreaManager.getPlotAreaByString(args[0]);
        if (area == null || !this.worldUtil.isWorld(area.getWorldName())) {
            player.sendMessage((Caption)TranslatableCaption.of("invalid.invalid_area"), new TagResolver[0]);
            return false;
        }
        switch (args[1].toLowerCase()) {
            case "start": {
                if (args.length == 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)("/plot condense" + area + " start <radius>"))))});
                    return false;
                }
                if (TASK) {
                    player.sendMessage((Caption)TranslatableCaption.of("condense.task_already_started"), new TagResolver[0]);
                    return false;
                }
                if (!MathMan.isInteger(args[2])) {
                    player.sendMessage((Caption)TranslatableCaption.of("condense.invalid_radius"), new TagResolver[0]);
                    return false;
                }
                int radius = Integer.parseInt(args[2]);
                ArrayList<Plot> plots = new ArrayList<Plot>(area.getPlots());
                Iterator iterator = plots.iterator();
                int maxSize = 0;
                ArrayList<Integer> sizes = new ArrayList<Integer>();
                while (iterator.hasNext()) {
                    Plot plot = (Plot)iterator.next();
                    if (!plot.isBasePlot()) {
                        iterator.remove();
                        continue;
                    }
                    int size = plot.getConnectedPlots().size();
                    if (size > maxSize) {
                        maxSize = size;
                    }
                    sizes.add(size - 1);
                }
                ArrayList[] buckets = new ArrayList[maxSize];
                for (int i = 0; i < plots.size(); ++i) {
                    Plot plot = (Plot)plots.get(i);
                    int size = (Integer)sizes.get(i);
                    ArrayList<Plot> array = buckets[size];
                    if (array == null) {
                        buckets[size] = array = new ArrayList<Plot>();
                    }
                    array.add(plot);
                }
                final ArrayList<Plot> allPlots = new ArrayList<Plot>(plots.size());
                for (int i = buckets.length - 1; i >= 0; --i) {
                    ArrayList array = buckets[i];
                    if (array == null) continue;
                    allPlots.addAll(array);
                }
                int size = allPlots.size();
                int minimumRadius = (int)Math.ceil(Math.sqrt(size) / 2.0 + 1.0);
                if (radius < minimumRadius) {
                    player.sendMessage((Caption)TranslatableCaption.of("condense.radius_too_small"), new TagResolver[0]);
                    return false;
                }
                ArrayList<PlotId> toMove = new ArrayList<PlotId>(this.getPlots(allPlots, radius));
                final ArrayList<PlotId> free = new ArrayList<PlotId>();
                PlotId start = PlotId.of(0, 0);
                while (start.getX() <= minimumRadius && start.getY() <= minimumRadius) {
                    Plot plot = area.getPlotAbs(start);
                    if (plot != null && !plot.hasOwner()) {
                        free.add(plot.getId());
                    }
                    start = start.getNextId();
                }
                if (free.isEmpty() || toMove.isEmpty()) {
                    player.sendMessage((Caption)TranslatableCaption.of("condense.no_free_plots_found"), new TagResolver[0]);
                    return false;
                }
                player.sendMessage((Caption)TranslatableCaption.of("condense.task_started"), new TagResolver[0]);
                TASK = true;
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        if (!TASK) {
                            player.sendMessage((Caption)TranslatableCaption.of("debugexec.task_cancelled"), new TagResolver[0]);
                        }
                        if (allPlots.isEmpty()) {
                            TASK = false;
                            player.sendMessage((Caption)TranslatableCaption.of("condense.task_complete"), new TagResolver[0]);
                            return;
                        }
                        1 task = this;
                        Plot origin = (Plot)allPlots.remove(0);
                        int i = 0;
                        while (free.size() > i) {
                            Plot possible = origin.getArea().getPlotAbs((PlotId)free.get(i));
                            if (possible.hasOwner()) {
                                free.remove(i);
                                continue;
                            }
                            ++i;
                            AtomicBoolean result = new AtomicBoolean(false);
                            try {
                                result.set(origin.getPlotModificationManager().move(possible, player, () -> {
                                    if (result.get()) {
                                        player.sendMessage((Caption)TranslatableCaption.of("condense.moving"), TagResolver.builder().tag("origin", Tag.inserting((Component)Component.text((String)origin.toString()))).tag("possible", Tag.inserting((Component)Component.text((String)possible.toString()))).build());
                                        TaskManager.runTaskLater(task, TaskTime.ticks(1L));
                                    }
                                }, false).get());
                            }
                            catch (InterruptedException | ExecutionException e) {
                                e.printStackTrace();
                            }
                            if (!result.get()) continue;
                            break;
                        }
                        if (free.isEmpty()) {
                            TASK = false;
                            player.sendMessage((Caption)TranslatableCaption.of("condense.task_failed"), new TagResolver[0]);
                            return;
                        }
                        if (i >= free.size()) {
                            player.sendMessage((Caption)TranslatableCaption.of("condense.skipping"), new TagResolver[]{TagResolver.resolver((String)"plot", (Tag)Tag.inserting((Component)Component.text((String)origin.toString())))});
                        }
                    }
                };
                TaskManager.runTaskAsync(run);
                return true;
            }
            case "stop": {
                if (!TASK) {
                    player.sendMessage((Caption)TranslatableCaption.of("condense.task_stopped"), new TagResolver[0]);
                    return false;
                }
                TASK = false;
                player.sendMessage((Caption)TranslatableCaption.of("condense.task_stopped"), new TagResolver[0]);
                return true;
            }
            case "info": {
                Collection<Plot> plots;
                int size;
                int minimumRadius;
                if (args.length == 2) {
                    player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)("/plot condense " + area + " info <radius>"))))});
                    return false;
                }
                if (!MathMan.isInteger(args[2])) {
                    player.sendMessage((Caption)TranslatableCaption.of("condense.invalid_radius"), new TagResolver[0]);
                    return false;
                }
                int radius = Integer.parseInt(args[2]);
                if (radius < (minimumRadius = (int)Math.ceil(Math.sqrt(size = (plots = area.getPlots()).size()) / 2.0 + 1.0))) {
                    player.sendMessage((Caption)TranslatableCaption.of("condense.radius_too_small"), new TagResolver[0]);
                    return false;
                }
                int maxMove = this.getPlots(plots, minimumRadius).size();
                int userMove = this.getPlots(plots, radius).size();
                player.sendMessage((Caption)TranslatableCaption.of("condense.default_eval"), new TagResolver[0]);
                player.sendMessage((Caption)TranslatableCaption.of("condense.minimum_radius"), new TagResolver[]{TagResolver.resolver((String)"minimumRadius", (Tag)Tag.inserting((Component)Component.text((int)minimumRadius)))});
                player.sendMessage((Caption)TranslatableCaption.of("condense.maximum_moved"), new TagResolver[]{TagResolver.resolver((String)"maxMove", (Tag)Tag.inserting((Component)Component.text((int)maxMove)))});
                player.sendMessage((Caption)TranslatableCaption.of("condense.input_eval"), new TagResolver[0]);
                player.sendMessage((Caption)TranslatableCaption.of("condense.input_radius"), new TagResolver[]{TagResolver.resolver((String)"radius", (Tag)Tag.inserting((Component)Component.text((int)radius)))});
                player.sendMessage((Caption)TranslatableCaption.of("condense.estimated_moves"), new TagResolver[]{TagResolver.resolver((String)"userMove", (Tag)Tag.inserting((Component)Component.text((int)userMove)))});
                player.sendMessage((Caption)TranslatableCaption.of("condense.eta"), new TagResolver[0]);
                player.sendMessage((Caption)TranslatableCaption.of("condense.radius_measured"), new TagResolver[0]);
                return true;
            }
        }
        player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)("/plot condense " + area.getWorldName() + " <start | stop | info> [radius]"))))});
        return false;
    }

    public Set<PlotId> getPlots(Collection<Plot> plots, int radius) {
        HashSet<PlotId> outside = new HashSet<PlotId>();
        for (Plot plot : plots) {
            if (plot.getId().getX() <= radius && plot.getId().getX() >= -radius && plot.getId().getY() <= radius && plot.getId().getY() >= -radius) continue;
            outside.add(plot.getId());
        }
        return outside;
    }
}

