/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CmdInstance;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CmdConfirm {
    public static @Nullable CmdInstance getPending(PlotPlayer<?> player) {
        try (MetaDataAccess<CmdInstance> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_CONFIRM);){
            CmdInstance cmdInstance = metaDataAccess.get().orElse(null);
            return cmdInstance;
        }
    }

    public static void removePending(PlotPlayer<?> player) {
        try (MetaDataAccess<CmdInstance> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_CONFIRM);){
            metaDataAccess.remove();
        }
    }

    public static void addPending(PlotPlayer<?> player, String commandStr, Runnable runnable) {
        CmdConfirm.removePending(player);
        if (commandStr != null) {
            player.sendMessage((Caption)TranslatableCaption.of("confirm.requires_confirm"), TagResolver.builder().tag("command", Tag.inserting((Component)Component.text((String)commandStr))).tag("timeout", Tag.inserting((Component)Component.text((int)Settings.Confirmation.CONFIRMATION_TIMEOUT_SECONDS))).tag("value", Tag.inserting((Component)Component.text((String)"/plot confirm"))).build());
        }
        TaskManager.runTaskLater(() -> {
            CmdInstance cmd = new CmdInstance(runnable);
            try (MetaDataAccess<CmdInstance> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_CONFIRM);){
                metaDataAccess.set(cmd);
            }
        }, TaskTime.ticks(1L));
    }
}

