/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

public class StringMan {
    private static final Pattern STRING_SPLIT_PATTERN = Pattern.compile("[^\\s\"]+|\"([^\"]*)\"");

    public static int intersection(Set<String> options, String[] toCheck) {
        int count = 0;
        for (String check : toCheck) {
            if (!options.contains(check)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isAlphanumericUnd(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!(c < '0' || c >= ':' && c <= '@' || c > 'Z' && c <= '`') && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static String join(Collection<?> collection, String delimiter) {
        return StringMan.join(collection.toArray(), delimiter);
    }

    public static String joinOrdered(Collection<?> collection, String delimiter) {
        Object[] array = collection.toArray();
        Arrays.sort(array, Comparator.comparingInt(Object::hashCode));
        return StringMan.join(array, delimiter);
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            String tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static String join(Object[] array, String delimiter) {
        StringBuilder result = new StringBuilder();
        int j = array.length;
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                result.append(delimiter);
            }
            result.append(array[i]);
        }
        return result.toString();
    }

    public static boolean isEqualIgnoreCaseToAny(@NonNull String a, String ... args) {
        for (String arg : args) {
            if (!a.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqual(String a, String b) {
        if (a == null && b != null || a != null && b == null) {
            return false;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public static String repeat(String s, int n) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(s).repeat(Math.max(0, n)));
        return sb.toString();
    }

    public static @NonNull List<String> splitMessage(@NonNull String message) {
        Matcher matcher = STRING_SPLIT_PATTERN.matcher(message);
        ArrayList<String> splitMessages = new ArrayList<String>();
        while (matcher.find()) {
            splitMessages.add(matcher.group(matcher.groupCount() - 1).replaceAll("\"", ""));
        }
        return splitMessages;
    }
}

