/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.plot.BlockBucket;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LegacyConverter {
    public static final String CONFIGURATION_VERSION = "post_flattening";
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + LegacyConverter.class.getSimpleName()));
    private static final HashMap<String, ConfigurationType> TYPE_MAP = new HashMap();
    private final ConfigurationSection configuration;

    public LegacyConverter(@NonNull ConfigurationSection configuration) {
        this.configuration = configuration;
    }

    private BlockBucket blockToBucket(@NonNull String block) {
        BlockState plotBlock = (BlockState)PlotSquared.platform().worldUtil().getClosestBlock((String)block).best;
        return BlockBucket.withSingle(plotBlock);
    }

    private void setString(@NonNull ConfigurationSection section, @NonNull String string, @NonNull BlockBucket blocks) {
        if (!section.contains(string)) {
            throw new IllegalArgumentException(String.format("No such key: %s", string));
        }
        section.set(string, blocks.toString());
    }

    private BlockBucket blockListToBucket(@NonNull BlockState[] blocks) {
        HashMap<BlockState, Integer> counts = new HashMap<BlockState, Integer>();
        for (BlockState block : blocks) {
            counts.putIfAbsent(block, 0);
            counts.put(block, (Integer)counts.get(block) + 1);
        }
        boolean includeRatios = false;
        for (Integer integer : counts.values()) {
            if (integer <= 1) continue;
            includeRatios = true;
            break;
        }
        BlockBucket bucket = new BlockBucket();
        if (includeRatios) {
            for (Map.Entry count : counts.entrySet()) {
                bucket.addBlock((BlockState)count.getKey(), (Integer)count.getValue());
            }
        } else {
            counts.keySet().forEach(bucket::addBlock);
        }
        return bucket;
    }

    private BlockState[] splitBlockList(@NonNull List<String> list) {
        return (BlockState[])list.stream().map(s -> (BlockState)PlotSquared.platform().worldUtil().getClosestBlock((String)s).best).toArray(BlockState[]::new);
    }

    private void convertBlock(@NonNull ConfigurationSection section, @NonNull String key, @NonNull String block) {
        BlockBucket bucket = this.blockToBucket(block);
        this.setString(section, key, bucket);
        ConsolePlayer.getConsole().sendMessage(TranslatableCaption.of("legacyconfig.legacy_config_replaced"), TagResolver.builder().tag("value1", Tag.inserting((Component)Component.text((String)block))).tag("value2", Tag.inserting((Component)Component.text((String)bucket.toString()))).build());
    }

    private void convertBlockList(@NonNull ConfigurationSection section, @NonNull String key, @NonNull List<String> blockList) {
        BlockState[] blocks = this.splitBlockList(blockList);
        BlockBucket bucket = this.blockListToBucket(blocks);
        this.setString(section, key, bucket);
        ConsolePlayer.getConsole().sendMessage(TranslatableCaption.of("legacyconfig.legacy_config_replaced"), TagResolver.builder().tag("value1", Tag.inserting((Component)Component.text((String)this.plotBlockArrayString(blocks)))).tag("value2", Tag.inserting((Component)Component.text((String)bucket.toString()))).build());
    }

    private String plotBlockArrayString(@NonNull BlockState[] blocks) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < blocks.length; ++i) {
            builder.append(blocks[i].toString());
            if (i + 1 >= blocks.length) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public void convert() {
        Set<String> worlds = this.configuration.getKeys(false);
        for (String world : worlds) {
            ConfigurationSection worldSection = this.configuration.getConfigurationSection(world);
            for (Map.Entry<String, ConfigurationType> entry : TYPE_MAP.entrySet()) {
                if (!worldSection.contains(entry.getKey())) continue;
                if (entry.getValue() == ConfigurationType.BLOCK) {
                    this.convertBlock(worldSection, entry.getKey(), worldSection.getString(entry.getKey()));
                    continue;
                }
                this.convertBlockList(worldSection, entry.getKey(), worldSection.getStringList(entry.getKey()));
            }
        }
    }

    static {
        TYPE_MAP.put("plot.filling", ConfigurationType.BLOCK_LIST);
        TYPE_MAP.put("plot.floor", ConfigurationType.BLOCK_LIST);
        TYPE_MAP.put("wall.filling", ConfigurationType.BLOCK);
        TYPE_MAP.put("wall.block_claimed", ConfigurationType.BLOCK);
        TYPE_MAP.put("wall.block", ConfigurationType.BLOCK);
        TYPE_MAP.put("road.block", ConfigurationType.BLOCK);
    }

    private static enum ConfigurationType {
        BLOCK,
        BLOCK_LIST;

    }
}

