/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.setup;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.setup.SettingsNodesWrapper;
import com.plotsquared.core.setup.SetupProcess;
import com.plotsquared.core.setup.SetupStep;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.StringMan;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CommonSetupSteps implements SetupStep
{
    CHOOSE_GENERATOR(TranslatableCaption.of("setup.setup_init")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder builder, String arg) {
            if (!SetupUtils.generators.containsKey(arg)) {
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_world_generator_error"), new TagResolver[0]);
                return this;
            }
            builder.generatorName(arg);
            return CHOOSE_PLOT_AREA_TYPE;
        }

        @Override
        public Collection<String> getSuggestions() {
            return Collections.unmodifiableSet(SetupUtils.generators.keySet());
        }

        @Override
        public @Nullable String getDefaultValue() {
            return PlotSquared.platform().pluginName();
        }
    }
    ,
    CHOOSE_PLOT_AREA_TYPE(PlotAreaType.class, (Caption)TranslatableCaption.of("setup.setup_world_type")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder builder, String arg) {
            Optional<PlotAreaType> plotAreaType = PlotAreaType.fromString(arg);
            if (!plotAreaType.isPresent()) {
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_world_type_error"), new TagResolver[0]);
                return this;
            }
            builder.plotAreaType(plotAreaType.get());
            GeneratorWrapper<?> gen = SetupUtils.generators.get(builder.generatorName());
            if (builder.plotAreaType() == PlotAreaType.NORMAL) {
                if (builder.settingsNodesWrapper() == null) {
                    builder.plotManager(builder.generatorName());
                    builder.settingsNodesWrapper(CommonSetupSteps.wrap(builder.plotManager()));
                    SetupUtils.generators.get(builder.plotManager()).getPlotGenerator().processAreaSetup(builder);
                }
                return builder.settingsNodesWrapper().getFirstStep();
            }
            if (gen.isFull()) {
                builder.plotManager(builder.generatorName());
                builder.generatorName(null);
                builder.settingsNodesWrapper(CommonSetupSteps.wrap(builder.plotManager()));
                SetupUtils.generators.get(builder.plotManager()).getPlotGenerator().processAreaSetup(builder);
            } else {
                builder.plotManager(PlotSquared.platform().pluginName());
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_world_generator_error"), new TagResolver[0]);
                builder.settingsNodesWrapper(CommonSetupSteps.wrap(builder.plotManager()));
            }
            if (builder.plotAreaType() == PlotAreaType.PARTIAL) {
                return CHOOSE_AREA_ID;
            }
            return CHOOSE_TERRAIN_TYPE;
        }

        @Override
        public @Nullable String getDefaultValue() {
            return PlotAreaType.NORMAL.toString();
        }
    }
    ,
    CHOOSE_AREA_ID(TranslatableCaption.of("setup.setup_area_name")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder builder, String argument) {
            if (!StringMan.isAlphanumericUnd(argument)) {
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_area_non_alphanumerical"), new TagResolver[0]);
                return this;
            }
            for (PlotArea area : PlotSquared.get().getPlotAreaManager().getAllPlotAreas()) {
                if (area.getId() == null || !area.getId().equalsIgnoreCase(argument)) continue;
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_area_invalid_id"), new TagResolver[0]);
                return this;
            }
            builder.areaName(argument);
            return CHOOSE_MINIMUM_PLOT_ID;
        }

        @Override
        public @Nullable String getDefaultValue() {
            return null;
        }
    }
    ,
    CHOOSE_MINIMUM_PLOT_ID(TranslatableCaption.of("setup.setup_area_min_plot_id")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder builder, String argument) {
            try {
                builder.minimumId(PlotId.fromString(argument));
            }
            catch (IllegalArgumentException ignored) {
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_area_min_plot_id_error"), new TagResolver[0]);
                return this;
            }
            catch (IllegalStateException ignored) {
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_area_plot_id_greater_than_minimum"), new TagResolver[0]);
                return this;
            }
            return CHOOSE_MAXIMUM_PLOT_ID;
        }

        @Override
        public String getDefaultValue() {
            return "0;0";
        }
    }
    ,
    CHOOSE_MAXIMUM_PLOT_ID(TranslatableCaption.of("setup.setup_area_max_plot_id")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder builder, String argument) {
            try {
                builder.maximumId(PlotId.fromString(argument));
            }
            catch (IllegalArgumentException ignored) {
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_area_max_plot_id_error"), new TagResolver[0]);
                return this;
            }
            catch (IllegalStateException ignored) {
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_area_plot_id_greater_than_minimum"), new TagResolver[0]);
                return this;
            }
            return CHOOSE_TERRAIN_TYPE;
        }

        @Override
        public String getDefaultValue() {
            return "0;0";
        }
    }
    ,
    CHOOSE_TERRAIN_TYPE(PlotAreaTerrainType.class, (Caption)TranslatableCaption.of("setup.setup_partial_area")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder builder, String argument) {
            Optional<PlotAreaTerrainType> optTerrain = PlotAreaTerrainType.fromString(argument);
            if (!optTerrain.isPresent()) {
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_partial_area_error"), new TagResolver[0]);
                return this;
            }
            builder.terrainType(optTerrain.get());
            if (builder.settingsNodesWrapper() == null) {
                builder.settingsNodesWrapper(CommonSetupSteps.wrap(builder.plotManager()));
            }
            SettingsNodesWrapper wrapper = builder.settingsNodesWrapper();
            return wrapper.getFirstStep();
        }

        @Override
        public @Nullable String getDefaultValue() {
            return PlotAreaTerrainType.NONE.toString();
        }
    }
    ,
    CHOOSE_WORLD_NAME(TranslatableCaption.of("setup.setup_world_name")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder builder, String argument) {
            if (!CommonSetupSteps.isValidWorldName(argument)) {
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_world_name_format"), new TagResolver[0]);
                return this;
            }
            if (PlotSquared.platform().worldUtil().isWorld(argument)) {
                if (PlotSquared.get().getPlotAreaManager().hasPlotArea(argument)) {
                    plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_world_taken"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)argument)))});
                    return this;
                }
                plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_world_apply_plotsquared"), new TagResolver[0]);
            }
            builder.worldName(argument);
            try (MetaDataAccess<SetupProcess> setupAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SETUP);){
                setupAccess.remove();
            }
            String world = builder.setupManager() == null ? ((SetupUtils)PlotSquared.platform().injector().getInstance(SetupUtils.class)).setupWorld(builder) : builder.setupManager().setupWorld(builder);
            try {
                plotPlayer.teleport(PlotSquared.platform().worldUtil().getSpawn(world), TeleportCause.COMMAND_SETUP);
            }
            catch (Exception e) {
                plotPlayer.sendMessage(TranslatableCaption.of("errors.error_console"), new TagResolver[0]);
                e.printStackTrace();
            }
            plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_finished"), new TagResolver[0]);
            return null;
        }

        @Override
        public @Nullable String getDefaultValue() {
            return null;
        }
    };

    private final @NonNull Collection<String> suggestions;
    private final Caption description;

    private CommonSetupSteps(Collection<String> suggestions, Caption description) {
        this.suggestions = suggestions;
        this.description = description;
    }

    private CommonSetupSteps(Caption description) {
        this.description = description;
        this.suggestions = Collections.emptyList();
    }

    private <E extends Enum<E>> CommonSetupSteps(Class<E> argumentType, Caption description) {
        this(CommonSetupSteps.enumToStrings(argumentType), description);
    }

    private static <E extends Enum<E>> Collection<String> enumToStrings(Class<E> type) {
        return Arrays.stream((Enum[])type.getEnumConstants()).map(e -> e.toString().toLowerCase()).collect(Collectors.toList());
    }

    private static SettingsNodesWrapper wrap(String plotManager) {
        return new SettingsNodesWrapper(SetupUtils.generators.get(plotManager).getPlotGenerator().getNewPlotArea("CheckingPlotSquaredGenerator", null, null, null).getSettingNodes(), CHOOSE_WORLD_NAME);
    }

    private static boolean isValidWorldName(String s) {
        return s.chars().allMatch(i -> i == 95 || i == 45 || i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57 || i == 46);
    }

    @Override
    public void announce(PlotPlayer<?> plotPlayer) {
        plotPlayer.sendMessage(this.description, new TagResolver[0]);
    }

    @Override
    public @NonNull Collection<String> getSuggestions() {
        return this.suggestions;
    }
}

