/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.services.plots;

import cloud.commandframework.services.types.Service;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.services.plots.AutoQuery;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface AutoService
extends Service<AutoQuery, List<Plot>> {
    public static final Cache<PlotId, Plot> plotCandidateCache = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build();
    public static final Object plotLock = new Object();

    public static final class MultiPlotService
    implements AutoService,
    Predicate<AutoQuery> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Plot> handle(@NonNull AutoQuery autoQuery) {
            block3: while (true) {
                Object object = plotLock;
                synchronized (object) {
                    PlotId start = autoQuery.plotArea().getMeta("lastPlot", PlotId.of(0, 0)).getNextId();
                    PlotId end = PlotId.of(start.getX() + autoQuery.sizeX() - 1, start.getY() + autoQuery.sizeZ() - 1);
                    List<Plot> plots = autoQuery.plotArea().canClaim(autoQuery.player(), start, end);
                    autoQuery.plotArea().setMeta("lastPlot", start);
                    if (plots != null && !plots.isEmpty()) {
                        for (Plot plot : plots) {
                            if (plotCandidateCache.getIfPresent((Object)plot.getId()) != null) {
                                continue block3;
                            }
                            plotCandidateCache.put((Object)plot.getId(), (Object)plot);
                        }
                        return plots;
                    }
                }
            }
        }

        @Override
        public boolean test(@NonNull AutoQuery autoQuery) {
            return autoQuery.plotArea().getType() != PlotAreaType.PARTIAL;
        }
    }

    public static final class SinglePlotService
    implements AutoService,
    Predicate<AutoQuery> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable List<Plot> handle(@NonNull AutoQuery autoQuery) {
            Plot plot;
            PlotId nextId = autoQuery.startId();
            do {
                Object object = plotLock;
                synchronized (object) {
                    plot = autoQuery.plotArea().getNextFreePlot(autoQuery.player(), nextId);
                    if (plot != null && plotCandidateCache.getIfPresent((Object)plot.getId()) == null) {
                        plotCandidateCache.put((Object)plot.getId(), (Object)plot);
                        return Collections.singletonList(plot);
                    }
                    if (plot != null) {
                        nextId = plot.getId();
                    }
                }
            } while (plot != null);
            return null;
        }

        @Override
        public boolean test(@NonNull AutoQuery autoQuery) {
            return autoQuery.sizeX() == 1 && autoQuery.sizeZ() == 1;
        }
    }

    public static final class DefaultAutoService
    implements AutoService {
        public List<Plot> handle(@NonNull AutoQuery autoQuery) {
            return Collections.emptyList();
        }
    }
}

