/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.listener;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.listener.ProcessedWEExtent;
import com.plotsquared.core.listener.WEExtent;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.WEManager;
import com.plotsquared.core.util.WorldUtil;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.eventbus.EventHandler;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WESubscriber {
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public WESubscriber(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Subscribe(priority=EventHandler.Priority.VERY_EARLY)
    public void onEditSession(EditSessionEvent event) {
        if (!Settings.Enabled_Components.WORLDEDIT_RESTRICTIONS) {
            WorldEdit.getInstance().getEventBus().unregister((Object)this);
            return;
        }
        if (event.getStage() != EditSession.Stage.BEFORE_HISTORY) {
            return;
        }
        World worldObj = event.getWorld();
        if (worldObj == null) {
            return;
        }
        String world = worldObj.getName();
        Actor actor = event.getActor();
        if (actor != null && actor.isPlayer()) {
            Set<CuboidRegion> mask;
            String name = actor.getName();
            PlotPlayer<?> plotPlayer = PlotSquared.platform().playerManager().getPlayerIfExists(name);
            if (plotPlayer == null) {
                Player player = (Player)actor;
                com.sk89q.worldedit.util.Location location = player.getLocation();
                Location pLoc = Location.at(player.getWorld().getName(), location.toVector().toBlockPoint());
                Plot plot = pLoc.getPlot();
                if (plot == null) {
                    event.setExtent((Extent)new NullExtent());
                    return;
                }
                mask = plot.getRegions();
            } else {
                if (plotPlayer.getAttribute("worldedit")) {
                    return;
                }
                mask = WEManager.getMask(plotPlayer);
                if (mask.isEmpty()) {
                    if (plotPlayer.hasPermission("plots.worldedit.bypass")) {
                        plotPlayer.sendMessage(TranslatableCaption.of("worldedit.worldedit_bypass"), new TagResolver[]{TagResolver.resolver((String)"command", (Tag)Tag.inserting((Component)Component.text((String)"/plot toggle worldedit")))});
                    }
                    if (this.plotAreaManager.hasPlotArea(world)) {
                        event.setExtent((Extent)new NullExtent());
                    }
                    return;
                }
            }
            if (Settings.Enabled_Components.CHUNK_PROCESSOR) {
                if (this.plotAreaManager.hasPlotArea(world)) {
                    event.setExtent((Extent)new ProcessedWEExtent(world, mask, event.getMaxBlocks(), event.getExtent(), event.getExtent(), this.worldUtil));
                }
            } else if (this.plotAreaManager.hasPlotArea(world)) {
                event.setExtent((Extent)new WEExtent(mask, event.getExtent()));
            }
        }
    }
}

