/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.caption;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.ChatFormatter;
import com.plotsquared.core.configuration.caption.ComponentTransform;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DescriptionFlag;
import com.plotsquared.core.plot.flag.implementations.FarewellFlag;
import com.plotsquared.core.plot.flag.implementations.GreetingFlag;
import com.plotsquared.core.plot.flag.implementations.PlotTitleFlag;
import java.util.Set;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.ParsingException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CaptionUtility {
    private static final Pattern LEGACY_FORMATTING = Pattern.compile("\u00a7[a-gklmnor0-9]");
    private static final Set<Class<? extends PlotFlag<?, ?>>> MINI_MESSAGE_FLAGS = Set.of(GreetingFlag.class, FarewellFlag.class, DescriptionFlag.class, PlotTitleFlag.class);
    private static final ComponentTransform CLICK_STRIP_TRANSFORM = ComponentTransform.nested(ComponentTransform.stripClicks((ClickEvent.Action[])Settings.Chat.CLICK_EVENT_ACTIONS_TO_REMOVE.stream().map(ClickEvent.Action::valueOf).toArray(ClickEvent.Action[]::new)));

    public static String formatRaw(PlotPlayer<?> recipient, String message) {
        ChatFormatter.ChatContext chatContext = new ChatFormatter.ChatContext(recipient, message, true);
        for (ChatFormatter chatFormatter : ChatFormatter.formatters) {
            chatFormatter.format(chatContext);
        }
        return chatContext.getMessage();
    }

    public static String format(@Nullable PlotPlayer<?> recipient, @NonNull String message) {
        ChatFormatter.ChatContext chatContext = new ChatFormatter.ChatContext(recipient, message, false);
        for (ChatFormatter chatFormatter : ChatFormatter.formatters) {
            chatFormatter.format(chatContext);
        }
        return chatContext.getMessage();
    }

    public static String stripClickEvents(@NonNull String miniMessageString) {
        Component component;
        try {
            component = MiniMessage.miniMessage().deserialize((Object)miniMessageString);
        }
        catch (ParsingException e) {
            String legacyStripped = LEGACY_FORMATTING.matcher(miniMessageString).replaceAll("");
            component = MiniMessage.miniMessage().deserialize((Object)legacyStripped);
        }
        component = CLICK_STRIP_TRANSFORM.transform(component);
        return (String)MiniMessage.miniMessage().serialize(component);
    }

    public static String stripClickEvents(@NonNull PlotFlag<?, ?> flag, @NonNull String miniMessageString) {
        if (MINI_MESSAGE_FLAGS.contains(flag.getClass())) {
            return CaptionUtility.stripClickEvents(miniMessageString);
        }
        return miniMessageString;
    }
}

