/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration;

import com.plotsquared.core.configuration.Config;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.event.ClickEvent;

public class Settings
extends Config {
    @Config.Comment(value={"This value is not configurable. It shows the platform you are using."})
    @Config.Final
    public static String PLATFORM;
    @Config.Comment(value={"Show additional information in console. It helps us at IntellectualSites to find out more about an issue.", "Leave it off if you don't need it, it can spam your console."})
    public static boolean DEBUG;
    @Config.Create
    public static Config.ConfigBlock<Auto_Clear> AUTO_CLEAR;

    public static void save(File file) {
        Settings.save(file, Settings.class);
    }

    public static void load(File file) {
        Settings.load(file, Settings.class);
    }

    public static boolean convertLegacy(File file) {
        if (!file.exists()) {
            return false;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration(file);
        Redstone.DISABLE_OFFLINE = config.getBoolean("protection.redstone.disable-offline");
        Redstone.DISABLE_UNOCCUPIED = config.getBoolean("protection.redstone.disable-unoccupied", Redstone.DISABLE_UNOCCUPIED);
        UUID.OFFLINE = config.getBoolean("UUID.offline", UUID.OFFLINE);
        UUID.FORCE_LOWERCASE = config.getBoolean("UUID.force-lowercase", UUID.FORCE_LOWERCASE);
        Enabled_Components.KILL_ROAD_MOBS = config.getBoolean("kill_road_mobs", Enabled_Components.KILL_ROAD_MOBS);
        Enabled_Components.KILL_ROAD_VEHICLES = config.getBoolean("kill_road_vehicles", Enabled_Components.KILL_ROAD_VEHICLES);
        if (Enabled_Components.PLOT_EXPIRY = config.getBoolean("clear.auto.enabled", Enabled_Components.PLOT_EXPIRY)) {
            Enabled_Components.BAN_DELETER = config.getBoolean("clear.on.ban");
            AUTO_CLEAR = new Config.ConfigBlock();
            AUTO_CLEAR.put("task1", new Auto_Clear());
            Auto_Clear task = AUTO_CLEAR.get("task1");
            task.CALIBRATION = new Auto_Clear.CALIBRATION();
            task.DAYS = config.getInt("clear.auto.days", task.DAYS);
            task.THRESHOLD = config.getInt("clear.auto.threshold", task.THRESHOLD);
            task.CONFIRMATION = config.getBoolean("clear.auto.confirmation", task.CONFIRMATION);
            task.CALIBRATION.CHANGES = config.getInt("clear.auto.calibration.changes", task.CALIBRATION.CHANGES);
            task.CALIBRATION.FACES = config.getInt("clear.auto.calibration.faces", task.CALIBRATION.FACES);
            task.CALIBRATION.DATA = config.getInt("clear.auto.calibration.data", task.CALIBRATION.DATA);
            task.CALIBRATION.AIR = config.getInt("clear.auto.calibration.air", task.CALIBRATION.AIR);
            task.CALIBRATION.VARIETY = config.getInt("clear.auto.calibration.variety", task.CALIBRATION.VARIETY);
            task.CALIBRATION.CHANGES_SD = config.getInt("clear.auto.calibration.changes_sd", task.CALIBRATION.CHANGES_SD);
            task.CALIBRATION.FACES_SD = config.getInt("clear.auto.calibration.faces_sd", task.CALIBRATION.FACES_SD);
            task.CALIBRATION.DATA_SD = config.getInt("clear.auto.calibration.data_sd", task.CALIBRATION.DATA_SD);
            task.CALIBRATION.AIR_SD = config.getInt("clear.auto.calibration.air_sd", task.CALIBRATION.AIR_SD);
            task.CALIBRATION.VARIETY_SD = config.getInt("clear.auto.calibration.variety_sd", task.CALIBRATION.VARIETY_SD);
        }
        Done.REQUIRED_FOR_RATINGS = config.getBoolean("approval.ratings.check-done", Done.REQUIRED_FOR_RATINGS);
        Done.COUNTS_TOWARDS_LIMIT = config.getBoolean("approval.done.counts-towards-limit", Done.COUNTS_TOWARDS_LIMIT);
        Done.RESTRICT_BUILDING = config.getBoolean("approval.done.restrict-building", Done.RESTRICT_BUILDING);
        Done.REQUIRED_FOR_DOWNLOAD = config.getBoolean("approval.done.required-for-download", Done.REQUIRED_FOR_DOWNLOAD);
        Paths.SCHEMATICS = config.getString("schematics.save_path", Paths.SCHEMATICS);
        Web.URL = config.getString("web.url", Web.URL);
        Enabled_Components.RATING_CACHE = config.getBoolean("cache.ratings", Enabled_Components.RATING_CACHE);
        Ratings.CATEGORIES = config.contains("ratings.categories") ? config.getStringList("ratings.categories") : Ratings.CATEGORIES;
        Enabled_Components.UPDATE_NOTIFICATIONS = config.getBoolean("update-notifications", Enabled_Components.UPDATE_NOTIFICATIONS);
        Teleport.DELAY = config.getInt("teleport.delay", Teleport.DELAY);
        Teleport.ON_LOGIN = config.getBoolean("teleport.on_login", Teleport.ON_LOGIN);
        Teleport.ON_DEATH = config.getBoolean("teleport.on_death", Teleport.ON_DEATH);
        Teleport.ON_CLEAR = config.getBoolean("teleport.on_clear", Teleport.ON_CLEAR);
        Teleport.ON_DELETE = config.getBoolean("teleport.on_delete", Teleport.ON_DELETE);
        Enabled_Components.CHUNK_PROCESSOR = config.getBoolean("chunk-processor.enabled", Enabled_Components.CHUNK_PROCESSOR);
        Chunk_Processor.AUTO_TRIM = config.getBoolean("chunk-processor.auto-unload", Chunk_Processor.AUTO_TRIM);
        Chunk_Processor.MAX_TILES = config.getInt("chunk-processor.max-blockstates", Chunk_Processor.MAX_TILES);
        Chunk_Processor.MAX_ENTITIES = config.getInt("chunk-processor.max-entities", Chunk_Processor.MAX_ENTITIES);
        Chunk_Processor.DISABLE_PHYSICS = config.getBoolean("chunk-processor.disable-physics", Chunk_Processor.DISABLE_PHYSICS);
        Enabled_Components.COMMENT_NOTIFIER = config.getBoolean("comments.notifications.enabled", Enabled_Components.COMMENT_NOTIFIER);
        Claim.MAX_AUTO_AREA = config.getInt("claim.max-auto-area", Claim.MAX_AUTO_AREA);
        Limit.MAX_PLOTS = config.getInt("max_plots", Limit.MAX_PLOTS);
        Limit.GLOBAL = config.getBoolean("global_limit", Limit.GLOBAL);
        DEBUG = config.getBoolean("debug", DEBUG);
        Enabled_Components.DATABASE_PURGER = config.getBoolean("auto-purge", Enabled_Components.DATABASE_PURGER);
        return true;
    }

    static {
        DEBUG = true;
        AUTO_CLEAR = null;
    }

    @Config.Comment(value={"Redstone related settings"})
    public static final class Redstone {
        @Config.Comment(value={"Disable redstone in unoccupied plots"})
        public static boolean DISABLE_UNOCCUPIED = false;
        @Config.Comment(value={"Disable redstone when all owners/trusted/members are offline"})
        public static boolean DISABLE_OFFLINE = false;
        @Config.Comment(value={"Detect and cancel invalid pistons on the edge of plots (e.g. placed with WorldEdit)"})
        public static boolean DETECT_INVALID_EDGE_PISTONS = false;
    }

    @Config.Comment(value={"UUID settings", "DO NOT EDIT them unless you know what you are doing."})
    public static class UUID {
        @Config.Comment(value={"Force using offline UUIDs (it usually detects the right mode)"})
        public static boolean OFFLINE = false;
        @Config.Comment(value={"Force using lowercase UUIDs"})
        public static boolean FORCE_LOWERCASE = false;
        @Config.Comment(value={"How many UUIDs that may be stored in the cache"})
        public static int UUID_CACHE_SIZE = 100000;
        @Config.Comment(value={"Rate limit (per 10 minutes) for background UUID fetching from the Mojang API"})
        public static int BACKGROUND_LIMIT = 200;
        @Config.Comment(value={"Whether the Mojang API service is enabled for impromptu api calls. If false only the Background task will use http requests to fill the UUID cache (requires restart)"})
        public static boolean IMPROMPTU_SERVICE_MOJANG_API = true;
        @Config.Comment(value={"Rate limit (per 10 minutes) for random UUID fetching from the Mojang API"})
        public static int IMPROMPTU_LIMIT = 300;
        @Config.Comment(value={"Timeout (in milliseconds) for non-blocking UUID requests (mostly commands)"})
        public static long NON_BLOCKING_TIMEOUT = 3000L;
        @Config.Comment(value={"Timeout (in milliseconds) for blocking UUID requests (events)"})
        public static long BLOCKING_TIMEOUT = 10L;
        @Config.Comment(value={"Whether or not PlotSquared should read from the legacy database"})
        public static boolean LEGACY_DATABASE_SUPPORT = true;
        @Config.Comment(value={"Whether or not PlotSquared should return Unknown if it fails to fulfill a request"})
        public static boolean UNKNOWN_AS_DEFAULT = true;
        @Config.Comment(value={"Whether or not automatic background caching should be enabled. It is HIGHLY recommended to keep this turned on. This should only be disabled if the server has a very large number of plots (>100k)"})
        public static boolean BACKGROUND_CACHING_ENABLED = true;
        @Config.Comment(value={"Whether the PaperMC service is enabled"})
        public static boolean SERVICE_PAPER = true;
        @Config.Comment(value={"Whether the LuckPerms service is enabled"})
        public static boolean SERVICE_LUCKPERMS = true;
        @Config.Comment(value={"Whether the Bukkit service is enabled"})
        public static boolean SERVICE_BUKKIT = true;
        @Config.Comment(value={"Whether the EssentialsX service is enabled"})
        public static boolean SERVICE_ESSENTIALSX = true;
    }

    @Config.Comment(value={"Enable or disable parts of the plugin", "Note: A cache will use some memory if enabled"})
    public static final class Enabled_Components {
        @Config.Comment(value={"The database stores all the plots"})
        public static boolean DATABASE = true;
        @Config.Comment(value={"Events are needed to track a lot of things"})
        public static boolean EVENTS = true;
        @Config.Comment(value={"Commands are used to interact with the plugin"})
        public static boolean COMMANDS = true;
        @Config.Comment(value={"Whether we should notify you about updates or not."})
        public static boolean UPDATE_NOTIFICATIONS = true;
        @Config.Comment(value={"Stores user metadata in a database"})
        public static boolean PERSISTENT_META = true;
        @Config.Comment(value={"Getting a rating won't need the database"})
        public static boolean RATING_CACHE = true;
        @Config.Comment(value={"Allow WorldEdit to be restricted to plots"})
        public static boolean WORLDEDIT_RESTRICTIONS = true;
        @Config.Comment(value={"Allow economy to be used to sell, claim or buy plots."})
        public static boolean ECONOMY = false;
        @Config.Comment(value={"Expiry will clear old or simplistic plots"})
        public static boolean PLOT_EXPIRY = false;
        @Config.Comment(value={"Processes chunks (trimming, or entity/tile limits) "})
        public static boolean CHUNK_PROCESSOR = false;
        @Config.Comment(value={"Kill mobs on roads (Chicken, Cow, etc.)"})
        public static boolean KILL_ROAD_MOBS = false;
        @Config.Comment(value={"Also kill any road mobs that are being ridden, or are leashed"})
        public static boolean KILL_OWNED_ROAD_MOBS = false;
        @Config.Comment(value={"Also kill any road mobs that are named"})
        public static boolean KILL_NAMED_ROAD_MOBS = false;
        @Config.Comment(value={"Kill items on roads (Stick, Paper, etc.)"})
        public static boolean KILL_ROAD_ITEMS = false;
        @Config.Comment(value={"Kill vehicles on roads (Boat, Minecart, etc.)"})
        public static boolean KILL_ROAD_VEHICLES = false;
        @Config.Comment(value={"Notify a player of any missed plot comments upon plot entry"})
        public static boolean COMMENT_NOTIFIER = true;
        @Config.Comment(value={"Let players claim entire worlds with PlotSquared"})
        public static boolean WORLDS = false;
        @Config.Comment(value={"Actively purge invalid database entries"})
        public static boolean DATABASE_PURGER = false;
        @Config.Comment(value={"Delete plots when a player is banned.", "Note: This only works with the /minecraft:ban command. Any punishment plugin is not supported."})
        public static boolean BAN_DELETER = false;
        @Config.Comment(value={"Allows PlaceholderAPI placeholders to be used in captions, flags, etc."})
        public static boolean EXTERNAL_PLACEHOLDERS = true;
        @Config.Comment(value={"Make road regeneration persistent across restarts"})
        public static boolean PERSISTENT_ROAD_REGEN = true;
        @Config.Comment(value={"Enable the `/plot component` preset GUI", "Read more about components here: https://intellectualsites.gitbook.io/plotsquared/customization/plot-components"})
        public static boolean COMPONENT_PRESETS = true;
        @Config.Comment(value={"Enable per user locale"})
        public static boolean PER_USER_LOCALE = false;
        @Config.Comment(value={"The default locale. Before changing the language, make sure you downloaded the appropriate file and put it in the 'lang' folder.", "You can find additional translations here: https://intellectualsites.crowdin.com/plotsquared"})
        public static String DEFAULT_LOCALE = "en";
        @Config.Comment(value={"Use UUID cache to complete usernames"})
        public static boolean EXTENDED_USERNAME_COMPLETION = true;
        @Config.Comment(value={"Command aliases that will be tab completed"})
        public static List<String> TAB_COMPLETED_ALIASES = Arrays.asList("plot", "plots", "p", "plotsquared", "plot2", "p2", "ps", "2", "plotme", "plotz", "ap");
        @Config.Comment(value={"Whether PlotSquared should hook into MvDWPlaceholderAPI or not"})
        public static boolean USE_MVDWAPI = true;
        @Config.Comment(value={"Prevent cross plot beacon effects"})
        public static boolean DISABLE_BEACON_EFFECT_OVERFLOW = true;
    }

    @Config.Comment(value={"This is an auto clearing task called `task1`"})
    @Config.BlockName(value={"task1"})
    public static final class Auto_Clear
    extends Config.ConfigBlock {
        @Config.Create
        public CALIBRATION CALIBRATION = null;
        public int THRESHOLD = -1;
        public int REQUIRED_PLOTS = -1;
        public boolean CONFIRMATION = true;
        public int DAYS = 90;
        public int SKIP_ACCOUNT_AGE_DAYS = -1;
        @Config.Comment(value={"True, if a plot should be deleted if the plot owner is unknown to the server"})
        public boolean DELETE_IF_OWNER_IS_UNKNOWN = false;
        public List<String> WORLDS = new ArrayList<String>(Collections.singletonList("*"));

        @Config.Comment(value={"See: https://intellectualsites.gitbook.io/plotsquared/optimization/plot-analysis for a description of each value."})
        public static final class CALIBRATION {
            public int VARIETY = 0;
            public int VARIETY_SD = 0;
            public int CHANGES = 0;
            public int CHANGES_SD = 1;
            public int FACES = 0;
            public int FACES_SD = 0;
            public int DATA_SD = 0;
            public int AIR = 0;
            public int AIR_SD = 0;
            public int DATA = 0;
        }
    }

    @Config.Comment(value={"Miscellaneous settings"})
    public static final class Done {
        @Config.Comment(value={"Require a plot marked as done to download (/plot download)"})
        public static boolean REQUIRED_FOR_DOWNLOAD = false;
        @Config.Comment(value={"Only plots marked as done can be rated"})
        public static boolean REQUIRED_FOR_RATINGS = false;
        @Config.Comment(value={"Restrict building when a plot is marked as done"})
        public static boolean RESTRICT_BUILDING = false;
        @Config.Comment(value={"The limit being how many plots a player can claim"})
        public static boolean COUNTS_TOWARDS_LIMIT = true;
    }

    @Config.Comment(value={"Configure the paths that will be used"})
    public static final class Paths {
        public static String SCHEMATICS = "schematics";
        public static String TEMPLATES = "templates";
    }

    @Deprecated(forRemoval=true, since="6.0.0")
    @Config.Comment(value={"Schematic interface related settings"})
    public static class Web {
        @Config.Comment(value={"The web interface for schematics", " - All schematics are anonymous and private", " - Downloads can be deleted by the user", " - Supports plot uploads, downloads and saves"})
        public static String URL = "https://schem.intellectualsites.com/plots/";
        @Config.Comment(value={"Whether or not the legacy web interface will be used for /plot download and /plot save", "Note that this will be removed in future versions. Updating to Arkitektonika is highly suggested"})
        public static boolean LEGACY_WEBINTERFACE = false;
    }

    @Config.Comment(value={"Rating related settings"})
    public static final class Ratings {
        @Config.Comment(value={"Replace the rating system with a like system. Will add /plot like/dislike, and remove the rating command"})
        public static boolean USE_LIKES = false;
        @Config.Comment(value={"Rating categories"})
        public static List<String> CATEGORIES = new ArrayList<String>();
        @Config.Comment(value={"The blocks to use for the rating GUI if categories are set above"})
        public static String BLOCK_0 = "brown_wool";
        public static String BLOCK_1 = "red_wool";
        public static String BLOCK_2 = "orange_wool";
        public static String BLOCK_3 = "yellow_wool";
        public static String BLOCK_4 = "lime_wool";
        public static String BLOCK_5 = "cyan_wool";
        public static String BLOCK_6 = "blue_wool";
        public static String BLOCK_7 = "purple_wool";
        public static String BLOCK_8 = "magenta_wool";
    }

    @Config.Comment(value={"Teleportation related settings"})
    public static final class Teleport {
        @Config.Comment(value={"Teleport to your plot on death"})
        public static boolean ON_DEATH = false;
        @Config.Comment(value={"Teleport to your plot on login"})
        public static boolean ON_LOGIN = false;
        @Config.Comment(value={"Teleport to your plot on claim (/plot claim)"})
        public static boolean ON_CLAIM = true;
        @Config.Comment(value={"Teleport to your plot on auto (/plot auto)"})
        public static boolean ON_AUTO = true;
        @Config.Comment(value={"Add a delay to all teleport commands (in seconds)", "Assign `plots.teleport.delay.bypass` to bypass the cooldown"})
        public static int DELAY = 0;
        @Config.Comment(value={"Teleport outside of the plot before clearing"})
        public static boolean ON_CLEAR = false;
        @Config.Comment(value={"Teleport outside of the plot before deleting"})
        public static boolean ON_DELETE = false;
        @Config.Comment(value={"The visit command is ordered by world instead of globally"})
        public static boolean PER_WORLD_VISIT = false;
        @Config.Comment(value={"Search merged plots for having multiple owners when using the visit command"})
        public static boolean VISIT_MERGED_OWNERS = true;
    }

    @Config.Comment(value={"Chunk processor related settings", "See https://intellectualsites.gitbook.io/plotsquared/optimization/chunk-processor for more information."})
    public static class Chunk_Processor {
        @Config.Comment(value={"Auto trim will not save chunks which aren't claimed"})
        public static boolean AUTO_TRIM = false;
        @Config.Comment(value={"Max tile entities per chunk"})
        public static int MAX_TILES = 4096;
        @Config.Comment(value={"Max entities per chunk"})
        public static int MAX_ENTITIES = 512;
        @Config.Comment(value={"Disable block physics"})
        public static boolean DISABLE_PHYSICS = false;
    }

    @Config.Comment(value={"Claim related settings"})
    public static final class Claim {
        @Config.Comment(value={"The max plots claimed in a single `/plot auto <size>` command"})
        public static int MAX_AUTO_AREA = 4;
    }

    @Config.Comment(value={"Relating to how many plots someone can claim"})
    public static final class Limit {
        @Config.Comment(value={"Should the limit be global (over multiple worlds)"})
        public static boolean GLOBAL = false;
        @Config.Comment(value={"The max range of permissions to check for, e.g. plots.plot.127", "The value covers the permission range to check, you need to assign the permission to players/groups still", "Modifying the value does NOT change the amount of plots players can claim"})
        public static int MAX_PLOTS = 127;
    }

    @Config.Comment(value={"Settings related to plot titles"})
    public static final class Titles {
        @Config.Comment(value={"The big text that appears when you enter a plot.", "For a single plot set `/plot flag set titles false` to disable it.", "For just you run `/plot toggle titles` to disable it.", "For all plots: Add `titles: false` in the worlds.yml flags block to disable it."})
        public static boolean DISPLAY_TITLES = true;
        @Config.Comment(value={"Plot titles fading in (duration in ticks)"})
        public static int TITLES_FADE_IN = 10;
        @Config.Comment(value={"Plot titles being shown (duration in ticks)"})
        public static int TITLES_STAY = 50;
        @Config.Comment(value={"Plot titles fading out (duration in ticks)"})
        public static int TITLES_FADE_OUT = 20;
        @Config.Comment(value={"Changes the notification method on plot entry from Title + SubTitle -> ActionBar.", "The message still sent to the player is pulled from the lang key \"titles.title_entered_plot\".", "If you would like to still show the owner of the plot, append the contents of \"titles.title_entered_plot_sub\" onto the former lang key."})
        public static boolean TITLES_AS_ACTIONBAR = false;
        @Config.Comment(value={"If the default title should be displayed on plots with server-plot flag set.", "Titles will still be sent if the plot-title flag is set."})
        public static boolean DISPLAY_DEFAULT_ON_SERVER_PLOT = false;
    }

    @Config.Comment(value={"Settings related to tab completion"})
    public static final class Tab_Completions {
        @Config.Comment(value={"The time in seconds how long tab completions should remain in cache.", "0 will disable caching. Lower values may be less performant."})
        public static int CACHE_EXPIRATION = 15;
    }

    @Config.Comment(value={"Settings relating to PlotSquared's GlobalBlockQueue"})
    public static final class QUEUE {
        @Config.Comment(value={"Average time per tick spent completing chunk tasks in ms.", "Queue will adjust the batch size to match this."})
        public static int MAX_ITERATION_TIME = 30;
        @Config.Comment(value={"Initial number of chunks to process by the queue. This can be increased or", "decreased by the queue based on the actual iteration time compared to above."})
        public static int INITIAL_BATCH_SIZE = 5;
        @Config.Comment(value={"Notify progress of the queue to the player or console."})
        public static boolean NOTIFY_PROGRESS = true;
        @Config.Comment(value={"Interval in ms to notify player or console of progress."})
        public static int NOTIFY_INTERVAL = 5000;
        @Config.Comment(value={"Time to wait in ms before beginning to notify player or console of progress.", "Prevent needless notification of progress for short queues."})
        public static int NOTIFY_WAIT = 5000;
        @Config.Comment(value={"How lighting should be handled by the queue. Modes:", "  - 0 - Do not do any lighting (fastest)", "  - 1 - Only execute lighting where blocks with light values are placed", "  - 2 - Only execute lighting where blocks with light values are placed or removed/replaced", "  - 3 - Always execute lighting (slowest)"})
        public static int LIGHTING_MODE = 1;
        @Config.Comment(value={"If blocks at the edges of queued operations should be set causing updates", " - Slightly slower, but prevents issues such as fences left connected to nothing"})
        public static boolean UPDATE_EDGES = true;
    }

    @Config.Comment(value={"Enable or disable parts of the plugin specific to using Paper"})
    public static final class Paper_Components {
        @Config.Comment(value={"Enable Paper's listeners."})
        public static boolean PAPER_LISTENERS = true;
        @Config.Comment(value={"Prevent entities from leaving plots"})
        public static boolean ENTITY_PATHING = true;
        @Config.Comment(value={"Cancel entity spawns when the chunk is loaded if the PlotArea's mob spawning is off"})
        public static boolean CANCEL_CHUNK_SPAWN = true;
        @Config.Comment(value={"Use paper's PlayerLaunchProjectileEvent to cancel projectiles"})
        public static boolean PLAYER_PROJECTILE = true;
        @Config.Comment(value={"Cancel entity spawns from spawners before they happen (performance buff)"})
        public static boolean SPAWNER_SPAWN = true;
        @Config.Comment(value={"Cancel entity spawns from tick spawn rates before they happen (performance buff)"})
        public static boolean CREATURE_SPAWN = true;
        @Config.Comment(value={"Check the tile entity limit on block placement"})
        public static boolean TILE_ENTITY_CHECK = true;
        @Config.Comment(value={"Use Paper's async tab completion"})
        public static boolean ASYNC_TAB_COMPLETION;
    }

    @Config.Comment(value={"Enable or disable all of or parts of the FastAsyncWorldEdit-PlotSquared hook"})
    public static final class FAWE_Components {
        @Config.Comment(value={"Use FastAsyncWorldEdit for queue handling."})
        public static boolean FAWE_HOOK = true;
        public static boolean CUBOIDS = true;
        public static boolean CLEAR = true;
        public static boolean COPY_AND_SWAP = true;
        public static boolean SET_BIOME = true;
    }

    @Config.Comment(value={"Confirmation timeout related settings"})
    public static final class Confirmation {
        @Config.Comment(value={"Timeout before a confirmation prompt expires"})
        public static int CONFIRMATION_TIMEOUT_SECONDS = 20;
    }

    @Config.Comment(value={"Backup related settings", "See https://intellectualsites.gitbook.io/plotsquared/plot-backups for more information."})
    public static final class Backup {
        @Config.Comment(value={"Automatically backup plots when destructive commands are performed, e.g. /plot clear"})
        public static boolean AUTOMATIC_BACKUPS = true;
        @Config.Comment(value={"Maximum amount of backups associated with a plot"})
        public static int BACKUP_LIMIT = 3;
        @Config.Comment(value={"Whether or not backups should be deleted when the plot is unclaimed"})
        public static boolean DELETE_ON_UNCLAIM = true;
    }

    @Config.Comment(value={"Chat related settings"})
    public static final class Chat {
        @Config.Comment(value={"Should the plot chat be logged to console?"})
        public static boolean LOG_PLOTCHAT_TO_CONSOLE = true;
        @Config.Comment(value={"Whether an action bar message should be send over a chat message for notification purposes such for the ", "notify-enter, notify-leave, greeting or farewell flag."})
        public static boolean NOTIFICATION_AS_ACTIONBAR = false;
        @Config.Comment(value={"The click event actions that should be removed from user input in e.g. plot flags like 'greeting'.", "Actions like 'RUN_COMMAND' may be used maliciously as players could trick staff into clicking on messages", "triggering destructive commands."})
        public static List<String> CLICK_EVENT_ACTIONS_TO_REMOVE = Arrays.stream(ClickEvent.Action.values()).map(Enum::name).collect(Collectors.toList());
    }

    @Config.Comment(value={"Used to format the plot creation date placeholder. Modifying the format does not affect the storage time."})
    public static class Timeformat {
        @Config.Comment(value={"The date used formatted in ISO 8601"})
        public static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss z";
        @Config.Comment(value={"The time zone used"})
        public static String TIME_ZONE = "GMT";
    }

    @Config.Comment(value={"Schematic web interface related settings"})
    public static class Arkitektonika {
        @Config.Comment(value={"The url of the backend server (Arkitektonika)"})
        public static String BACKEND_URL = "https://api.schematic.cloud/";
        @Config.Comment(value={"The url used to generate a download link from.", "{key} will be replaced with the generated key"})
        public static String DOWNLOAD_URL = "https://api.schematic.cloud/download/{key}";
        @Config.Comment(value={"The url used to generate a deletion link from.", "{key} will be replaced with the generated key"})
        public static String DELETE_URL = "https://api.schematic.cloud/delete/{key}";
    }

    @Config.Comment(value={"Schematic Settings", "See https://intellectualsites.gitbook.io/plotsquared/schematics/schematic-on-claim for more information."})
    public static final class Schematics {
        @Config.Comment(value={"Whether schematic based generation should paste schematic on top of plots, or from Y=1"})
        public static boolean PASTE_ON_TOP = true;
        @Config.Comment(value={"Whether schematic based road generation should paste schematic on top of roads, or from Y=1"})
        public static boolean PASTE_ROAD_ON_TOP = true;
        @Config.Comment(value={"If schematics that do not match a plot's size should be pasted anyway", " - This will still only paste a schematic with a plot's bounds.", " - If a schematic is too big, it will cut off, and if too small, will not full the plot."})
        public static boolean PASTE_MISMATCHES = true;
        @Config.Comment(value={"If the wall height should be taken into account when calculating the road schematic paste height", " - If true, will use the lower of wall and road height.", " - If true, will ensure correct schematic behaviour (no parts are cut off).", " - Set to false if you experience the road being set one block too low", "   (only for road schematics created pre 6.1.4)."})
        public static boolean USE_WALL_IN_ROAD_SCHEM_HEIGHT = true;
    }

    @Config.Comment(value={"Update checker settings"})
    public static final class UpdateChecker {
        @Config.Comment(value={"How often to poll for updates (in minutes)"})
        public static int POLL_RATE = 360;
        @Config.Comment(value={"Only notify console once after an update is found"})
        public static boolean NOTIFY_ONCE = true;
    }

    @Config.Comment(value={"General settings"})
    public static final class General {
        @Config.Comment(value={"Display scientific numbers (4.2E8)"})
        public static boolean SCIENTIFIC = false;
        @Config.Comment(value={"Replace wall when merging"})
        public static boolean MERGE_REPLACE_WALL = true;
        @Config.Comment(value={"Always show explosion Particles, even if explosion flag is set to false"})
        public static boolean ALWAYS_SHOW_EXPLOSIONS = false;
        @Config.Comment(value={"Blocks that may not be used in plot components", "Checkout the wiki article regarding plot components before modifying: https://intellectualsites.gitbook.io/plotsquared/customization/plot-components"})
        public static List<String> INVALID_BLOCKS = Arrays.asList("acacia_button", "acacia_fence_gate", "acacia_door", "acacia_pressure_plate", "acacia_trapdoor", "acacia_sapling", "acacia_sign", "acacia_wall_sign", "acacia_leaves", "birch_button", "birch_fence_gate", "birch_door", "birch_pressure_plate", "birch_trapdoor", "birch_sapling", "birch_sign", "birch_wall_sign", "birch_leaves", "dark_oak_button", "dark_oak_fence_gate", "dark_oak_door", "dark_oak_pressure_plate", "dark_oak_trapdoor", "dark_oak_sapling", "dark_oak_sign", "dark_oak_wall_sign", "dark_oak_leaves", "jungle_button", "jungle_fence_gate", "jungle_door", "jungle_pressure_plate", "jungle_trapdoor", "jungle_sapling", "jungle_sign", "jungle_wall_sign", "jungle_leaves", "oak_button", "oak_fence_gate", "oak_door", "oak_pressure_plate", "oak_trapdoor", "oak_sapling", "oak_sign", "oak_wall_sign", "oak_leaves", "spruce_button", "spruce_fence_gate", "spruce_door", "spruce_pressure_plate", "spruce_trapdoor", "spruce_sapling", "spruce_sign", "spruce_wall_sign", "spruce_leaves", "activator_rail", "detector_rail", "rail", "allium", "azure_bluet", "blue_orchid", "dandelion", "lilac", "orange_tulip", "oxeye_daisy", "peony", "pink_tulip", "poppy", "potted_allium", "potted_azure_bluet", "potted_birch_sapling", "potted_blue_orchid", "potted_brown_mushroom", "potted_cactus", "potted_fern", "potted_jungle_sapling", "potted_oak_sapling", "potted_orange_tulip", "potted_oxeye_daisy", "potted_pink_tulip", "potted_red_mushroom", "potted_red_tulip", "red_mushroom", "red_tulip", "potted_spruce_sapling", "potted_white_tulip", "rose_bush", "sunflower", "white_tulip", "cornflower", "wither_rose", "attached_melon_stem", "attached_pumpkin_stem", "melon_stem", "pumpkin_stem", "mushroom_stem", "beetroots", "brown_mushroom", "cactus", "carrots", "chorus_flower", "chorus_plant", "cocoa", "dead_bush", "fern", "kelp_plant", "large_fern", "lily_pad", "potatoes", "sea_pickle", "seagrass", "sugar_cane", "tall_grass", "tall_seagrass", "vine", "wheat", "bamboo", "anvil", "barrier", "beacon", "brewing_stand", "bubble_column", "cake", "cobweb", "comparator", "creeper_head", "creeper_wall_header", "damaged_anvil", "daylight_detector", "dragon_egg", "dragon_head", "dragon_wall_head", "enchanting_table", "end_gateway", "end_portal", "end_rod", "ender_chest", "chest", "flower_pot", "grass", "heavy_weighted_pressure_plate", "lever", "light_weighted_pressure_plate", "player_head", "redstone_wire", "repeater", "comparator", "redstone_torch", "torch", "redstone_wall_torch", "wall_torch", "sign", "skeleton_skull", "skeleton_wall_skull", "snow", "stone_pressure_plate", "trapped_chest", "tripwire", "tripwire_hook", "turtle_egg", "wall_sign", "zombie_head", "zombie_wall_head", "bell", "black_bed", "black_banner", "black_carpet", "black_concrete_powder", "black_wall_banner", "blue_bed", "blue_banner", "blue_carpet", "blue_concrete_powder", "blue_wall_banner", "brown_bed", "brown_banner", "brown_carpet", "brown_concrete_powder", "brown_wall_banner", "cyan_bed", "cyan_banner", "cyan_concrete_powder", "cyan_carpet", "cyan_wall_banner", "gray_bed", "gray_banner", "gray_concrete_powder", "gray_carpet", "gray_wall_banner", "green_bed", "green_banner", "green_concrete_powder", "green_carpet", "green_wall_banner", "light_blue_bed", "light_blue_banner", "light_blue_concrete_powder", "light_blue_carpet", "light_blue_wall_banner", "light_gray_bed", "light_gray_banner", "light_gray_concrete_powder", "light_gray_carpet", "light_gray_wall_banner", "lime_bed", "lime_banner", "lime_concrete_powder", "lime_carpet", "lime_wall_banner", "magenta_bed", "magenta_banner", "magenta_concrete_powder", "magenta_carpet", "magenta_wall_banner", "orange_bed", "orange_banner", "orange_concrete_powder", "orange_carpet", "orange_wall_banner", "pink_bed", "pink_banner", "pink_concrete_powder", "pink_carpet", "pink_wall_banner", "purple_bed", "purple_banner", "purple_concrete_powder", "purple_carpet", "purple_wall_banner", "red_bed", "red_banner", "red_concrete_powder", "red_carpet", "red_wall_banner", "white_bed", "white_banner", "white_concrete_powder", "white_carpet", "white_wall_banner", "yellow_bed", "yellow_banner", "yellow_concrete_powder", "yellow_carpet", "yellow_wall_banner", "brain_coral", "brain_coral_fan", "brain_coral_wall_fan", "bubble_coral", "bubble_coral_block", "bubble_coral_fan", "bubble_coral_wall_fan", "dead_brain_coral", "dead_brain_coral_block", "dead_brain_coral_fan", "dead_brain_coral_wall_fan", "dead_bubble_coral", "dead_bubble_coral_fan", "dead_bubble_coral_wall_fan", "dead_fire_coral", "dead_fire_coral_block", "dead_fire_coral_fan", "dead_fire_coral_wall_fan", "dead_horn_coral", "dead_horn_coral_block", "dead_horn_coral_fan", "dead_tube_coral", "dead_tube_coral_wall_fan", "dried_kelp_block", "horn_coral", "horn_coral_block", "horn_coral_fan", "horn_coral_wall_fan", "tube_coral", "tube_coral_block", "tube_coral_fan", "tube_coral_wall_fan");
    }
}

