/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.UntrustedVisitFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.query.SortingStrategy;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="visit", permission="plots.visit", usage="/plot visit <player> | <alias> | <plot> [area]|[#] [#]", aliases={"v", "tp", "teleport", "goto", "warp"}, requiredType=RequiredType.PLAYER, category=CommandCategory.TELEPORT)
public class Visit
extends Command {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public Visit(@NonNull PlotAreaManager plotAreaManager) {
        super(MainCommand.getInstance(), true);
        this.plotAreaManager = plotAreaManager;
    }

    private void visit(@NonNull PlotPlayer<?> player, @NonNull PlotQuery query, PlotArea sortByArea, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone, int page) {
        List<Plot> unsorted = query.asList();
        if (unsorted.size() > 1) {
            query.whereBasePlot();
        }
        if (page == Integer.MIN_VALUE) {
            page = 1;
        }
        PlotArea relativeArea = sortByArea;
        if (Settings.Teleport.PER_WORLD_VISIT && sortByArea == null) {
            relativeArea = player.getApplicablePlotArea();
        }
        if (relativeArea != null) {
            query.relativeToArea(relativeArea).withSortingStrategy(SortingStrategy.SORT_BY_CREATION);
        } else {
            query.withSortingStrategy(SortingStrategy.SORT_BY_TEMP);
        }
        List<Plot> plots = query.asList();
        if (plots.isEmpty()) {
            player.sendMessage(TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
            return;
        }
        if (plots.size() < page || page < 1) {
            player.sendMessage(TranslatableCaption.of("invalid.number_not_in_range"), TagResolver.builder().tag("min", Tag.inserting((Component)Component.text((int)1))).tag("max", Tag.inserting((Component)Component.text((int)plots.size()))).build());
            return;
        }
        Plot plot = plots.get(page - 1);
        if (!plot.hasOwner()) {
            if (!player.hasPermission(Permission.PERMISSION_VISIT_UNOWNED)) {
                player.sendMessage(TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.visit.unowned")))});
                return;
            }
        } else if (plot.isOwner(player.getUUID())) {
            if (!player.hasPermission(Permission.PERMISSION_VISIT_OWNED) && !player.hasPermission(Permission.PERMISSION_HOME)) {
                player.sendMessage(TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.visit.owned")))});
                return;
            }
        } else if (plot.isAdded(player.getUUID())) {
            if (!player.hasPermission(Permission.PERMISSION_SHARED)) {
                player.sendMessage(TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.visit.shared")))});
                return;
            }
        } else {
            if (!(((Boolean)plot.getFlag(UntrustedVisitFlag.class)).booleanValue() || player.hasPermission(Permission.PERMISSION_VISIT_OTHER) || player.hasPermission(Permission.PERMISSION_ADMIN_VISIT_UNTRUSTED))) {
                player.sendMessage(TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)"plots.visit.other")))});
                return;
            }
            if (plot.isDenied(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_VISIT_DENIED)) {
                player.sendMessage(TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((ComponentLike)Permission.PERMISSION_VISIT_DENIED))});
                return;
            }
        }
        confirm.run(this, () -> plot.teleportPlayer(player, TeleportCause.COMMAND_VISIT, result -> {
            if (result.booleanValue()) {
                whenDone.run(this, Command.CommandResult.SUCCESS);
            } else {
                whenDone.run(this, Command.CommandResult.FAILURE);
            }
        }), () -> whenDone.run(this, Command.CommandResult.FAILURE));
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        if (args.length > 3) {
            this.sendUsage(player);
            return CompletableFuture.completedFuture(false);
        }
        if (args.length == 1 && args[0].contains(":")) {
            args = args[0].split(":");
        }
        int page = Integer.MIN_VALUE;
        switch (args.length) {
            case 3: {
                if (!MathMan.isInteger(args[2])) {
                    player.sendMessage(TranslatableCaption.of("invalid.not_valid_number"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"(1, \u221e)")))});
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)this.getUsage())))});
                    return CompletableFuture.completedFuture(false);
                }
                page = Integer.parseInt(args[2]);
            }
            case 2: {
                if (page != Integer.MIN_VALUE || !MathMan.isInteger(args[1])) {
                    PlotArea sortByArea = this.plotAreaManager.getPlotAreaByString(args[1]);
                    if (sortByArea == null) {
                        player.sendMessage(TranslatableCaption.of("invalid.not_valid_number"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"(1, \u221e)")))});
                        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)this.getUsage())))});
                        return CompletableFuture.completedFuture(false);
                    }
                    PlotArea finalSortByArea = sortByArea;
                    int finalPage1 = page;
                    PlayerManager.getUUIDsFromString(args[0], (uuids, throwable) -> {
                        if (throwable instanceof TimeoutException) {
                            player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                        } else if (throwable != null || uuids.size() != 1) {
                            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)this.getUsage())))});
                        } else {
                            UUID uuid = uuids.toArray(new UUID[0])[0];
                            PlotQuery query = PlotQuery.newQuery();
                            if (Settings.Teleport.VISIT_MERGED_OWNERS) {
                                query.whereBasePlot().ownersInclude(uuid);
                            } else {
                                query.whereBasePlot().ownedBy(uuid);
                            }
                            this.visit(player, query, finalSortByArea, confirm, whenDone, finalPage1);
                        }
                    });
                    break;
                }
                try {
                    page = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException ignored) {
                    player.sendMessage(TranslatableCaption.of("invalid.not_a_number"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                    return CompletableFuture.completedFuture(false);
                }
            }
            case 1: {
                String[] finalArgs = args;
                int finalPage = page;
                if (args[0].length() >= 2 && !args[0].contains(";") && !args[0].contains(",")) {
                    PlotSquared.get().getImpromptuUUIDPipeline().getSingle(args[0], (uuid, throwable) -> {
                        if (throwable instanceof TimeoutException) {
                            player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                        } else if (uuid != null && (Settings.Teleport.VISIT_MERGED_OWNERS ? !PlotQuery.newQuery().ownersInclude((UUID)uuid).anyMatch() : !PlotQuery.newQuery().ownedBy((UUID)uuid).anyMatch())) {
                            player.sendMessage(TranslatableCaption.of("errors.player_no_plots"), new TagResolver[0]);
                        } else if (uuid == null) {
                            if (finalPage == Integer.MIN_VALUE) {
                                this.visit(player, PlotQuery.newQuery().withAlias(finalArgs[0]), player.getApplicablePlotArea(), confirm, whenDone, 1);
                            } else {
                                player.sendMessage(TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)finalArgs[0])))});
                            }
                        } else {
                            this.visit(player, Settings.Teleport.VISIT_MERGED_OWNERS ? PlotQuery.newQuery().ownersInclude((UUID)uuid).whereBasePlot() : PlotQuery.newQuery().ownedBy((UUID)uuid).whereBasePlot(), null, confirm, whenDone, finalPage);
                        }
                    });
                    break;
                }
                Plot plot = Plot.getPlotFromString(player, finalArgs[0], true);
                if (plot == null) break;
                this.visit(player, PlotQuery.newQuery().withPlot(plot), null, confirm, whenDone, 1);
                break;
            }
            case 0: {
                player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)this.getUsage())))});
                return CompletableFuture.completedFuture(false);
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        ArrayList<Command> completions = new ArrayList<Command>();
        switch (args.length - 1) {
            case 0: {
                completions.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
                break;
            }
            case 1: {
                completions.addAll(TabCompletions.completeAreas(args[1]));
                if (args[1].isEmpty()) {
                    completions.addAll(TabCompletions.asCompletions("1", "2", "3"));
                    break;
                }
                completions.addAll(TabCompletions.completeNumbers(args[1], 10, 999));
                break;
            }
            case 2: {
                if (args[2].isEmpty()) {
                    completions.addAll(TabCompletions.asCompletions("1", "2", "3"));
                    break;
                }
                completions.addAll(TabCompletions.completeNumbers(args[2], 10, 999));
            }
        }
        return completions;
    }
}

