/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@CommandDeclaration(command="target", usage="/plot target <<X;Z> | nearest>", permission="plots.target", requiredType=RequiredType.PLAYER, category=CommandCategory.INFO)
public class Target
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocation();
        if (!location.isPlotArea()) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
            return false;
        }
        if (args.length == 0) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot target <<X;Z> | nearest>")))});
            return false;
        }
        Plot target = null;
        if (StringMan.isEqualIgnoreCaseToAny(args[0], "near", "nearest")) {
            int distance = Integer.MAX_VALUE;
            for (Plot plot : PlotQuery.newQuery().inWorld(location.getWorldName())) {
                double current = plot.getCenterSynchronous().getEuclideanDistanceSquared(location);
                if (!(current < (double)distance)) continue;
                distance = (int)current;
                target = plot;
            }
            if (target == null) {
                player.sendMessage(TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
                return false;
            }
        } else {
            target = Plot.getPlotFromString(player, args[0], true);
            if (target == null) {
                return false;
            }
        }
        target.getCenter(player::setCompassTarget);
        player.sendMessage(TranslatableCaption.of("compass.compass_target"), new TagResolver[]{TagResolver.resolver((String)"target", (Tag)Tag.inserting((Component)Component.text((String)target.toString())))});
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return Stream.of("<X;Z>", "nearest").filter(value -> value.startsWith(args[0].toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, (String)value, "plots.target", RequiredType.PLAYER, null){}).collect(Collectors.toList());
    }
}

