/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.world.PlotAreaManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="regenallroads", aliases={"rgar"}, usage="/plot regenallroads <world> [height]", category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.CONSOLE, permission="plots.regenallroads")
public class RegenAllRoads
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final HybridUtils hybridUtils;

    @Inject
    public RegenAllRoads(@NonNull PlotAreaManager plotAreaManager, @NonNull HybridUtils hybridUtils) {
        this.plotAreaManager = plotAreaManager;
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        int height = 0;
        if (args.length == 2) {
            try {
                height = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ignored) {
                player.sendMessage(TranslatableCaption.of("invalid.not_valid_number"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"(0, 256)")))});
                player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot regenallroads <world> [height]")))});
                return false;
            }
        } else if (args.length != 1) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot regenallroads <world> [height]")))});
            return false;
        }
        PlotArea area = this.plotAreaManager.getPlotAreaByString(args[0]);
        if (area == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_valid_plot_world"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[0])))});
            return false;
        }
        PlotManager manager = area.getPlotManager();
        if (!(manager instanceof HybridPlotManager)) {
            player.sendMessage(TranslatableCaption.of("errors.invalid_plot_world"), new TagResolver[0]);
            return false;
        }
        player.sendMessage(TranslatableCaption.of("debugroadregen.schematic"), new TagResolver[]{TagResolver.resolver((String)"command", (Tag)Tag.inserting((Component)Component.text((String)"/plot createroadschematic")))});
        player.sendMessage(TranslatableCaption.of("debugroadregen.regenallroads_started"), new TagResolver[0]);
        boolean result = this.hybridUtils.scheduleRoadUpdate(area, height);
        if (!result) {
            player.sendMessage(TranslatableCaption.of("debugexec.mass_schematic_update_in_progress"), new TagResolver[0]);
            return false;
        }
        return true;
    }
}

