/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.TypeLiteral;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.comment.CommentInbox;
import com.plotsquared.core.plot.comment.CommentManager;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.RunnableVal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@CommandDeclaration(command="inbox", usage="/plot inbox [inbox] [delete <index> | clear | page]", permission="plots.inbox", category=CommandCategory.CHAT, requiredType=RequiredType.PLAYER)
public class Inbox
extends SubCommand {
    public void displayComments(PlotPlayer<?> player, List<PlotComment> oldComments, int page) {
        int max;
        int totalPages;
        if (oldComments == null || oldComments.isEmpty()) {
            player.sendMessage(TranslatableCaption.of("comment.inbox_empty"), new TagResolver[0]);
            return;
        }
        PlotComment[] comments = oldComments.toArray(new PlotComment[0]);
        if (page < 0) {
            page = 0;
        }
        if (page > (totalPages = (int)Math.ceil(comments.length / 12))) {
            page = totalPages;
        }
        if ((max = page * 12 + 12) > comments.length) {
            max = comments.length;
        }
        TextComponent.Builder builder = Component.text();
        builder.append(MINI_MESSAGE.deserialize(TranslatableCaption.of("list.comment_list_header_paged").getComponent(player) + "\n", TagResolver.builder().tag("amount", Tag.inserting((Component)Component.text((int)comments.length))).tag("cur", Tag.inserting((Component)Component.text((int)(page + 1)))).tag("max", Tag.inserting((Component)Component.text((int)(totalPages + 1)))).tag("word", Tag.inserting((Component)Component.text((String)"all"))).build()));
        for (int x = page * 12; x < max; ++x) {
            PlotComment comment = comments[x];
            Component commentColored = player.getName().equals(comment.senderName()) ? MINI_MESSAGE.deserialize(TranslatableCaption.of("list.comment_list_by_lister").getComponent(player), (TagResolver)TagResolver.resolver((String)"comment", (Tag)Tag.inserting((Component)Component.text((String)comment.comment())))) : MINI_MESSAGE.deserialize(TranslatableCaption.of("list.comment_list_by_other").getComponent(player), (TagResolver)TagResolver.resolver((String)"comment", (Tag)Tag.inserting((Component)Component.text((String)comment.comment()))));
            TagResolver resolver = TagResolver.builder().tag("number", Tag.inserting((Component)Component.text((int)x))).tag("world", Tag.inserting((Component)Component.text((String)comment.world()))).tag("plot_id", Tag.inserting((Component)Component.text((String)(comment.id().getX() + ";" + comment.id().getY())))).tag("commenter", Tag.inserting((Component)Component.text((String)comment.senderName()))).tag("comment", Tag.inserting((Component)commentColored)).build();
            builder.append(MINI_MESSAGE.deserialize(TranslatableCaption.of("list.comment_list_comment").getComponent(player), resolver));
        }
        player.sendMessage(StaticCaption.of((String)MINI_MESSAGE.serialize((Component)builder.build())), new TagResolver[0]);
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        int page;
        final Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (args.length == 0) {
            this.sendUsage(player);
            for (final CommentInbox inbox : CommentManager.inboxes.values()) {
                if (!inbox.canRead(plot, player) || inbox.getComments(plot, new RunnableVal<List<PlotComment>>(){

                    @Override
                    public void run(List<PlotComment> value) {
                        if (value != null) {
                            int total = 0;
                            int unread = 0;
                            for (PlotComment comment : value) {
                                ++total;
                                if (comment.timestamp() <= CommentManager.getTimestamp(player, inbox.toString())) continue;
                                ++unread;
                            }
                            if (total != 0) {
                                player.sendMessage(TranslatableCaption.of("comment.inbox_item"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)(inbox + " (" + total + "/" + unread + ")"))))});
                                return;
                            }
                        }
                        player.sendMessage(TranslatableCaption.of("comment.inbox_item"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)inbox.toString())))});
                    }
                })) continue;
                player.sendMessage(TranslatableCaption.of("comment.inbox_item"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)inbox.toString())))});
            }
            return false;
        }
        final CommentInbox inbox = CommentManager.inboxes.get(args[0].toLowerCase());
        if (inbox == null) {
            player.sendMessage(TranslatableCaption.of("comment.invalid_inbox"), new TagResolver[]{TagResolver.resolver((String)"list", (Tag)Tag.inserting((Component)Component.text((String)StringMan.join(CommentManager.inboxes.keySet(), ", "))))});
            return false;
        }
        MetaDataKey<Long> metaDataKey = MetaDataKey.of(String.format("inbox:%s", inbox), new TypeLiteral<Long>(){});
        try (MetaDataAccess<Long> metaDataAccess = player.accessTemporaryMetaData(metaDataKey);){
            metaDataAccess.set(System.currentTimeMillis());
        }
        if (args.length > 1) {
            switch (args[1].toLowerCase()) {
                case "delete": {
                    int index;
                    if (!inbox.canModify(plot, player)) {
                        player.sendMessage(TranslatableCaption.of("comment.no_perm_inbox_modify"), new TagResolver[0]);
                        return false;
                    }
                    if (args.length != 3) {
                        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)("/plot inbox " + inbox + " delete <index>"))))});
                        return true;
                    }
                    try {
                        index = Integer.parseInt(args[2]);
                        if (index < 1) {
                            player.sendMessage(TranslatableCaption.of("comment.not_valid_inbox_index"), new TagResolver[]{TagResolver.resolver((String)"number", (Tag)Tag.inserting((Component)Component.text((int)index)))});
                            return false;
                        }
                    }
                    catch (NumberFormatException ignored) {
                        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)("/plot inbox " + inbox + " delete <index>"))))});
                        return false;
                    }
                    if (!inbox.getComments(plot, new RunnableVal<List<PlotComment>>(){

                        @Override
                        public void run(List<PlotComment> value) {
                            if (index > value.size()) {
                                player.sendMessage(TranslatableCaption.of("comment.not_valid_inbox_index"), new TagResolver[]{TagResolver.resolver((String)"number", (Tag)Tag.inserting((Component)Component.text((int)index)))});
                                return;
                            }
                            PlotComment comment = value.get(index - 1);
                            inbox.removeComment(plot, comment);
                            boolean success = plot.getPlotCommentContainer().removeComment(comment);
                            if (success) {
                                player.sendMessage(TranslatableCaption.of("comment.comment_removed_success"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)comment.comment())))});
                            } else {
                                player.sendMessage(TranslatableCaption.of("comment.comment_removed_failure"), new TagResolver[0]);
                            }
                        }
                    })) {
                        player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                        return false;
                    }
                    return true;
                }
                case "clear": {
                    if (!inbox.canModify(plot, player)) {
                        player.sendMessage(TranslatableCaption.of("comment.no_perm_inbox_modify"), new TagResolver[0]);
                    }
                    inbox.clearInbox(plot);
                    List<PlotComment> comments = plot.getPlotCommentContainer().getComments(inbox.toString());
                    if (!comments.isEmpty()) {
                        player.sendMessage(TranslatableCaption.of("comment.comment_removed_success"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"*")))});
                        plot.getPlotCommentContainer().removeComments(comments);
                    }
                    return true;
                }
            }
            try {
                page = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ignored) {
                this.sendUsage(player);
                return false;
            }
        }
        page = 1;
        if (!inbox.canRead(plot, player)) {
            player.sendMessage(TranslatableCaption.of("comment.no_perm_inbox"), new TagResolver[0]);
            return false;
        }
        if (!inbox.getComments(plot, new RunnableVal<List<PlotComment>>(){

            @Override
            public void run(List<PlotComment> value) {
                Inbox.this.displayComments(player, value, page);
            }
        })) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (player.hasPermission(Permission.PERMISSION_INBOX_READ_OWNER)) {
                completions.add("owner");
            }
            if (player.hasPermission(Permission.PERMISSION_INBOX_READ_PUBLIC)) {
                completions.add("public");
            }
            if (player.hasPermission(Permission.PERMISSION_INBOX_READ_REPORT)) {
                completions.add("report");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.PLAYER, CommandCategory.CHAT){}).collect(Collectors.toCollection(LinkedList::new));
            if (player.hasPermission(Permission.PERMISSION_INBOX) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

