/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.sk89q.worldedit.math.BlockVector2;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="debugexec", permission="plots.admin", aliases={"exec", "$"}, category=CommandCategory.DEBUG)
public class DebugExec
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final HybridUtils hybridUtils;

    @Inject
    public DebugExec(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull HybridUtils hybridUtils) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        List<String> allowedParams = Arrays.asList("analyze", "calibrate-analysis", "start-expire", "stop-expire", "remove-flag", "start-rgar", "stop-rgar");
        if (args.length > 0) {
            String arg;
            switch (arg = args[0].toLowerCase()) {
                case "analyze": {
                    Plot plot = player.getCurrentPlot();
                    if (plot == null) {
                        player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                        return false;
                    }
                    PlotAnalysis analysis = plot.getComplexity(null);
                    if (analysis != null) {
                        player.sendMessage(TranslatableCaption.of("debugexec.changes_column"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((int)analysis.changes)))});
                        return true;
                    }
                    player.sendMessage(TranslatableCaption.of("debugexec.starting_task"), new TagResolver[0]);
                    this.hybridUtils.analyzePlot(plot, new RunnableVal<PlotAnalysis>(){

                        @Override
                        public void run(PlotAnalysis value) {
                            player.sendMessage(TranslatableCaption.of("debugexec.analyze_done"), new TagResolver[]{TagResolver.resolver((String)"command", (Tag)Tag.inserting((Component)Component.text((String)"/plot debugexec analyze")))});
                        }
                    });
                    return true;
                }
                case "calibrate-analysis": {
                    double threshold;
                    if (args.length != 2) {
                        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot debugexec analyze <threshold>")))});
                        player.sendMessage(TranslatableCaption.of("debugexec.threshold_default"), new TagResolver[0]);
                        return false;
                    }
                    try {
                        threshold = (double)Integer.parseInt(args[1]) / 100.0;
                    }
                    catch (NumberFormatException ignored) {
                        player.sendMessage(TranslatableCaption.of("debugexec.invalid_threshold"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                        player.sendMessage(TranslatableCaption.of("debugexec.threshold_default_double"), new TagResolver[0]);
                        return false;
                    }
                    PlotAnalysis.calcOptimalModifiers(() -> player.sendMessage(TranslatableCaption.of("debugexec.calibration_done"), new TagResolver[0]), threshold);
                    return true;
                }
                case "start-expire": {
                    if (PlotSquared.platform().expireManager().runAutomatedTask()) {
                        player.sendMessage(TranslatableCaption.of("debugexec.expiry_started"), new TagResolver[0]);
                    } else {
                        player.sendMessage(TranslatableCaption.of("debugexec.expiry_already_started"), new TagResolver[0]);
                    }
                    return true;
                }
                case "stop-expire": {
                    if (!PlotSquared.platform().expireManager().cancelTask()) {
                        player.sendMessage(TranslatableCaption.of("debugexec.task_halted"), new TagResolver[0]);
                    } else {
                        player.sendMessage(TranslatableCaption.of("debugexec.task_cancelled"), new TagResolver[0]);
                    }
                    return true;
                }
                case "remove-flag": {
                    if (args.length != 2) {
                        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot debugexec remove-flag <flag>")))});
                        return false;
                    }
                    String flag = args[1];
                    PlotFlag<?, ?> flagInstance = GlobalFlagContainer.getInstance().getFlagFromString(flag);
                    if (flagInstance != null) {
                        for (Plot plot : PlotQuery.newQuery().whereBasePlot()) {
                            PlotFlagRemoveEvent event = this.eventDispatcher.callFlagRemove(flagInstance, plot);
                            if (event.getEventResult() == Result.DENY) continue;
                            plot.removeFlag(event.getFlag());
                        }
                    }
                    player.sendMessage(TranslatableCaption.of("debugexec.cleared_flag"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)flag)))});
                    return true;
                }
                case "start-rgar": {
                    if (args.length != 2) {
                        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Invalid syntax: /plot debugexec start-rgar <world>")))});
                        return false;
                    }
                    PlotArea area = this.plotAreaManager.getPlotAreaByString(args[1]);
                    if (area == null) {
                        player.sendMessage(TranslatableCaption.of("errors.not_valid_plot_world"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[1])))});
                        return false;
                    }
                    boolean result = HybridUtils.regions != null ? this.hybridUtils.scheduleRoadUpdate(area, HybridUtils.regions, 0, new LinkedHashSet<BlockVector2>()) : this.hybridUtils.scheduleRoadUpdate(area, 0);
                    if (!result) {
                        player.sendMessage(TranslatableCaption.of("debugexec.mass_schematic_update_in_progress"), new TagResolver[0]);
                        return false;
                    }
                    return true;
                }
                case "stop-rgar": {
                    if (!HybridUtils.UPDATE) {
                        player.sendMessage(TranslatableCaption.of("debugexec.task_not_running"), new TagResolver[0]);
                        return false;
                    }
                    HybridUtils.UPDATE = false;
                    player.sendMessage(TranslatableCaption.of("debugexec.task_cancelled"), new TagResolver[0]);
                    return true;
                }
            }
        }
        player.sendMessage(StaticCaption.of("<prefix><gold>Possible sub commands: </gold><gray>/plot debugexec <" + StringMan.join(allowedParams, " | ") + "></gray>"), new TagResolver[0]);
        return false;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return Stream.of("analyze", "calibrate-analysis", "start-expire", "stop-expire", "remove-flag", "start-rgar", "stop-rgar").filter(value -> value.startsWith(args[0].toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, (String)value, "plots.admin", RequiredType.NONE, null){}).collect(Collectors.toList());
    }
}

