/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@CommandDeclaration(command="copy", permission="plots.copy", aliases={"copypaste"}, category=CommandCategory.CLAIMING, usage="/plot copy <X;Z>", requiredType=RequiredType.NONE)
public class Copy
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocation();
        Plot plot1 = location.getPlotAbs();
        if (plot1 == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot1.isOwner(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_ADMIN.toString())) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        if (args.length != 1) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot copy <X;Z>")))});
            return false;
        }
        Plot plot2 = Plot.getPlotFromString(player, args[0], true);
        if (plot2 == null) {
            return false;
        }
        if (plot1.equals(plot2)) {
            player.sendMessage(TranslatableCaption.of("invalid.origin_cant_be_target"), new TagResolver[0]);
            return false;
        }
        if (!plot1.getArea().isCompatible(plot2.getArea())) {
            player.sendMessage(TranslatableCaption.of("errors.plotworld_incompatible"), new TagResolver[0]);
            return false;
        }
        plot1.getPlotModificationManager().copy(plot2, player).thenAccept(result -> {
            if (result.booleanValue()) {
                player.sendMessage(TranslatableCaption.of("move.copy_success"), TagResolver.builder().tag("origin", Tag.inserting((Component)Component.text((String)plot1.toString()))).tag("target", Tag.inserting((Component)Component.text((String)plot2.toString()))).build());
            } else {
                player.sendMessage(TranslatableCaption.of("move.requires_unowned"), new TagResolver[0]);
            }
        });
        return true;
    }
}

