/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.PriceFlag;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="buy", usage="/plot buy", permission="plots.buy", category=CommandCategory.CLAIMING, requiredType=RequiredType.NONE)
public class Buy
extends Command {
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;

    @Inject
    public Buy(@NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Plot plot;
        PlotArea area = player.getPlotAreaAbs();
        this.check(area, TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
        this.check(this.econHandler.isEnabled(area), TranslatableCaption.of("economy.econ_disabled"), new TagResolver[0]);
        if (args.length != 0) {
            if (args.length != 1) {
                this.sendUsage(player);
                return CompletableFuture.completedFuture(false);
            }
            plot = this.check(Plot.getPlotFromString(player, args[0], true), null, new TagResolver[0]);
        } else {
            plot = this.check(player.getCurrentPlot(), TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
        }
        this.checkTrue(plot.hasOwner(), TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
        this.checkTrue(!plot.isOwner(player.getUUID()), TranslatableCaption.of("economy.cannot_buy_own"), new TagResolver[0]);
        Set<Plot> plots = plot.getConnectedPlots();
        this.checkTrue(player.getPlotCount() + plots.size() <= player.getAllowedPlots(), TranslatableCaption.of("permission.cant_claim_more_plots"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)player.getAllowedPlots())))});
        double price = (Double)plot.getFlag(PriceFlag.class);
        if (price <= 0.0) {
            throw new Command.CommandException(TranslatableCaption.of("economy.not_for_sale"), new TagResolver[0]);
        }
        this.checkTrue(this.econHandler.isSupported(), TranslatableCaption.of("economy.vault_or_consumer_null"), new TagResolver[0]);
        this.checkTrue(this.econHandler.getMoney(player) >= price, TranslatableCaption.of("economy.cannot_afford_plot"), TagResolver.builder().tag("money", Tag.inserting((Component)Component.text((String)this.econHandler.format(price)))).tag("balance", Tag.inserting((Component)Component.text((String)this.econHandler.format(this.econHandler.getMoney(player))))).build());
        this.econHandler.withdrawMoney(player, price);
        confirm.run(this, () -> {
            PriceFlag plotFlag;
            PlotFlagRemoveEvent event;
            player.sendMessage(TranslatableCaption.of("economy.removed_balance"), new TagResolver[]{TagResolver.resolver((String)"money", (Tag)Tag.inserting((Component)Component.text((String)this.econHandler.format(price))))});
            this.econHandler.depositMoney(PlotSquared.platform().playerManager().getOfflinePlayer(plot.getOwnerAbs()), price);
            PlotPlayer<?> owner = PlotSquared.platform().playerManager().getPlayerIfExists(plot.getOwnerAbs());
            if (owner != null) {
                owner.sendMessage(TranslatableCaption.of("economy.plot_sold"), TagResolver.builder().tag("plot", Tag.inserting((Component)Component.text((String)plot.getId().toString()))).tag("player", Tag.inserting((Component)Component.text((String)player.getName()))).tag("price", Tag.inserting((Component)Component.text((String)this.econHandler.format(price)))).build());
            }
            if ((event = this.eventDispatcher.callFlagRemove(plotFlag = plot.getFlagContainer().getFlag(PriceFlag.class), plot)).getEventResult() != Result.DENY) {
                plot.removeFlag(event.getFlag());
            }
            plot.setOwner(player.getUUID());
            plot.getPlotModificationManager().setSign(player.getName());
            player.sendMessage(TranslatableCaption.of("working.claimed"), new TagResolver[]{TagResolver.resolver((String)"plot", (Tag)Tag.inserting((Component)Component.text((String)plot.getId().toString())))});
            whenDone.run(this, Command.CommandResult.SUCCESS);
        }, () -> {
            this.econHandler.depositMoney(player, price);
            whenDone.run(this, Command.CommandResult.FAILURE);
        });
        return CompletableFuture.completedFuture(true);
    }
}

