/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.collection;

import com.google.common.base.Preconditions;
import com.plotsquared.core.collection.FlatRandomCollection;
import com.plotsquared.core.collection.SimpleRandomCollection;
import java.util.Map;
import java.util.Random;

public abstract class RandomCollection<T> {
    protected Random random;

    public RandomCollection(Map<T, Double> weights, Random random) {
        this.random = random;
    }

    public static <T> RandomCollection<T> of(Map<T, Double> weights, Random random) {
        try {
            return new FlatRandomCollection<T>(weights, random);
        }
        catch (IllegalArgumentException ignore) {
            return new SimpleRandomCollection<T>(weights, random);
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        Preconditions.checkNotNull((Object)random);
        this.random = random;
    }

    public abstract T next();
}

