/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.google.inject.Inject;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DisablePhysicsFlag;
import com.plotsquared.core.plot.flag.implementations.RedstoneFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.PlotFlagUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.WorldEdit;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HighFreqBlockEventListener
implements Listener {
    private static final Set<Material> PISTONS = Set.of(Material.PISTON, Material.STICKY_PISTON);
    private static final Set<Material> PHYSICS_BLOCKS = Set.of(Material.TURTLE_EGG, Material.TURTLE_SPAWN_EGG);
    private final PlotAreaManager plotAreaManager;
    private final WorldEdit worldEdit;

    @Inject
    public HighFreqBlockEventListener(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldEdit worldEdit) {
        this.plotAreaManager = plotAreaManager;
        this.worldEdit = worldEdit;
    }

    public static void sendBlockChange(org.bukkit.Location bloc, BlockData data) {
        TaskManager.runTaskLater(() -> {
            String world = bloc.getWorld().getName();
            int x = bloc.getBlockX();
            int z = bloc.getBlockZ();
            int distance = Bukkit.getViewDistance() * 16;
            for (PlotPlayer player : PlotSquared.platform().playerManager().getPlayers()) {
                Location location = player.getLocation();
                if (!location.getWorldName().equals(world) || 16 * Math.abs(location.getX() - x) / 16 > distance || 16 * Math.abs(location.getZ() - z) / 16 > distance) continue;
                ((BukkitPlayer)player).player.sendBlockChange(bloc, data);
            }
        }, (TaskTime)TaskTime.ticks((long)3L));
    }

    @EventHandler
    public void onRedstoneEvent(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals((PlotArea)area, RedstoneFlag.class, (Object)false)) {
                event.setNewCurrent(0);
            }
            return;
        }
        if (!((Boolean)plot.getFlag(RedstoneFlag.class)).booleanValue()) {
            event.setNewCurrent(0);
            plot.debug("Redstone event was cancelled because redstone = false");
            return;
        }
        if (Settings.Redstone.DISABLE_OFFLINE) {
            boolean disable = false;
            if (!DBFunc.SERVER.equals(plot.getOwner())) {
                if (plot.isMerged()) {
                    disable = true;
                    for (UUID owner : plot.getOwners()) {
                        if (PlotSquared.platform().playerManager().getPlayerIfExists(owner) == null) continue;
                        disable = false;
                        break;
                    }
                } else {
                    boolean bl = disable = PlotSquared.platform().playerManager().getPlayerIfExists(plot.getOwnerAbs()) == null;
                }
            }
            if (disable) {
                for (UUID trusted : plot.getTrusted()) {
                    if (PlotSquared.platform().playerManager().getPlayerIfExists(trusted) == null) continue;
                    disable = false;
                    break;
                }
                if (disable) {
                    event.setNewCurrent(0);
                    plot.debug("Redstone event was cancelled because no trusted player was in the plot");
                    return;
                }
            }
        }
        if (Settings.Redstone.DISABLE_UNOCCUPIED) {
            for (PlotPlayer player : PlotSquared.platform().playerManager().getPlayers()) {
                if (!plot.equals((Object)player.getCurrentPlot())) continue;
                return;
            }
            event.setNewCurrent(0);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPhysicsEvent(BlockPhysicsEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlotAbs(location);
        if (plot == null) {
            return;
        }
        if (event.getChangedType().hasGravity() && ((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
            event.setCancelled(true);
            HighFreqBlockEventListener.sendBlockChange(event.getBlock().getLocation(), event.getBlock().getBlockData());
            plot.debug("Prevented block physics and resent block change because disable-physics = true");
            return;
        }
        if (event.getChangedType() == Material.COMPARATOR) {
            if (!((Boolean)plot.getFlag(RedstoneFlag.class)).booleanValue()) {
                event.setCancelled(true);
                plot.debug("Prevented comparator update because redstone = false");
            }
            return;
        }
        if (PHYSICS_BLOCKS.contains(event.getChangedType())) {
            if (((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
                event.setCancelled(true);
                plot.debug("Prevented block physics because disable-physics = true");
            }
            return;
        }
        if (Settings.Redstone.DETECT_INVALID_EDGE_PISTONS && PISTONS.contains(block.getType())) {
            Directional piston = (Directional)block.getBlockData();
            BlockFace facing = piston.getFacing();
            Plot newPlot = area.getOwnedPlotAbs(location = location.add(facing.getModX(), facing.getModY(), facing.getModZ()));
            if (plot.equals((Object)newPlot)) {
                return;
            }
            if (!plot.isMerged() || !plot.getConnectedPlots().contains(newPlot)) {
                event.setCancelled(true);
                plot.debug("Prevented piston update because of invalid edge piston detection");
            }
        }
    }
}

