/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.entity;

import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.entity.EntityWrapper;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class TeleportEntityWrapper
extends EntityWrapper {
    private Location oldLocation;
    private boolean gravityOld;
    private boolean invulnerableOld;
    private int fireTicksOld;
    private int livingTicksOld;

    public TeleportEntityWrapper(Entity entity) {
        super(entity);
    }

    @Override
    public Entity spawn(World world, int xOffset, int zOffset) {
        if (!this.getEntity().getLocation().getChunk().equals((Object)this.oldLocation.getChunk())) {
            Location oldLocation = this.oldLocation.clone();
            oldLocation.add((double)xOffset, 0.0, (double)xOffset);
            this.getEntity().teleport(oldLocation);
            this.getEntity().setGravity(this.gravityOld);
            this.getEntity().setInvulnerable(this.invulnerableOld);
            this.getEntity().setFireTicks(this.fireTicksOld);
            this.getEntity().setTicksLived(this.livingTicksOld);
            this.getEntity().removeMetadata("ps-tmp-teleport", (Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class));
        }
        return this.getEntity();
    }

    @Override
    public void saveEntity() {
        this.oldLocation = this.getEntity().hasMetadata("ps-tmp-teleport") ? (Location)this.getEntity().getMetadata("ps-tmp-teleport").get(0) : this.getEntity().getLocation();
        this.oldLocation = this.oldLocation.clone();
        this.oldLocation.setX(this.getX());
        this.oldLocation.setY(this.getY());
        this.oldLocation.setZ(this.getZ());
        this.gravityOld = this.getEntity().hasGravity();
        this.getEntity().setGravity(false);
        this.invulnerableOld = this.getEntity().isInvulnerable();
        this.getEntity().setInvulnerable(true);
        this.fireTicksOld = this.getEntity().getFireTicks();
        this.livingTicksOld = this.getEntity().getTicksLived();
        this.getEntity().setMetadata("ps-tmp-teleport", (MetadataValue)new FixedMetadataValue((Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class), (Object)this.oldLocation));
        Chunk newChunk = this.getNewChunk();
        this.getEntity().teleport(new Location(newChunk.getWorld(), (double)(newChunk.getX() << 4), 5000.0, (double)(newChunk.getZ() << 4)));
    }

    private Chunk getNewChunk() {
        Chunk oldChunk = this.oldLocation.getChunk();
        Chunk chunk = null;
        for (Chunk lChunk : oldChunk.getWorld().getLoadedChunks()) {
            if (lChunk.equals((Object)oldChunk) || !lChunk.isLoaded()) continue;
            chunk = lChunk;
            break;
        }
        if (chunk == null) {
            for (int dx = 1; dx < Integer.MAX_VALUE; ++dx) {
                for (int dz = 0; !(dz >= Integer.MAX_VALUE || (chunk = this.getChunkRelative(oldChunk, dx, dz)).isLoaded() || (chunk = this.getChunkRelative(oldChunk, -dx, dz)).isLoaded() || (chunk = this.getChunkRelative(oldChunk, dx, -dz)).isLoaded() || (chunk = this.getChunkRelative(oldChunk, -dx, -dz)).isLoaded()); ++dz) {
                }
            }
        }
        return chunk;
    }

    private Chunk getChunkRelative(Chunk chunk, int dx, int dz) {
        return chunk.getWorld().getChunkAt(chunk.getX() + dx, chunk.getZ() + dz);
    }
}

