/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.util.ReflectionUtils;
import java.lang.reflect.Method;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkEvent;
import org.bukkit.event.world.ChunkLoadEvent;

public class SingleWorldListener
implements Listener {
    private final Method methodSetUnsaved;
    private Method methodGetHandleChunk;
    private Object objChunkStatusFull = null;

    public SingleWorldListener() throws Exception {
        ReflectionUtils.RefClass classCraftChunk = ReflectionUtils.getRefClass((String)"{cb}.CraftChunk");
        ReflectionUtils.RefClass classChunkAccess = ReflectionUtils.getRefClass((String)"net.minecraft.world.level.chunk.IChunkAccess");
        this.methodSetUnsaved = classChunkAccess.getMethod("a", new Object[]{Boolean.TYPE}).getRealMethod();
        try {
            this.methodGetHandleChunk = classCraftChunk.getMethod("getHandle", new Object[0]).getRealMethod();
        }
        catch (NoSuchMethodException ignored) {
            try {
                ReflectionUtils.RefClass classChunkStatus = ReflectionUtils.getRefClass((String)"net.minecraft.world.level.chunk.ChunkStatus");
                this.objChunkStatusFull = classChunkStatus.getRealClass().getField("n").get(null);
                this.methodGetHandleChunk = classCraftChunk.getMethod("getHandle", new Object[]{classChunkStatus.getRealClass()}).getRealMethod();
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void markChunkAsClean(Chunk chunk) {
        try {
            Object nmsChunk = this.objChunkStatusFull != null ? this.methodGetHandleChunk.invoke((Object)chunk, this.objChunkStatusFull) : this.methodGetHandleChunk.invoke((Object)chunk, new Object[0]);
            this.methodSetUnsaved.invoke(nmsChunk, false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void handle(ChunkEvent event) {
        World world = event.getWorld();
        String name = world.getName();
        PlotAreaManager man = PlotSquared.get().getPlotAreaManager();
        if (!(man instanceof SinglePlotAreaManager)) {
            return;
        }
        if (!SinglePlotArea.isSinglePlotWorld((String)name)) {
            return;
        }
        int x = event.getChunk().getX();
        int z = event.getChunk().getZ();
        if (x < 16 && x > -16 && z < 16 && z > -16) {
            return;
        }
        this.markChunkAsClean(event.getChunk());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChunkLoad(ChunkLoadEvent event) {
    }
}

