/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.util.ReflectionUtils;
import com.plotsquared.core.util.task.PlotSquaredTask;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import io.papermc.lib.PaperLib;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ChunkListener
implements Listener {
    private final PlotAreaManager plotAreaManager;
    private final int version;
    private ReflectionUtils.RefMethod methodSetUnsaved;
    private ReflectionUtils.RefMethod methodGetHandleChunk;
    private ReflectionUtils.RefMethod methodGetHandleWorld;
    private ReflectionUtils.RefField mustNotSave;
    private Object objChunkStatusFull;
    private Chunk lastChunk;
    private boolean ignoreUnload;

    @Inject
    public ChunkListener(@NonNull PlotAreaManager plotAreaManager) {
        block12: {
            this.objChunkStatusFull = null;
            this.ignoreUnload = false;
            this.plotAreaManager = plotAreaManager;
            this.version = PlotSquared.platform().serverVersion()[1];
            if (!Settings.Chunk_Processor.AUTO_TRIM) {
                return;
            }
            try {
                ReflectionUtils.RefClass classCraftWorld = ReflectionUtils.getRefClass((String)"{cb}.CraftWorld");
                ReflectionUtils.RefClass classCraftChunk = ReflectionUtils.getRefClass((String)"{cb}.CraftChunk");
                ReflectionUtils.RefClass classChunkAccess = ReflectionUtils.getRefClass((String)"net.minecraft.world.level.chunk.IChunkAccess");
                this.methodSetUnsaved = classChunkAccess.getMethod("a", new Object[]{Boolean.TYPE});
                try {
                    this.methodGetHandleChunk = classCraftChunk.getMethod("getHandle", new Object[0]);
                }
                catch (NoSuchMethodException ignored) {
                    try {
                        ReflectionUtils.RefClass classChunkStatus = ReflectionUtils.getRefClass((String)"net.minecraft.world.level.chunk.ChunkStatus");
                        this.objChunkStatusFull = classChunkStatus.getRealClass().getField("n").get(null);
                        this.methodGetHandleChunk = classCraftChunk.getMethod("getHandle", new Object[]{classChunkStatus.getRealClass()});
                    }
                    catch (NoSuchMethodException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                try {
                    ReflectionUtils.RefClass classChunk;
                    if (this.version < 17) {
                        classChunk = ReflectionUtils.getRefClass((String)"{nms}.Chunk");
                        this.mustNotSave = classChunk.getField("mustNotSave");
                        break block12;
                    }
                    classChunk = ReflectionUtils.getRefClass((String)"net.minecraft.world.level.chunk.Chunk");
                    this.mustNotSave = classChunk.getField("mustNotSave");
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable ignored) {
                Settings.Chunk_Processor.AUTO_TRIM = false;
            }
        }
        for (World world : Bukkit.getWorlds()) {
            world.setAutoSave(false);
        }
        if (this.version > 13) {
            return;
        }
        TaskManager.runTaskRepeat(() -> {
            try {
                HashSet<Chunk> toUnload = new HashSet<Chunk>();
                for (World world : Bukkit.getWorlds()) {
                    Chunk[] chunks;
                    String worldName = world.getName();
                    if (!this.plotAreaManager.hasPlotArea(worldName)) continue;
                    Object craftWorld = this.methodGetHandleWorld.of((Object)world).call(new Object[0]);
                    if (this.version != 13) continue;
                    Object chunkMap = craftWorld.getClass().getDeclaredMethod("getPlayerChunkMap", new Class[0]).invoke(craftWorld, new Object[0]);
                    Method methodIsChunkInUse = chunkMap.getClass().getDeclaredMethod("isChunkInUse", Integer.TYPE, Integer.TYPE);
                    for (Chunk chunk : chunks = world.getLoadedChunks()) {
                        int z;
                        if (((Boolean)methodIsChunkInUse.invoke(chunkMap, chunk.getX(), chunk.getZ())).booleanValue()) continue;
                        int x = chunk.getX();
                        if (!this.shouldSave(worldName, x, z = chunk.getZ())) {
                            this.unloadChunk(worldName, chunk, false);
                            continue;
                        }
                        toUnload.add(chunk);
                    }
                }
                if (toUnload.isEmpty()) {
                    return;
                }
                long start = System.currentTimeMillis();
                for (Chunk chunk : toUnload) {
                    if (System.currentTimeMillis() - start > 5L) {
                        return;
                    }
                    chunk.unload(true);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, (TaskTime)TaskTime.ticks((long)1L));
    }

    public boolean unloadChunk(String world, Chunk chunk, boolean safe) {
        if (safe && this.shouldSave(world, chunk.getX(), chunk.getZ())) {
            return false;
        }
        Object c = this.objChunkStatusFull != null ? this.methodGetHandleChunk.of((Object)chunk).call(new Object[]{this.objChunkStatusFull}) : this.methodGetHandleChunk.of((Object)chunk).call(new Object[0]);
        ReflectionUtils.RefField.RefExecutor field = this.mustNotSave.of(c);
        this.methodSetUnsaved.of(c).call(new Object[]{false});
        if (!((Boolean)field.get()).booleanValue()) {
            field.set((Object)true);
            if (chunk.isLoaded()) {
                this.ignoreUnload = true;
                chunk.unload(false);
                this.ignoreUnload = false;
            }
        }
        return true;
    }

    public boolean shouldSave(String world, int chunkX, int chunkZ) {
        Plot plot;
        int x = chunkX << 4;
        int z = chunkZ << 4;
        int x2 = x + 15;
        int z2 = z + 15;
        Location loc = Location.at((String)world, (int)x, (int)1, (int)z);
        PlotArea plotArea = this.plotAreaManager.getPlotArea(loc);
        if (plotArea != null && (plot = plotArea.getPlot(loc)) != null && plot.hasOwner()) {
            return true;
        }
        loc = Location.at((String)world, (int)x2, (int)1, (int)z2);
        plotArea = this.plotAreaManager.getPlotArea(loc);
        if (plotArea != null && (plot = plotArea.getPlot(loc)) != null && plot.hasOwner()) {
            return true;
        }
        loc = Location.at((String)world, (int)x2, (int)1, (int)z);
        plotArea = this.plotAreaManager.getPlotArea(loc);
        if (plotArea != null && (plot = plotArea.getPlot(loc)) != null && plot.hasOwner()) {
            return true;
        }
        loc = Location.at((String)world, (int)x, (int)1, (int)z2);
        plotArea = this.plotAreaManager.getPlotArea(loc);
        if (plotArea != null && (plot = plotArea.getPlot(loc)) != null && plot.hasOwner()) {
            return true;
        }
        loc = Location.at((String)world, (int)(x + 7), (int)1, (int)(z + 7));
        plotArea = this.plotAreaManager.getPlotArea(loc);
        if (plotArea == null) {
            return false;
        }
        plot = plotArea.getPlot(loc);
        return plot != null && plot.hasOwner();
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (this.ignoreUnload) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (Settings.Chunk_Processor.AUTO_TRIM) {
            String world = chunk.getWorld().getName();
            if ((!Settings.Enabled_Components.WORLDS || !SinglePlotArea.isSinglePlotWorld((String)world)) && this.plotAreaManager.hasPlotArea(world) && this.unloadChunk(world, chunk, true)) {
                return;
            }
        }
        if (this.processChunk(event.getChunk(), true)) {
            chunk.setForceLoaded(true);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        this.processChunk(event.getChunk(), false);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent event) {
        Item entity = event.getEntity();
        PaperLib.getChunkAtAsync((org.bukkit.Location)event.getLocation()).thenAccept(chunk -> {
            if (chunk == this.lastChunk) {
                event.getEntity().remove();
                event.setCancelled(true);
                return;
            }
            if (!this.plotAreaManager.hasPlotArea(chunk.getWorld().getName())) {
                return;
            }
            Entity[] entities = chunk.getEntities();
            if (entities.length > Settings.Chunk_Processor.MAX_ENTITIES) {
                event.getEntity().remove();
                event.setCancelled(true);
                this.lastChunk = chunk;
            } else {
                this.lastChunk = null;
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (Settings.Chunk_Processor.DISABLE_PHYSICS) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        PaperLib.getChunkAtAsync((org.bukkit.Location)event.getLocation()).thenAccept(chunk -> {
            if (chunk == this.lastChunk) {
                event.getEntity().remove();
                event.setCancelled(true);
                return;
            }
            if (!this.plotAreaManager.hasPlotArea(chunk.getWorld().getName())) {
                return;
            }
            Entity[] entities = chunk.getEntities();
            if (entities.length > Settings.Chunk_Processor.MAX_ENTITIES) {
                event.getEntity().remove();
                event.setCancelled(true);
                this.lastChunk = chunk;
            } else {
                this.lastChunk = null;
            }
        });
    }

    private void cleanChunk(Chunk chunk) {
        int currentIndex = TaskManager.index.incrementAndGet();
        PlotSquaredTask task = TaskManager.runTaskRepeat(() -> {
            if (!chunk.isLoaded()) {
                Objects.requireNonNull(TaskManager.removeTask((int)currentIndex)).cancel();
                chunk.unload(true);
                return;
            }
            BlockState[] tiles = chunk.getTileEntities();
            if (tiles.length == 0) {
                Objects.requireNonNull(TaskManager.removeTask((int)currentIndex)).cancel();
                chunk.unload(true);
                return;
            }
            long start = System.currentTimeMillis();
            int i = 0;
            while (System.currentTimeMillis() - start < 250L) {
                if (i >= tiles.length - Settings.Chunk_Processor.MAX_TILES) {
                    Objects.requireNonNull(TaskManager.removeTask((int)currentIndex)).cancel();
                    chunk.unload(true);
                    return;
                }
                tiles[i].getBlock().setType(Material.AIR, false);
                ++i;
            }
        }, (TaskTime)TaskTime.ticks((long)5L));
        TaskManager.addTask((PlotSquaredTask)task, (int)currentIndex);
    }

    public boolean processChunk(Chunk chunk, boolean unload) {
        if (!this.plotAreaManager.hasPlotArea(chunk.getWorld().getName())) {
            return false;
        }
        Entity[] entities = chunk.getEntities();
        BlockState[] tiles = chunk.getTileEntities();
        if (entities.length > Settings.Chunk_Processor.MAX_ENTITIES) {
            int toRemove = entities.length - Settings.Chunk_Processor.MAX_ENTITIES;
            int index = 0;
            while (toRemove > 0 && index < entities.length) {
                Entity entity;
                if ((entity = entities[index++]) instanceof Player) continue;
                entity.remove();
                --toRemove;
            }
        }
        if (tiles.length > Settings.Chunk_Processor.MAX_TILES) {
            if (unload) {
                this.cleanChunk(chunk);
                return true;
            }
            for (int i = 0; i < tiles.length - Settings.Chunk_Processor.MAX_TILES; ++i) {
                tiles[i].getBlock().setType(Material.AIR, false);
            }
        }
        return false;
    }
}

